/*
 * Decompiled with CFR 0.152.
 */
package net.bunten.enderscape.client;

import com.google.common.reflect.Reflection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.bunten.enderscape.Enderscape;
import net.bunten.enderscape.client.block.MagniaSproutRenderer;
import net.bunten.enderscape.client.hud.HudElement;
import net.bunten.enderscape.client.item.FueledToolTooltip;
import net.bunten.enderscape.client.registry.EnderscapeBlockColorProviders;
import net.bunten.enderscape.client.registry.EnderscapeBlockRenderLayerMap;
import net.bunten.enderscape.client.registry.EnderscapeClientNetworking;
import net.bunten.enderscape.client.registry.EnderscapeEntityRenderers;
import net.bunten.enderscape.client.registry.EnderscapeHudElements;
import net.bunten.enderscape.client.registry.EnderscapeModelLayers;
import net.bunten.enderscape.client.registry.EnderscapeParticleProviders;
import net.bunten.enderscape.client.sound.EndermanStareSoundInstance;
import net.bunten.enderscape.client.sound.EndermanStaticSoundInstance;
import net.bunten.enderscape.item.ItemStackContext;
import net.bunten.enderscape.item.component.Enabled;
import net.bunten.enderscape.item.component.FueledTool;
import net.bunten.enderscape.item.tooltip.FueledToolComponent;
import net.bunten.enderscape.registry.EnderscapeBlockEntities;
import net.bunten.enderscape.registry.EnderscapeItems;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5195;
import net.minecraft.class_5272;
import net.minecraft.class_5616;
import net.minecraft.class_6395;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class EnderscapeClient
implements ClientModInitializer {
    public static final List<HudElement> HUD_ELEMENTS = new ArrayList<HudElement>();
    public static Optional<class_5195> structureMusic = Optional.empty();
    public static final int MAX_STARE_STICKS = 100;
    public static int stareTicks;
    public static Optional<class_2960> lodestoneTeleportationOverlayTexture;
    public static Optional<class_2960> lodestoneTeleportationVignetteTexture;
    public static final int MAX_LODESTONE_TELEPORTATION_TICKS = 60;
    public static int lodestoneTeleportationTicks;
    @Nullable
    public static EndermanStareSoundInstance stareSoundInstance;
    @Nullable
    public static EndermanStaticSoundInstance staticSoundInstance;

    public static void register(HudElement element) {
        Objects.requireNonNull(element);
        HUD_ELEMENTS.add(element);
    }

    public void onInitializeClient() {
        Reflection.initialize((Class[])new Class[]{EnderscapeClientNetworking.class, EnderscapeParticleProviders.class, EnderscapeModelLayers.class, EnderscapeEntityRenderers.class, EnderscapeBlockRenderLayerMap.class, EnderscapeBlockColorProviders.class, EnderscapeHudElements.class});
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> this.resetTemporaryData());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> this.resetTemporaryData());
        class_5616.method_32144(EnderscapeBlockEntities.MAGNIA_SPROUT, MagniaSproutRenderer::new);
        TooltipComponentCallback.EVENT.register(component -> {
            FueledToolTooltip fueledToolTooltip;
            if (component instanceof FueledToolComponent) {
                FueledToolComponent tool = (FueledToolComponent)component;
                fueledToolTooltip = new FueledToolTooltip(tool.stack());
            } else {
                fueledToolTooltip = null;
            }
            return fueledToolTooltip;
        });
        class_6395 shieldFunction = (stack, level, user, i) -> user != null && user.method_6115() && user.method_6030() == stack ? 1.0f : 0.0f;
        class_5272.method_27879((class_1792)EnderscapeItems.END_STONE_RUBBLE_SHIELD, (class_2960)class_2960.method_60656((String)"blocking"), (class_6395)shieldFunction);
        class_5272.method_27879((class_1792)EnderscapeItems.MIRESTONE_RUBBLE_SHIELD, (class_2960)class_2960.method_60656((String)"blocking"), (class_6395)shieldFunction);
        class_5272.method_27879((class_1792)EnderscapeItems.VERADITE_RUBBLE_SHIELD, (class_2960)class_2960.method_60656((String)"blocking"), (class_6395)shieldFunction);
        class_5272.method_27879((class_1792)EnderscapeItems.KURODITE_RUBBLE_SHIELD, (class_2960)class_2960.method_60656((String)"blocking"), (class_6395)shieldFunction);
        class_5272.method_27879((class_1792)EnderscapeItems.MAGNIA_ATTRACTOR, (class_2960)Enderscape.id("enabled"), (stack, level, user, i) -> Enabled.get(stack) && FueledTool.fuelExceedsCost(new ItemStackContext(stack, (class_1937)level, user)) ? 1.0f : 0.0f);
    }

    private void resetTemporaryData() {
        lodestoneTeleportationOverlayTexture = Optional.empty();
        lodestoneTeleportationVignetteTexture = Optional.empty();
        structureMusic = Optional.empty();
        stareTicks = 0;
        lodestoneTeleportationTicks = 0;
        stareSoundInstance = null;
        staticSoundInstance = null;
    }

    static {
        lodestoneTeleportationOverlayTexture = Optional.empty();
        lodestoneTeleportationVignetteTexture = Optional.empty();
        stareSoundInstance = null;
        staticSoundInstance = null;
    }
}

