/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.regex.tregex.nodes;

import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerAsserts;
import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Cached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.ImportStatic;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.frame.VirtualFrame;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.DirectCallNode;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.Node;
import com.cobblemon.mod.relocations.oracle.truffle.api.nodes.RootNode;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.ValueProfile;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.regex.RegexLanguage;
import com.cobblemon.mod.relocations.oracle.truffle.regex.RegexRootNode;
import com.cobblemon.mod.relocations.oracle.truffle.regex.tregex.nodes.TRegexExecutorBaseNode;
import com.cobblemon.mod.relocations.oracle.truffle.regex.tregex.nodes.TRegexExecutorBaseNodeWrapper;
import com.cobblemon.mod.relocations.oracle.truffle.regex.tregex.nodes.TRegexExecutorEntryNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.cobblemon.mod.relocations.oracle.truffle.regex.util.TRegexGuards;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

@ImportStatic(value={TRegexGuards.class, TruffleString.CodeRange.class})
public abstract class TRegexExecutorEntryNode
extends Node {
    private static final Unsafe UNSAFE;
    private static final long coderFieldOffset;
    private final RegexLanguage language;
    @Node.Child
    TRegexExecutorBaseNode executor;

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException e1) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e2) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e2);
            }
        }
    }

    public TRegexExecutorEntryNode(RegexLanguage language, TRegexExecutorNode executor) {
        this.language = language;
        this.executor = executor;
    }

    public static TRegexExecutorEntryNode create(RegexLanguage language, TRegexExecutorNode executor) {
        if (executor == null) {
            return null;
        }
        return TRegexExecutorEntryNodeGen.create(language, executor);
    }

    public TRegexExecutorNode getExecutor() {
        return (TRegexExecutorNode)(this.executor instanceof TRegexExecutorBaseNodeWrapper ? ((TRegexExecutorBaseNodeWrapper)this.executor).getDelegateNode() : this.executor);
    }

    public abstract Object execute(VirtualFrame var1, Object var2, int var3, int var4, int var5);

    @Specialization
    Object doByteArray(VirtualFrame frame, byte[] input, int fromIndex, int index, int maxIndex, @Cached(value="createCallTarget(BROKEN, false)") DirectCallNode callNode) {
        return this.runExecutor(frame, input, fromIndex, index, maxIndex, callNode, TruffleString.CodeRange.BROKEN, false);
    }

    @Specialization(guards={"isCompactString(input)"})
    Object doStringCompact(VirtualFrame frame, String input, int fromIndex, int index, int maxIndex, @Cached(value="createCallTarget(LATIN_1, false)") DirectCallNode callNode) {
        return this.runExecutor(frame, input, fromIndex, index, maxIndex, callNode, TruffleString.CodeRange.LATIN_1, false);
    }

    @Specialization(guards={"!isCompactString(input)"})
    Object doStringNonCompact(VirtualFrame frame, String input, int fromIndex, int index, int maxIndex, @Cached(value="createCallTarget(BROKEN, false)") DirectCallNode callNode) {
        return this.runExecutor(frame, input, fromIndex, index, maxIndex, callNode, TruffleString.CodeRange.BROKEN, false);
    }

    @Specialization(guards={"codeRangeEqualsNode.execute(input, cachedCodeRange)"}, limit="5")
    Object doTString(VirtualFrame frame, TruffleString input, int fromIndex, int index, int maxIndex, @Cached TruffleString.MaterializeNode materializeNode, @Cached TruffleString.GetCodeRangeNode codeRangeNode, @Cached TruffleString.CodeRangeEqualsNode codeRangeEqualsNode, @Cached(value="codeRangeNode.execute(input, getExecutor().getEncoding().getTStringEncoding())") TruffleString.CodeRange cachedCodeRange, @Cached(value="createCallTarget(cachedCodeRange, true)") DirectCallNode callNode) {
        materializeNode.execute(input, this.getExecutor().getEncoding().getTStringEncoding());
        return this.runExecutor(frame, input, fromIndex, index, maxIndex, callNode, cachedCodeRange, true);
    }

    @Specialization(guards={"neitherByteArrayNorString(input)"})
    Object doTruffleObject(VirtualFrame frame, Object input, int fromIndex, int index, int maxIndex, @Cached(value="createClassProfile()") ValueProfile inputClassProfile, @Cached(value="createCallTarget(BROKEN, false)") DirectCallNode callNode) {
        return this.runExecutor(frame, inputClassProfile.profile(input), fromIndex, index, maxIndex, callNode, TruffleString.CodeRange.BROKEN, false);
    }

    DirectCallNode createCallTarget(TruffleString.CodeRange codeRange, boolean isTString) {
        if (this.getExecutor().getNumberOfTransitions() <= 100) {
            return null;
        }
        return DirectCallNode.create(new TRegexExecutorRootNode(this.language, this.getExecutor().shallowCopy(), codeRange, isTString).getCallTarget());
    }

    private Object runExecutor(VirtualFrame frame, Object input, int fromIndex, int index, int maxIndex, DirectCallNode callNode, TruffleString.CodeRange cachedCodeRange, boolean isTString) {
        CompilerAsserts.partialEvaluationConstant((Object)cachedCodeRange);
        CompilerAsserts.partialEvaluationConstant(isTString);
        CompilerAsserts.partialEvaluationConstant(callNode);
        if (callNode == null) {
            return this.executor.execute(frame, this.getExecutor().createLocals(input, fromIndex, index, maxIndex), cachedCodeRange, isTString);
        }
        return callNode.call(input, fromIndex, index, maxIndex);
    }

    static boolean isCompactString(String str) {
        return UNSAFE != null && UNSAFE.getByte(str, coderFieldOffset) == 0;
    }

    static {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion != null && javaVersion.compareTo("1.9") < 0) {
            UNSAFE = null;
            coderFieldOffset = 0L;
        } else {
            Field coderField;
            UNSAFE = TRegexExecutorEntryNode.getUnsafe();
            try {
                coderField = String.class.getDeclaredField("coder");
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("failed to get coder field offset", e);
            }
            coderFieldOffset = UNSAFE.objectFieldOffset(coderField);
        }
    }

    private static final class TRegexExecutorRootNode
    extends RootNode {
        @Node.Child
        TRegexExecutorNode executor;
        private final TruffleString.CodeRange codeRange;
        private final boolean isTString;

        private TRegexExecutorRootNode(RegexLanguage language, TRegexExecutorNode executor, TruffleString.CodeRange codeRange, boolean isTString) {
            super(language, RegexRootNode.SHARED_EMPTY_FRAMEDESCRIPTOR);
            this.executor = this.insert(executor);
            this.codeRange = codeRange;
            this.isTString = isTString;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            Object[] arguments = frame.getArguments();
            Object input = arguments[0];
            int fromIndex = (Integer)arguments[1];
            int index = (Integer)arguments[2];
            int maxIndex = (Integer)arguments[3];
            return this.executor.execute(frame, this.executor.createLocals(input, fromIndex, index, maxIndex), this.codeRange, this.isTString);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public String toString() {
            String src = this.executor.getSource().toStringEscaped();
            return "tregex " + this.executor.getName() + " " + this.codeRange + ": " + (String)(src.length() > 30 ? src.substring(0, 30) + "..." : src);
        }
    }
}

