/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.regex;

import com.cobblemon.mod.relocations.oracle.truffle.api.CompilerDirectives;
import com.cobblemon.mod.relocations.oracle.truffle.api.exception.AbstractTruffleException;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.ExceptionType;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.InteropLibrary;
import com.cobblemon.mod.relocations.oracle.truffle.api.library.ExportLibrary;
import com.cobblemon.mod.relocations.oracle.truffle.api.library.ExportMessage;
import com.cobblemon.mod.relocations.oracle.truffle.api.source.Source;
import com.cobblemon.mod.relocations.oracle.truffle.api.source.SourceSection;
import com.cobblemon.mod.relocations.oracle.truffle.regex.RegexSource;

@ExportLibrary(value=InteropLibrary.class)
public final class RegexSyntaxException
extends AbstractTruffleException {
    private final SourceSection sourceSection;
    private static final long serialVersionUID = 1L;

    public static RegexSyntaxException createOptions(Source source, String msg, int position) {
        return new RegexSyntaxException(msg, source, position);
    }

    public static RegexSyntaxException createPattern(RegexSource source, String msg, int position) {
        return new RegexSyntaxException(msg, RegexSyntaxException.patternSource(source), position);
    }

    public static RegexSyntaxException createFlags(RegexSource source, String msg) {
        return new RegexSyntaxException(msg, RegexSyntaxException.flagsSource(source), 0);
    }

    public static RegexSyntaxException createFlags(RegexSource source, String msg, int position) {
        return new RegexSyntaxException(msg, RegexSyntaxException.flagsSource(source), position);
    }

    @CompilerDirectives.TruffleBoundary
    private static Source patternSource(RegexSource regexSource) {
        String src = regexSource.getSource().getCharacters().toString();
        int firstPos = src.indexOf(47) + 1;
        int lastPos = src.lastIndexOf(47);
        assert (firstPos > 0);
        assert (lastPos > firstPos);
        return regexSource.getSource().subSource(firstPos, lastPos - firstPos);
    }

    @CompilerDirectives.TruffleBoundary
    private static Source flagsSource(RegexSource regexSource) {
        String src = regexSource.getSource().getCharacters().toString();
        int lastPos = src.lastIndexOf(47) + 1;
        assert (lastPos > 0);
        return regexSource.getSource().subSource(lastPos, src.length() - lastPos);
    }

    @CompilerDirectives.TruffleBoundary
    private RegexSyntaxException(String reason, Source src, int position) {
        super(reason);
        assert (position <= src.getLength());
        this.sourceSection = src.createSection(position, src.getLength() - position);
    }

    @ExportMessage
    ExceptionType getExceptionType() {
        return ExceptionType.PARSE_ERROR;
    }

    @ExportMessage
    boolean hasSourceLocation() {
        return true;
    }

    @ExportMessage(name="getSourceLocation")
    SourceSection getSourceSection() {
        return this.sourceSection;
    }
}

