/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast;

import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.GenerateUncached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.ImportStatic;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.InteropLibrary;
import com.cobblemon.mod.relocations.oracle.truffle.api.interop.UnsupportedMessageException;
import com.cobblemon.mod.relocations.oracle.truffle.api.library.CachedLibrary;
import com.cobblemon.mod.relocations.oracle.truffle.api.strings.TruffleString;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.cast.JSToBooleanNodeGen;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.BigInt;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Errors;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSConfig;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Strings;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.Symbol;

@GenerateUncached
@ImportStatic(value={JSConfig.class})
public abstract class JSToBooleanNode
extends JavaScriptBaseNode {
    protected JSToBooleanNode() {
    }

    public abstract boolean executeBoolean(Object var1);

    public static JSToBooleanNode create() {
        return JSToBooleanNodeGen.create();
    }

    @Specialization
    protected static boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static boolean doNull(Object value) {
        return false;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static boolean doUndefined(Object value) {
        return false;
    }

    @Specialization
    protected static boolean doInt(int value) {
        return value != 0;
    }

    @Specialization
    protected static boolean doLong(long value) {
        return value != 0L;
    }

    @Specialization
    protected static boolean doDouble(double value) {
        return value != 0.0 && !Double.isNaN(value);
    }

    @Specialization
    protected static boolean doBigInt(BigInt value) {
        return value.compareTo(BigInt.ZERO) != 0;
    }

    @Specialization
    protected static boolean doString(TruffleString value) {
        return Strings.length(value) != 0;
    }

    @Specialization(guards={"isJSObject(value)"})
    protected static boolean doObject(Object value) {
        return true;
    }

    @Specialization
    protected static boolean doSymbol(Symbol value) {
        return true;
    }

    @Specialization(guards={"isForeignObject(value)"}, limit="InteropLibraryLimit")
    protected final boolean doForeignObject(Object value, @CachedLibrary(value="value") InteropLibrary interop) {
        if (interop.isNull(value)) {
            return false;
        }
        try {
            if (interop.isBoolean(value)) {
                return interop.asBoolean(value);
            }
            if (interop.isString(value)) {
                return !Strings.isEmpty(interop.asTruffleString(value));
            }
            if (interop.isNumber(value)) {
                if (interop.fitsInInt(value)) {
                    return JSToBooleanNode.doInt(interop.asInt(value));
                }
                if (interop.fitsInLong(value)) {
                    return JSToBooleanNode.doLong(interop.asLong(value));
                }
                if (interop.fitsInDouble(value)) {
                    return JSToBooleanNode.doDouble(interop.asDouble(value));
                }
                return true;
            }
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorUnboxException(value, e, this);
        }
        return true;
    }
}

