/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.oracle.truffle.js.builtins.math;

import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Cached;
import com.cobblemon.mod.relocations.oracle.truffle.api.dsl.Specialization;
import com.cobblemon.mod.relocations.oracle.truffle.api.profiles.ConditionProfile;
import com.cobblemon.mod.relocations.oracle.truffle.js.builtins.math.MathOperation;
import com.cobblemon.mod.relocations.oracle.truffle.js.nodes.function.JSBuiltin;
import com.cobblemon.mod.relocations.oracle.truffle.js.runtime.JSContext;

public abstract class AbsNode
extends MathOperation {
    public AbsNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization(rewriteOn={ArithmeticException.class})
    protected static int absInt(int a, @Cached(value="createBinaryProfile()") ConditionProfile negative) throws ArithmeticException {
        return negative.profile(a < 0) ? Math.subtractExact(0, a) : a;
    }

    @Specialization
    protected static double absIntSpecial(int a) {
        return Math.abs((double)a);
    }

    @Specialization
    protected static double absDouble(double a) {
        return Math.abs(a);
    }

    @Specialization
    protected double absGeneric(Object a) {
        return AbsNode.absDouble(this.toDouble(a));
    }
}

