/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.selector;

import com.cobblemon.mod.relocations.mongodb.ReadPreference;
import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.connection.ClusterConnectionMode;
import com.cobblemon.mod.relocations.mongodb.connection.ClusterDescription;
import com.cobblemon.mod.relocations.mongodb.connection.ServerDescription;
import com.cobblemon.mod.relocations.mongodb.internal.connection.ClusterDescriptionHelper;
import com.cobblemon.mod.relocations.mongodb.selector.ServerSelector;
import java.util.List;

public class ReadPreferenceServerSelector
implements ServerSelector {
    private final ReadPreference readPreference;

    public ReadPreferenceServerSelector(ReadPreference readPreference) {
        this.readPreference = Assertions.notNull("readPreference", readPreference);
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() == ClusterConnectionMode.SINGLE) {
            return ClusterDescriptionHelper.getAny(clusterDescription);
        }
        return this.readPreference.choose(clusterDescription);
    }

    public String toString() {
        return "ReadPreferenceServerSelector{readPreference=" + this.readPreference + '}';
    }
}

