/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.logging;

import com.cobblemon.mod.relocations.mongodb.connection.ClusterId;
import com.cobblemon.mod.relocations.mongodb.internal.diagnostics.logging.Logger;
import com.cobblemon.mod.relocations.mongodb.internal.diagnostics.logging.Loggers;
import com.cobblemon.mod.relocations.mongodb.internal.logging.LogMessage;
import com.cobblemon.mod.relocations.mongodb.internal.logging.LoggingInterceptor;
import com.cobblemon.mod.relocations.mongodb.lang.Nullable;
import java.util.concurrent.ConcurrentHashMap;

public final class StructuredLogger {
    private static final ConcurrentHashMap<String, LoggingInterceptor> INTERCEPTORS = new ConcurrentHashMap();
    private final Logger logger;

    public static void addInterceptor(String clusterDescription, LoggingInterceptor interceptor) {
        INTERCEPTORS.put(clusterDescription, interceptor);
    }

    public static void removeInterceptor(String clusterDescription) {
        INTERCEPTORS.remove(clusterDescription);
    }

    @Nullable
    private static LoggingInterceptor getInterceptor(@Nullable String clusterDescription) {
        if (clusterDescription == null) {
            return null;
        }
        return INTERCEPTORS.get(clusterDescription);
    }

    public StructuredLogger(String suffix) {
        this(Loggers.getLogger(suffix));
    }

    public StructuredLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isRequired(LogMessage.Level level, ClusterId clusterId) {
        if (StructuredLogger.getInterceptor(clusterId.getDescription()) != null) {
            return true;
        }
        switch (level) {
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
        }
        throw new UnsupportedOperationException();
    }

    public void log(LogMessage logMessage) {
        LoggingInterceptor interceptor = StructuredLogger.getInterceptor(logMessage.getClusterId().getDescription());
        if (interceptor != null) {
            interceptor.intercept(logMessage);
        }
        switch (logMessage.getLevel()) {
            case DEBUG: {
                if (!this.logger.isDebugEnabled()) break;
                LogMessage.UnstructuredLogMessage unstructuredLogMessage = logMessage.toUnstructuredLogMessage();
                String message = unstructuredLogMessage.interpolate();
                Throwable exception = logMessage.getException();
                if (exception == null) {
                    this.logger.debug(message);
                    break;
                }
                this.logger.debug(message, exception);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

