/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.connection;

import com.cobblemon.mod.relocations.mongodb.MongoCommandException;
import com.cobblemon.mod.relocations.mongodb.MongoException;
import com.cobblemon.mod.relocations.mongodb.MongoNodeIsRecoveringException;
import com.cobblemon.mod.relocations.mongodb.MongoNotPrimaryException;
import com.cobblemon.mod.relocations.mongodb.MongoSocketException;
import com.cobblemon.mod.relocations.mongodb.MongoSocketReadTimeoutException;
import com.cobblemon.mod.relocations.mongodb.annotations.ThreadSafe;
import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.connection.ClusterConnectionMode;
import com.cobblemon.mod.relocations.mongodb.connection.ServerConnectionState;
import com.cobblemon.mod.relocations.mongodb.connection.ServerDescription;
import com.cobblemon.mod.relocations.mongodb.connection.ServerId;
import com.cobblemon.mod.relocations.mongodb.connection.ServerType;
import com.cobblemon.mod.relocations.mongodb.event.ServerClosedEvent;
import com.cobblemon.mod.relocations.mongodb.event.ServerDescriptionChangedEvent;
import com.cobblemon.mod.relocations.mongodb.event.ServerListener;
import com.cobblemon.mod.relocations.mongodb.event.ServerOpeningEvent;
import com.cobblemon.mod.relocations.mongodb.internal.async.ErrorHandlingResultCallback;
import com.cobblemon.mod.relocations.mongodb.internal.async.SingleResultCallback;
import com.cobblemon.mod.relocations.mongodb.internal.connection.AsyncConnection;
import com.cobblemon.mod.relocations.mongodb.internal.connection.ClusterClock;
import com.cobblemon.mod.relocations.mongodb.internal.connection.ClusterClockAdvancingSessionContext;
import com.cobblemon.mod.relocations.mongodb.internal.connection.ClusterableServer;
import com.cobblemon.mod.relocations.mongodb.internal.connection.CommandProtocol;
import com.cobblemon.mod.relocations.mongodb.internal.connection.Connection;
import com.cobblemon.mod.relocations.mongodb.internal.connection.ConnectionFactory;
import com.cobblemon.mod.relocations.mongodb.internal.connection.ConnectionPool;
import com.cobblemon.mod.relocations.mongodb.internal.connection.InternalConnection;
import com.cobblemon.mod.relocations.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.cobblemon.mod.relocations.mongodb.internal.connection.OperationContext;
import com.cobblemon.mod.relocations.mongodb.internal.connection.ProtocolExecutor;
import com.cobblemon.mod.relocations.mongodb.internal.diagnostics.logging.Logger;
import com.cobblemon.mod.relocations.mongodb.internal.diagnostics.logging.Loggers;
import com.cobblemon.mod.relocations.mongodb.internal.session.SessionContext;
import com.cobblemon.mod.relocations.mongodb.lang.Nullable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.types.ObjectId;

@ThreadSafe
public class LoadBalancedServer
implements ClusterableServer {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ServerId serverId;
    private final ConnectionPool connectionPool;
    private final ConnectionFactory connectionFactory;
    private final ServerListener serverListener;
    private final ClusterClock clusterClock;

    public LoadBalancedServer(ServerId serverId, ConnectionPool connectionPool, ConnectionFactory connectionFactory, ServerListener serverListener, ClusterClock clusterClock) {
        this.serverId = serverId;
        this.connectionPool = connectionPool;
        this.connectionFactory = connectionFactory;
        this.serverListener = serverListener;
        this.clusterClock = clusterClock;
        serverListener.serverOpening(new ServerOpeningEvent(serverId));
        serverListener.serverDescriptionChanged(new ServerDescriptionChangedEvent(serverId, ServerDescription.builder().ok(true).state(ServerConnectionState.CONNECTED).type(ServerType.LOAD_BALANCER).address(serverId.getAddress()).build(), ServerDescription.builder().address(serverId.getAddress()).state(ServerConnectionState.CONNECTING).build()));
    }

    @Override
    public void resetToConnecting() {
    }

    @Override
    public void invalidate() {
    }

    private void invalidate(Throwable t, @Nullable ObjectId serviceId, int generation) {
        if (!this.isClosed()) {
            if (t instanceof MongoSocketException && !(t instanceof MongoSocketReadTimeoutException)) {
                if (serviceId != null) {
                    this.connectionPool.invalidate(serviceId, generation);
                }
            } else if ((t instanceof MongoNotPrimaryException || t instanceof MongoNodeIsRecoveringException) && SHUTDOWN_CODES.contains(((MongoCommandException)t).getErrorCode()) && serviceId != null) {
                this.connectionPool.invalidate(serviceId, generation);
            }
        }
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.connectionPool.close();
            this.serverListener.serverClosed(new ServerClosedEvent(this.serverId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void connect() {
    }

    @Override
    public Connection getConnection(OperationContext operationContext) {
        Assertions.isTrue("open", !this.isClosed());
        return this.connectionFactory.create(this.connectionPool.get(operationContext), new LoadBalancedServerProtocolExecutor(), ClusterConnectionMode.LOAD_BALANCED);
    }

    @Override
    public void getConnectionAsync(OperationContext operationContext, SingleResultCallback<AsyncConnection> callback) {
        Assertions.isTrue("open", !this.isClosed());
        this.connectionPool.getAsync(operationContext, (result, t) -> {
            if (t != null) {
                callback.onResult(null, t);
            } else {
                callback.onResult(this.connectionFactory.createAsync((InternalConnection)result, new LoadBalancedServerProtocolExecutor(), ClusterConnectionMode.LOAD_BALANCED), null);
            }
        });
    }

    @Override
    public int operationCount() {
        return -1;
    }

    ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    private class LoadBalancedServerProtocolExecutor
    implements ProtocolExecutor {
        private LoadBalancedServerProtocolExecutor() {
        }

        @Override
        public <T> T execute(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext) {
            try {
                protocol.sessionContext(new ClusterClockAdvancingSessionContext(sessionContext, LoadBalancedServer.this.clusterClock));
                return protocol.execute(connection);
            }
            catch (MongoWriteConcernWithResponseException e) {
                return (T)e.getResponse();
            }
            catch (MongoException e) {
                this.handleExecutionException(connection, sessionContext, e);
                throw e;
            }
        }

        @Override
        public <T> void executeAsync(CommandProtocol<T> protocol, InternalConnection connection, SessionContext sessionContext, SingleResultCallback<T> callback) {
            protocol.sessionContext(new ClusterClockAdvancingSessionContext(sessionContext, LoadBalancedServer.this.clusterClock));
            protocol.executeAsync(connection, ErrorHandlingResultCallback.errorHandlingCallback((result, t) -> {
                if (t != null) {
                    if (t instanceof MongoWriteConcernWithResponseException) {
                        callback.onResult(((MongoWriteConcernWithResponseException)t).getResponse(), null);
                    } else {
                        this.handleExecutionException(connection, sessionContext, t);
                        callback.onResult(null, t);
                    }
                } else {
                    callback.onResult(result, null);
                }
            }, LOGGER));
        }

        private void handleExecutionException(InternalConnection connection, SessionContext sessionContext, Throwable t) {
            LoadBalancedServer.this.invalidate(t, connection.getDescription().getServiceId(), connection.getGeneration());
            if (t instanceof MongoSocketException && sessionContext.hasSession()) {
                sessionContext.markSessionDirty();
            }
        }
    }
}

