/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.connection;

import com.cobblemon.mod.relocations.mongodb.AuthenticationMechanism;
import com.cobblemon.mod.relocations.mongodb.KerberosSubjectProvider;
import com.cobblemon.mod.relocations.mongodb.MongoCredential;
import com.cobblemon.mod.relocations.mongodb.MongoException;
import com.cobblemon.mod.relocations.mongodb.MongoSecurityException;
import com.cobblemon.mod.relocations.mongodb.ServerAddress;
import com.cobblemon.mod.relocations.mongodb.ServerApi;
import com.cobblemon.mod.relocations.mongodb.SubjectProvider;
import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.connection.ClusterConnectionMode;
import com.cobblemon.mod.relocations.mongodb.internal.connection.MongoCredentialWithCache;
import com.cobblemon.mod.relocations.mongodb.internal.connection.SaslAuthenticator;
import com.cobblemon.mod.relocations.mongodb.lang.NonNull;
import com.cobblemon.mod.relocations.mongodb.lang.Nullable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

class GSSAPIAuthenticator
extends SaslAuthenticator {
    private static final String GSSAPI_MECHANISM_NAME = "GSSAPI";
    private static final String GSSAPI_OID = "1.2.840.113554.1.2.2";
    private static final String SERVICE_NAME_DEFAULT_VALUE = "mongodb";
    private static final Boolean CANONICALIZE_HOST_NAME_DEFAULT_VALUE = false;

    GSSAPIAuthenticator(MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        super(credential, clusterConnectionMode, serverApi);
        if (this.getMongoCredential().getAuthenticationMechanism() != AuthenticationMechanism.GSSAPI) {
            throw new MongoException("Incorrect mechanism: " + this.getMongoCredential().getMechanism());
        }
    }

    @Override
    public String getMechanismName() {
        return GSSAPI_MECHANISM_NAME;
    }

    @Override
    protected SaslClient createSaslClient(ServerAddress serverAddress) {
        MongoCredential credential = this.getMongoCredential();
        try {
            SaslClient saslClient;
            HashMap<String, Object> saslClientProperties = credential.getMechanismProperty("JAVA_SASL_CLIENT_PROPERTIES", null);
            if (saslClientProperties == null) {
                saslClientProperties = new HashMap<String, Object>();
                saslClientProperties.put("javax.security.sasl.maxbuffer", "0");
                saslClientProperties.put("javax.security.sasl.credentials", this.getGSSCredential(Assertions.assertNotNull(credential.getUserName())));
            }
            if ((saslClient = Sasl.createSaslClient(new String[]{AuthenticationMechanism.GSSAPI.getMechanismName()}, credential.getUserName(), credential.getMechanismProperty("SERVICE_NAME", SERVICE_NAME_DEFAULT_VALUE), this.getHostName(serverAddress), saslClientProperties, null)) == null) {
                throw new MongoSecurityException(credential, String.format("No platform support for %s mechanism", new Object[]{AuthenticationMechanism.GSSAPI}));
            }
            return saslClient;
        }
        catch (SaslException e) {
            throw new MongoSecurityException(credential, "Exception initializing SASL client", (Throwable)e);
        }
        catch (GSSException e) {
            throw new MongoSecurityException(credential, "Exception initializing GSSAPI credentials", (Throwable)e);
        }
        catch (UnknownHostException e) {
            throw new MongoSecurityException(credential, "Unable to canonicalize host name + " + serverAddress);
        }
    }

    private GSSCredential getGSSCredential(String userName) throws GSSException {
        Oid krb5Mechanism = new Oid(GSSAPI_OID);
        GSSManager manager = GSSManager.getInstance();
        GSSName name = manager.createName(userName, GSSName.NT_USER_NAME);
        return manager.createCredential(name, Integer.MAX_VALUE, krb5Mechanism, 1);
    }

    private String getHostName(ServerAddress serverAddress) throws UnknownHostException {
        return this.getNonNullMechanismProperty("CANONICALIZE_HOST_NAME", CANONICALIZE_HOST_NAME_DEFAULT_VALUE) != false ? InetAddress.getByName(serverAddress.getHost()).getCanonicalHostName() : serverAddress.getHost();
    }

    @Override
    @NonNull
    protected SubjectProvider getDefaultSubjectProvider() {
        return new KerberosSubjectProvider();
    }
}

