/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.internal.connection;

import com.cobblemon.mod.relocations.mongodb.LoggerSettings;
import com.cobblemon.mod.relocations.mongodb.MongoCompressor;
import com.cobblemon.mod.relocations.mongodb.MongoCredential;
import com.cobblemon.mod.relocations.mongodb.MongoDriverInformation;
import com.cobblemon.mod.relocations.mongodb.ServerApi;
import com.cobblemon.mod.relocations.mongodb.connection.ClusterConnectionMode;
import com.cobblemon.mod.relocations.mongodb.connection.ClusterId;
import com.cobblemon.mod.relocations.mongodb.connection.ClusterSettings;
import com.cobblemon.mod.relocations.mongodb.connection.ConnectionPoolSettings;
import com.cobblemon.mod.relocations.mongodb.connection.ServerSettings;
import com.cobblemon.mod.relocations.mongodb.connection.StreamFactory;
import com.cobblemon.mod.relocations.mongodb.event.ClusterListener;
import com.cobblemon.mod.relocations.mongodb.event.CommandListener;
import com.cobblemon.mod.relocations.mongodb.event.ServerListener;
import com.cobblemon.mod.relocations.mongodb.event.ServerMonitorListener;
import com.cobblemon.mod.relocations.mongodb.internal.connection.AsynchronousClusterEventListener;
import com.cobblemon.mod.relocations.mongodb.internal.connection.Cluster;
import com.cobblemon.mod.relocations.mongodb.internal.connection.DefaultClusterableServerFactory;
import com.cobblemon.mod.relocations.mongodb.internal.connection.DefaultDnsSrvRecordMonitorFactory;
import com.cobblemon.mod.relocations.mongodb.internal.connection.DnsMultiServerCluster;
import com.cobblemon.mod.relocations.mongodb.internal.connection.InternalConnectionPoolSettings;
import com.cobblemon.mod.relocations.mongodb.internal.connection.LoadBalancedCluster;
import com.cobblemon.mod.relocations.mongodb.internal.connection.LoadBalancedClusterableServerFactory;
import com.cobblemon.mod.relocations.mongodb.internal.connection.MultiServerCluster;
import com.cobblemon.mod.relocations.mongodb.internal.connection.SingleServerCluster;
import com.cobblemon.mod.relocations.mongodb.internal.event.EventListenerHelper;
import com.cobblemon.mod.relocations.mongodb.lang.Nullable;
import com.cobblemon.mod.relocations.mongodb.spi.dns.DnsClient;
import com.cobblemon.mod.relocations.mongodb.spi.dns.InetAddressResolver;
import java.util.Collections;
import java.util.List;

public final class DefaultClusterFactory {
    public Cluster createCluster(ClusterSettings originalClusterSettings, ServerSettings originalServerSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, @Nullable MongoCredential credential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi, @Nullable DnsClient dnsClient, @Nullable InetAddressResolver inetAddressResolver) {
        ServerSettings serverSettings;
        ClusterSettings clusterSettings;
        ClusterId clusterId = new ClusterId(applicationName);
        if (this.noClusterEventListeners(originalClusterSettings, originalServerSettings)) {
            clusterSettings = ClusterSettings.builder(originalClusterSettings).clusterListenerList(Collections.singletonList(EventListenerHelper.NO_OP_CLUSTER_LISTENER)).build();
            serverSettings = ServerSettings.builder(originalServerSettings).serverListenerList(Collections.singletonList(EventListenerHelper.NO_OP_SERVER_LISTENER)).serverMonitorListenerList(Collections.singletonList(EventListenerHelper.NO_OP_SERVER_MONITOR_LISTENER)).build();
        } else {
            AsynchronousClusterEventListener clusterEventListener = AsynchronousClusterEventListener.startNew(clusterId, DefaultClusterFactory.getClusterListener(originalClusterSettings), DefaultClusterFactory.getServerListener(originalServerSettings), DefaultClusterFactory.getServerMonitorListener(originalServerSettings));
            clusterSettings = ClusterSettings.builder(originalClusterSettings).clusterListenerList(Collections.singletonList(clusterEventListener)).build();
            serverSettings = ServerSettings.builder(originalServerSettings).serverListenerList(Collections.singletonList(clusterEventListener)).serverMonitorListenerList(Collections.singletonList(clusterEventListener)).build();
        }
        DefaultDnsSrvRecordMonitorFactory dnsSrvRecordMonitorFactory = new DefaultDnsSrvRecordMonitorFactory(clusterId, serverSettings, dnsClient);
        if (clusterSettings.getMode() == ClusterConnectionMode.LOAD_BALANCED) {
            LoadBalancedClusterableServerFactory serverFactory = new LoadBalancedClusterableServerFactory(serverSettings, connectionPoolSettings, internalConnectionPoolSettings, streamFactory, credential, loggerSettings, commandListener, applicationName, mongoDriverInformation != null ? mongoDriverInformation : MongoDriverInformation.builder().build(), compressorList, serverApi, inetAddressResolver);
            return new LoadBalancedCluster(clusterId, clusterSettings, serverFactory, dnsSrvRecordMonitorFactory);
        }
        DefaultClusterableServerFactory serverFactory = new DefaultClusterableServerFactory(serverSettings, connectionPoolSettings, internalConnectionPoolSettings, streamFactory, heartbeatStreamFactory, credential, loggerSettings, commandListener, applicationName, mongoDriverInformation != null ? mongoDriverInformation : MongoDriverInformation.builder().build(), compressorList, serverApi, inetAddressResolver);
        if (clusterSettings.getMode() == ClusterConnectionMode.SINGLE) {
            return new SingleServerCluster(clusterId, clusterSettings, serverFactory);
        }
        if (clusterSettings.getMode() == ClusterConnectionMode.MULTIPLE) {
            if (clusterSettings.getSrvHost() == null) {
                return new MultiServerCluster(clusterId, clusterSettings, serverFactory);
            }
            return new DnsMultiServerCluster(clusterId, clusterSettings, serverFactory, dnsSrvRecordMonitorFactory);
        }
        throw new UnsupportedOperationException("Unsupported cluster mode: " + (Object)((Object)clusterSettings.getMode()));
    }

    private boolean noClusterEventListeners(ClusterSettings clusterSettings, ServerSettings serverSettings) {
        return clusterSettings.getClusterListeners().isEmpty() && serverSettings.getServerListeners().isEmpty() && serverSettings.getServerMonitorListeners().isEmpty();
    }

    private static ClusterListener getClusterListener(ClusterSettings clusterSettings) {
        return clusterSettings.getClusterListeners().size() == 0 ? EventListenerHelper.NO_OP_CLUSTER_LISTENER : EventListenerHelper.clusterListenerMulticaster(clusterSettings.getClusterListeners());
    }

    private static ServerListener getServerListener(ServerSettings serverSettings) {
        return serverSettings.getServerListeners().size() == 0 ? EventListenerHelper.NO_OP_SERVER_LISTENER : EventListenerHelper.serverListenerMulticaster(serverSettings.getServerListeners());
    }

    private static ServerMonitorListener getServerMonitorListener(ServerSettings serverSettings) {
        return serverSettings.getServerMonitorListeners().size() == 0 ? EventListenerHelper.NO_OP_SERVER_MONITOR_LISTENER : EventListenerHelper.serverMonitorListenerMulticaster(serverSettings.getServerMonitorListeners());
    }
}

