/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.client.model.search;

import com.cobblemon.mod.relocations.mongodb.annotations.Beta;
import com.cobblemon.mod.relocations.mongodb.annotations.Sealed;
import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.client.model.search.ConstantSearchScore;
import com.cobblemon.mod.relocations.mongodb.client.model.search.FieldSearchPath;
import com.cobblemon.mod.relocations.mongodb.client.model.search.FunctionSearchScore;
import com.cobblemon.mod.relocations.mongodb.client.model.search.PathBoostSearchScore;
import com.cobblemon.mod.relocations.mongodb.client.model.search.SearchConstructibleBsonElement;
import com.cobblemon.mod.relocations.mongodb.client.model.search.SearchScoreExpression;
import com.cobblemon.mod.relocations.mongodb.client.model.search.ValueBoostSearchScore;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.Document;
import org.bson.conversions.Bson;

@Sealed
@Beta(value={Beta.Reason.CLIENT})
public interface SearchScore
extends Bson {
    public static ValueBoostSearchScore boost(float value) {
        return new SearchConstructibleBsonElement("boost", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static PathBoostSearchScore boost(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("boost", (Bson)new Document("path", Assertions.notNull("value", path).toValue()));
    }

    public static ConstantSearchScore constant(float value) {
        return new SearchConstructibleBsonElement("constant", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static FunctionSearchScore function(SearchScoreExpression expression) {
        return new SearchConstructibleBsonElement("function", (Bson)Assertions.notNull("expression", expression));
    }

    public static SearchScore of(Bson score) {
        return new SearchConstructibleBsonElement(Assertions.notNull("score", score));
    }
}

