/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.client.model;

import com.cobblemon.mod.relocations.mongodb.MongoNamespace;
import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.client.model.BsonField;
import com.cobblemon.mod.relocations.mongodb.client.model.BucketAutoOptions;
import com.cobblemon.mod.relocations.mongodb.client.model.BucketGranularity;
import com.cobblemon.mod.relocations.mongodb.client.model.BucketOptions;
import com.cobblemon.mod.relocations.mongodb.client.model.BuildersHelper;
import com.cobblemon.mod.relocations.mongodb.client.model.Facet;
import com.cobblemon.mod.relocations.mongodb.client.model.Field;
import com.cobblemon.mod.relocations.mongodb.client.model.GeoNearOptions;
import com.cobblemon.mod.relocations.mongodb.client.model.GraphLookupOptions;
import com.cobblemon.mod.relocations.mongodb.client.model.MergeOptions;
import com.cobblemon.mod.relocations.mongodb.client.model.UnwindOptions;
import com.cobblemon.mod.relocations.mongodb.client.model.Variable;
import com.cobblemon.mod.relocations.mongodb.client.model.WindowOutputField;
import com.cobblemon.mod.relocations.mongodb.client.model.densify.DensifyOptions;
import com.cobblemon.mod.relocations.mongodb.client.model.densify.DensifyRange;
import com.cobblemon.mod.relocations.mongodb.client.model.fill.FillOptions;
import com.cobblemon.mod.relocations.mongodb.client.model.fill.FillOutputField;
import com.cobblemon.mod.relocations.mongodb.client.model.geojson.Point;
import com.cobblemon.mod.relocations.mongodb.client.model.search.SearchCollector;
import com.cobblemon.mod.relocations.mongodb.client.model.search.SearchOperator;
import com.cobblemon.mod.relocations.mongodb.client.model.search.SearchOptions;
import com.cobblemon.mod.relocations.mongodb.internal.Iterables;
import com.cobblemon.mod.relocations.mongodb.internal.client.model.Util;
import com.cobblemon.mod.relocations.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Aggregates {
    public static Bson addFields(Field<?> ... fields) {
        return Aggregates.addFields(Arrays.asList(fields));
    }

    public static Bson addFields(List<Field<?>> fields) {
        return new FieldsStage("$addFields", fields);
    }

    public static Bson set(Field<?> ... fields) {
        return Aggregates.set(Arrays.asList(fields));
    }

    public static Bson set(List<Field<?>> fields) {
        return new FieldsStage("$set", fields);
    }

    public static <TExpression, Boundary> Bson bucket(TExpression groupBy, List<Boundary> boundaries) {
        return Aggregates.bucket(groupBy, boundaries, new BucketOptions());
    }

    public static <TExpression, TBoundary> Bson bucket(TExpression groupBy, List<TBoundary> boundaries, BucketOptions options) {
        return new BucketStage<TExpression, TBoundary>(groupBy, boundaries, options);
    }

    public static <TExpression> Bson bucketAuto(TExpression groupBy, int buckets) {
        return Aggregates.bucketAuto(groupBy, buckets, new BucketAutoOptions());
    }

    public static <TExpression> Bson bucketAuto(TExpression groupBy, int buckets, BucketAutoOptions options) {
        return new BucketAutoStage<TExpression>(groupBy, buckets, options);
    }

    public static Bson count() {
        return Aggregates.count("count");
    }

    public static Bson count(String field) {
        return new BsonDocument("$count", new BsonString(field));
    }

    public static Bson match(Bson filter) {
        return new SimplePipelineStage("$match", filter);
    }

    public static Bson project(Bson projection) {
        return new SimplePipelineStage("$project", projection);
    }

    public static Bson sort(Bson sort) {
        return new SimplePipelineStage("$sort", sort);
    }

    public static <TExpression> Bson sortByCount(TExpression filter) {
        return new SortByCountStage<TExpression>(filter);
    }

    public static Bson skip(int skip) {
        return new BsonDocument("$skip", new BsonInt32(skip));
    }

    public static Bson limit(int limit) {
        return new BsonDocument("$limit", new BsonInt32(limit));
    }

    public static Bson lookup(String from, String localField, String foreignField, String as) {
        return new BsonDocument("$lookup", new BsonDocument("from", new BsonString(from)).append("localField", new BsonString(localField)).append("foreignField", new BsonString(foreignField)).append("as", new BsonString(as)));
    }

    public static Bson lookup(@Nullable String from, List<? extends Bson> pipeline, String as) {
        return Aggregates.lookup(from, null, pipeline, as);
    }

    public static <TExpression> Bson lookup(@Nullable String from, @Nullable List<Variable<TExpression>> let, List<? extends Bson> pipeline, String as) {
        return new LookupStage(from, let, pipeline, as);
    }

    public static Bson facet(List<Facet> facets) {
        return new FacetStage(facets);
    }

    public static Bson facet(Facet ... facets) {
        return new FacetStage(Arrays.asList(facets));
    }

    public static <TExpression> Bson graphLookup(String from, TExpression startWith, String connectFromField, String connectToField, String as) {
        return Aggregates.graphLookup(from, startWith, connectFromField, connectToField, as, new GraphLookupOptions());
    }

    public static <TExpression> Bson graphLookup(String from, TExpression startWith, String connectFromField, String connectToField, String as, GraphLookupOptions options) {
        Assertions.notNull("options", options);
        return new GraphLookupStage(from, startWith, connectFromField, connectToField, as, options);
    }

    public static <TExpression> Bson group(@Nullable TExpression id, BsonField ... fieldAccumulators) {
        return Aggregates.group(id, Arrays.asList(fieldAccumulators));
    }

    public static <TExpression> Bson group(@Nullable TExpression id, List<BsonField> fieldAccumulators) {
        return new GroupStage<TExpression>(id, fieldAccumulators);
    }

    public static Bson unionWith(String collection, List<? extends Bson> pipeline) {
        return new UnionWithStage(collection, pipeline);
    }

    public static Bson unwind(String fieldName) {
        return new BsonDocument("$unwind", new BsonString(fieldName));
    }

    public static Bson unwind(String fieldName, UnwindOptions unwindOptions) {
        String includeArrayIndex;
        Assertions.notNull("unwindOptions", unwindOptions);
        BsonDocument options = new BsonDocument("path", new BsonString(fieldName));
        Boolean preserveNullAndEmptyArrays = unwindOptions.isPreserveNullAndEmptyArrays();
        if (preserveNullAndEmptyArrays != null) {
            options.append("preserveNullAndEmptyArrays", BsonBoolean.valueOf(preserveNullAndEmptyArrays));
        }
        if ((includeArrayIndex = unwindOptions.getIncludeArrayIndex()) != null) {
            options.append("includeArrayIndex", new BsonString(includeArrayIndex));
        }
        return new BsonDocument("$unwind", options);
    }

    public static Bson out(String collectionName) {
        return new BsonDocument("$out", new BsonString(collectionName));
    }

    public static Bson out(String databaseName, String collectionName) {
        return new BsonDocument("$out", new BsonDocument("db", new BsonString(databaseName)).append("coll", new BsonString(collectionName)));
    }

    public static Bson out(Bson destination) {
        return new SimplePipelineStage("$out", destination);
    }

    public static Bson merge(String collectionName) {
        return Aggregates.merge(collectionName, new MergeOptions());
    }

    public static Bson merge(MongoNamespace namespace) {
        return Aggregates.merge(namespace, new MergeOptions());
    }

    public static Bson merge(String collectionName, MergeOptions options) {
        return new MergeStage(new BsonString(collectionName), options);
    }

    public static Bson merge(MongoNamespace namespace, MergeOptions options) {
        return new MergeStage(new BsonDocument("db", new BsonString(namespace.getDatabaseName())).append("coll", new BsonString(namespace.getCollectionName())), options);
    }

    public static <TExpression> Bson replaceRoot(TExpression value) {
        return new ReplaceStage<TExpression>(value);
    }

    public static <TExpression> Bson replaceWith(TExpression value) {
        return new ReplaceStage<TExpression>(value, true);
    }

    public static Bson sample(int size) {
        return new BsonDocument("$sample", new BsonDocument("size", new BsonInt32(size)));
    }

    public static <TExpression> Bson setWindowFields(@Nullable TExpression partitionBy, @Nullable Bson sortBy2, WindowOutputField output, WindowOutputField ... moreOutput) {
        return Aggregates.setWindowFields(partitionBy, sortBy2, Iterables.concat(Assertions.notNull("output", output), moreOutput));
    }

    public static <TExpression> Bson setWindowFields(@Nullable TExpression partitionBy, @Nullable Bson sortBy2, Iterable<? extends WindowOutputField> output) {
        Assertions.notNull("output", output);
        return new SetWindowFieldsStage<TExpression>(partitionBy, sortBy2, output);
    }

    public static Bson densify(String field, DensifyRange range) {
        return Aggregates.densify(Assertions.notNull("field", field), Assertions.notNull("range", range), DensifyOptions.densifyOptions());
    }

    public static Bson densify(final String field, final DensifyRange range, final DensifyOptions options) {
        Assertions.notNull("field", field);
        Assertions.notNull("range", range);
        Assertions.notNull("options", options);
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                BsonDocument densifySpecificationDoc = new BsonDocument("field", new BsonString(field));
                densifySpecificationDoc.append("range", range.toBsonDocument(documentClass, codecRegistry));
                densifySpecificationDoc.putAll(options.toBsonDocument(documentClass, codecRegistry));
                return new BsonDocument("$densify", densifySpecificationDoc);
            }

            public String toString() {
                return "Stage{name='$densify', field=" + field + ", range=" + range + ", options=" + options + '}';
            }
        };
    }

    public static Bson fill(FillOptions options, FillOutputField output, FillOutputField ... moreOutput) {
        return Aggregates.fill(options, Iterables.concat(Assertions.notNull("output", output), moreOutput));
    }

    public static Bson fill(final FillOptions options, final Iterable<? extends FillOutputField> output) {
        Assertions.notNull("options", options);
        Assertions.notNull("output", output);
        Assertions.isTrueArgument("output must not be empty", Util.sizeAtLeast(output, 1));
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                BsonDocument fillSpecificationDoc = new BsonDocument();
                fillSpecificationDoc.putAll(options.toBsonDocument(documentClass, codecRegistry));
                BsonDocument outputDoc = new BsonDocument();
                for (FillOutputField computation : output) {
                    BsonDocument computationDoc = computation.toBsonDocument(documentClass, codecRegistry);
                    Assertions.assertTrue(computationDoc.size() == 1);
                    outputDoc.putAll(computationDoc);
                }
                fillSpecificationDoc.append("output", outputDoc);
                return new BsonDocument("$fill", fillSpecificationDoc);
            }

            public String toString() {
                return "Stage{name='$fill', options=" + options + ", output=" + output + '}';
            }
        };
    }

    public static Bson search(SearchOperator operator) {
        return Aggregates.search(operator, SearchOptions.searchOptions());
    }

    public static Bson search(SearchOperator operator, SearchOptions options) {
        return new SearchStage("$search", Assertions.notNull("operator", operator), Assertions.notNull("options", options));
    }

    public static Bson search(SearchCollector collector) {
        return Aggregates.search(collector, SearchOptions.searchOptions());
    }

    public static Bson search(SearchCollector collector, SearchOptions options) {
        return new SearchStage("$search", Assertions.notNull("collector", collector), Assertions.notNull("options", options));
    }

    public static Bson searchMeta(SearchOperator operator) {
        return Aggregates.searchMeta(operator, SearchOptions.searchOptions());
    }

    public static Bson searchMeta(SearchOperator operator, SearchOptions options) {
        return new SearchStage("$searchMeta", Assertions.notNull("operator", operator), Assertions.notNull("options", options));
    }

    public static Bson searchMeta(SearchCollector collector) {
        return Aggregates.searchMeta(collector, SearchOptions.searchOptions());
    }

    public static Bson searchMeta(SearchCollector collector, SearchOptions options) {
        return new SearchStage("$searchMeta", Assertions.notNull("collector", collector), Assertions.notNull("options", options));
    }

    public static Bson unset(String ... fields) {
        return Aggregates.unset(Arrays.asList(fields));
    }

    public static Bson unset(List<String> fields) {
        if (fields.size() == 1) {
            return new BsonDocument("$unset", new BsonString(fields.get(0)));
        }
        BsonArray array = new BsonArray();
        fields.stream().map(BsonString::new).forEach(array::add);
        return new BsonDocument().append("$unset", array);
    }

    public static Bson geoNear(final Point near, final String distanceField, final GeoNearOptions options) {
        Assertions.notNull("near", near);
        Assertions.notNull("distanceField", distanceField);
        Assertions.notNull("options", options);
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
                writer.writeStartDocument();
                writer.writeStartDocument("$geoNear");
                writer.writeName("near");
                BuildersHelper.encodeValue(writer, near, codecRegistry);
                writer.writeName("distanceField");
                BuildersHelper.encodeValue(writer, distanceField, codecRegistry);
                options.toBsonDocument(documentClass, codecRegistry).forEach((optionName, optionValue) -> {
                    writer.writeName((String)optionName);
                    BuildersHelper.encodeValue(writer, optionValue, codecRegistry);
                });
                writer.writeEndDocument();
                writer.writeEndDocument();
                return writer.getDocument();
            }

            public String toString() {
                return "Stage{name='$geoNear', near=" + near + ", distanceField=" + distanceField + ", options=" + options + '}';
            }
        };
    }

    public static Bson geoNear(Point near, String distanceField) {
        return Aggregates.geoNear(near, distanceField, GeoNearOptions.geoNearOptions());
    }

    public static Bson documents(final List<? extends Bson> documents) {
        Assertions.notNull("documents", documents);
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
                writer.writeStartDocument();
                writer.writeStartArray("$documents");
                for (Bson bson : documents) {
                    BuildersHelper.encodeValue(writer, bson, codecRegistry);
                }
                writer.writeEndArray();
                writer.writeEndDocument();
                return writer.getDocument();
            }
        };
    }

    static void writeBucketOutput(CodecRegistry codecRegistry, BsonDocumentWriter writer, @Nullable List<BsonField> output) {
        if (output != null) {
            writer.writeName("output");
            writer.writeStartDocument();
            for (BsonField field : output) {
                writer.writeName(field.getName());
                BuildersHelper.encodeValue(writer, field.getValue(), codecRegistry);
            }
            writer.writeEndDocument();
        }
    }

    private Aggregates() {
    }

    private static class FieldsStage
    implements Bson {
        private final List<Field<?>> fields;
        private final String stageName;

        FieldsStage(String stageName, List<Field<?>> fields) {
            this.stageName = stageName;
            this.fields = Assertions.notNull("fields", fields);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.stageName);
            writer.writeStartDocument();
            for (Field<?> field : this.fields) {
                writer.writeName(field.getName());
                BuildersHelper.encodeValue(writer, field.getValue(), codecRegistry);
            }
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldsStage that = (FieldsStage)o;
            if (!this.fields.equals(that.fields)) {
                return false;
            }
            return this.stageName.equals(that.stageName);
        }

        public int hashCode() {
            int result = this.fields.hashCode();
            result = 31 * result + this.stageName.hashCode();
            return result;
        }

        public String toString() {
            return "Stage{name='" + this.stageName + "', fields=" + this.fields + '}';
        }
    }

    private static final class BucketStage<TExpression, TBoundary>
    implements Bson {
        private final TExpression groupBy;
        private final List<TBoundary> boundaries;
        private final BucketOptions options;

        BucketStage(TExpression groupBy, List<TBoundary> boundaries, BucketOptions options) {
            Assertions.notNull("options", options);
            this.groupBy = groupBy;
            this.boundaries = boundaries;
            this.options = options;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartDocument("$bucket");
            writer.writeName("groupBy");
            BuildersHelper.encodeValue(writer, this.groupBy, codecRegistry);
            writer.writeStartArray("boundaries");
            for (TBoundary boundary : this.boundaries) {
                BuildersHelper.encodeValue(writer, boundary, codecRegistry);
            }
            writer.writeEndArray();
            Object defaultBucket = this.options.getDefaultBucket();
            if (defaultBucket != null) {
                writer.writeName("default");
                BuildersHelper.encodeValue(writer, defaultBucket, codecRegistry);
            }
            Aggregates.writeBucketOutput(codecRegistry, writer, this.options.getOutput());
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BucketStage that = (BucketStage)o;
            if (!Objects.equals(this.groupBy, that.groupBy)) {
                return false;
            }
            if (!Objects.equals(this.boundaries, that.boundaries)) {
                return false;
            }
            return this.options.equals(that.options);
        }

        public int hashCode() {
            int result = this.groupBy != null ? this.groupBy.hashCode() : 0;
            result = 31 * result + (this.boundaries != null ? this.boundaries.hashCode() : 0);
            result = 31 * result + this.options.hashCode();
            return result;
        }

        public String toString() {
            return "Stage{name='$bucket', boundaries=" + this.boundaries + ", groupBy=" + this.groupBy + ", options=" + this.options + '}';
        }
    }

    private static final class BucketAutoStage<TExpression>
    implements Bson {
        private final TExpression groupBy;
        private final int buckets;
        private final BucketAutoOptions options;

        BucketAutoStage(TExpression groupBy, int buckets, BucketAutoOptions options) {
            Assertions.notNull("options", options);
            this.groupBy = groupBy;
            this.buckets = buckets;
            this.options = options;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartDocument("$bucketAuto");
            writer.writeName("groupBy");
            BuildersHelper.encodeValue(writer, this.groupBy, codecRegistry);
            writer.writeInt32("buckets", this.buckets);
            Aggregates.writeBucketOutput(codecRegistry, writer, this.options.getOutput());
            BucketGranularity granularity = this.options.getGranularity();
            if (granularity != null) {
                writer.writeString("granularity", granularity.getValue());
            }
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BucketAutoStage that = (BucketAutoStage)o;
            if (this.buckets != that.buckets) {
                return false;
            }
            if (!Objects.equals(this.groupBy, that.groupBy)) {
                return false;
            }
            return this.options.equals(that.options);
        }

        public int hashCode() {
            int result = this.groupBy != null ? this.groupBy.hashCode() : 0;
            result = 31 * result + this.buckets;
            result = 31 * result + this.options.hashCode();
            return result;
        }

        public String toString() {
            return "Stage{name='$bucketAuto', buckets=" + this.buckets + ", groupBy=" + this.groupBy + ", options=" + this.options + '}';
        }
    }

    private static class SimplePipelineStage
    implements Bson {
        private final String name;
        private final Bson value;

        SimplePipelineStage(String name, Bson value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            return new BsonDocument(this.name, this.value.toBsonDocument(documentClass, codecRegistry));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimplePipelineStage that = (SimplePipelineStage)o;
            if (!Objects.equals(this.name, that.name)) {
                return false;
            }
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Stage{name='" + this.name + '\'' + ", value=" + this.value + '}';
        }
    }

    private static class SortByCountStage<TExpression>
    implements Bson {
        private final TExpression filter;

        SortByCountStage(TExpression filter) {
            this.filter = filter;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName("$sortByCount");
            BuildersHelper.encodeValue(writer, this.filter, codecRegistry);
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortByCountStage that = (SortByCountStage)o;
            return Objects.equals(this.filter, that.filter);
        }

        public int hashCode() {
            return this.filter != null ? this.filter.hashCode() : 0;
        }

        public String toString() {
            return "Stage{name='$sortByCount', id=" + this.filter + '}';
        }
    }

    private static final class LookupStage<TExpression>
    implements Bson {
        private final String from;
        private final List<Variable<TExpression>> let;
        private final List<? extends Bson> pipeline;
        private final String as;

        private LookupStage(@Nullable String from, @Nullable List<Variable<TExpression>> let, List<? extends Bson> pipeline, String as) {
            this.from = from;
            this.let = let;
            this.pipeline = pipeline;
            this.as = as;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartDocument("$lookup");
            if (this.from != null) {
                writer.writeString("from", this.from);
            }
            if (this.let != null) {
                writer.writeStartDocument("let");
                for (Variable variable : this.let) {
                    writer.writeName(variable.getName());
                    BuildersHelper.encodeValue(writer, variable.getValue(), codecRegistry);
                }
                writer.writeEndDocument();
            }
            writer.writeName("pipeline");
            writer.writeStartArray();
            for (Bson bson : this.pipeline) {
                BuildersHelper.encodeValue(writer, bson, codecRegistry);
            }
            writer.writeEndArray();
            writer.writeString("as", this.as);
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LookupStage that = (LookupStage)o;
            if (!Objects.equals(this.from, that.from)) {
                return false;
            }
            if (!Objects.equals(this.let, that.let)) {
                return false;
            }
            if (!Objects.equals(this.pipeline, that.pipeline)) {
                return false;
            }
            return Objects.equals(this.as, that.as);
        }

        public int hashCode() {
            int result = this.from != null ? this.from.hashCode() : 0;
            result = 31 * result + (this.let != null ? this.let.hashCode() : 0);
            result = 31 * result + (this.pipeline != null ? this.pipeline.hashCode() : 0);
            result = 31 * result + (this.as != null ? this.as.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Stage{name='$lookup', from='" + this.from + '\'' + ", let=" + this.let + ", pipeline=" + this.pipeline + ", as='" + this.as + '\'' + '}';
        }
    }

    private static class FacetStage
    implements Bson {
        private final List<Facet> facets;

        FacetStage(List<Facet> facets) {
            this.facets = facets;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName("$facet");
            writer.writeStartDocument();
            for (Facet facet : this.facets) {
                writer.writeName(facet.getName());
                writer.writeStartArray();
                for (Bson bson : facet.getPipeline()) {
                    BuildersHelper.encodeValue(writer, bson, codecRegistry);
                }
                writer.writeEndArray();
            }
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FacetStage that = (FacetStage)o;
            return Objects.equals(this.facets, that.facets);
        }

        public int hashCode() {
            return this.facets != null ? this.facets.hashCode() : 0;
        }

        public String toString() {
            return "Stage{name='$facet', facets=" + this.facets + '}';
        }
    }

    private static final class GraphLookupStage<TExpression>
    implements Bson {
        private final String from;
        private final TExpression startWith;
        private final String connectFromField;
        private final String connectToField;
        private final String as;
        private final GraphLookupOptions options;

        private GraphLookupStage(String from, TExpression startWith, String connectFromField, String connectToField, String as, GraphLookupOptions options) {
            this.from = from;
            this.startWith = startWith;
            this.connectFromField = connectFromField;
            this.connectToField = connectToField;
            this.as = as;
            this.options = options;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            Bson restrictSearchWithMatch;
            String depthField;
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartDocument("$graphLookup");
            writer.writeString("from", this.from);
            writer.writeName("startWith");
            BuildersHelper.encodeValue(writer, this.startWith, codecRegistry);
            writer.writeString("connectFromField", this.connectFromField);
            writer.writeString("connectToField", this.connectToField);
            writer.writeString("as", this.as);
            Integer maxDepth = this.options.getMaxDepth();
            if (maxDepth != null) {
                writer.writeInt32("maxDepth", maxDepth);
            }
            if ((depthField = this.options.getDepthField()) != null) {
                writer.writeString("depthField", depthField);
            }
            if ((restrictSearchWithMatch = this.options.getRestrictSearchWithMatch()) != null) {
                writer.writeName("restrictSearchWithMatch");
                BuildersHelper.encodeValue(writer, restrictSearchWithMatch, codecRegistry);
            }
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GraphLookupStage that = (GraphLookupStage)o;
            if (!Objects.equals(this.from, that.from)) {
                return false;
            }
            if (!Objects.equals(this.startWith, that.startWith)) {
                return false;
            }
            if (!Objects.equals(this.connectFromField, that.connectFromField)) {
                return false;
            }
            if (!Objects.equals(this.connectToField, that.connectToField)) {
                return false;
            }
            if (!Objects.equals(this.as, that.as)) {
                return false;
            }
            return Objects.equals(this.options, that.options);
        }

        public int hashCode() {
            int result = this.from != null ? this.from.hashCode() : 0;
            result = 31 * result + (this.startWith != null ? this.startWith.hashCode() : 0);
            result = 31 * result + (this.connectFromField != null ? this.connectFromField.hashCode() : 0);
            result = 31 * result + (this.connectToField != null ? this.connectToField.hashCode() : 0);
            result = 31 * result + (this.as != null ? this.as.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Stage{name='$graphLookup', as='" + this.as + '\'' + ", connectFromField='" + this.connectFromField + '\'' + ", connectToField='" + this.connectToField + '\'' + ", from='" + this.from + '\'' + ", options=" + this.options + ", startWith=" + this.startWith + '}';
        }
    }

    private static class GroupStage<TExpression>
    implements Bson {
        private final TExpression id;
        private final List<BsonField> fieldAccumulators;

        GroupStage(TExpression id, List<BsonField> fieldAccumulators) {
            this.id = id;
            this.fieldAccumulators = fieldAccumulators;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartDocument("$group");
            writer.writeName("_id");
            BuildersHelper.encodeValue(writer, this.id, codecRegistry);
            for (BsonField fieldAccumulator : this.fieldAccumulators) {
                writer.writeName(fieldAccumulator.getName());
                BuildersHelper.encodeValue(writer, fieldAccumulator.getValue(), codecRegistry);
            }
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupStage that = (GroupStage)o;
            if (!Objects.equals(this.id, that.id)) {
                return false;
            }
            return Objects.equals(this.fieldAccumulators, that.fieldAccumulators);
        }

        public int hashCode() {
            int result = this.id != null ? this.id.hashCode() : 0;
            result = 31 * result + (this.fieldAccumulators != null ? this.fieldAccumulators.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Stage{name='$group', id=" + this.id + ", fieldAccumulators=" + this.fieldAccumulators + '}';
        }
    }

    private static final class UnionWithStage
    implements Bson {
        private final String collection;
        private final List<? extends Bson> pipeline;

        private UnionWithStage(String collection, List<? extends Bson> pipeline) {
            this.collection = collection;
            this.pipeline = pipeline;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartDocument("$unionWith");
            writer.writeString("coll", this.collection);
            writer.writeName("pipeline");
            writer.writeStartArray();
            for (Bson bson : this.pipeline) {
                BuildersHelper.encodeValue(writer, bson, codecRegistry);
            }
            writer.writeEndArray();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UnionWithStage that = (UnionWithStage)o;
            if (!this.collection.equals(that.collection)) {
                return false;
            }
            return !Objects.equals(this.pipeline, that.pipeline);
        }

        public int hashCode() {
            int result = this.collection.hashCode();
            result = 31 * result + (this.pipeline != null ? this.pipeline.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Stage{name='$unionWith', collection='" + this.collection + '\'' + ", pipeline=" + this.pipeline + '}';
        }
    }

    private static class MergeStage
    implements Bson {
        private final BsonValue intoValue;
        private final MergeOptions options;

        MergeStage(BsonValue intoValue, MergeOptions options) {
            this.intoValue = intoValue;
            this.options = options;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartDocument("$merge");
            writer.writeName("into");
            if (this.intoValue.isString()) {
                writer.writeString(this.intoValue.asString().getValue());
            } else {
                writer.writeStartDocument();
                writer.writeString("db", this.intoValue.asDocument().getString("db").getValue());
                writer.writeString("coll", this.intoValue.asDocument().getString("coll").getValue());
                writer.writeEndDocument();
            }
            if (this.options.getUniqueIdentifier() != null) {
                if (this.options.getUniqueIdentifier().size() == 1) {
                    writer.writeString("on", this.options.getUniqueIdentifier().get(0));
                } else {
                    writer.writeStartArray("on");
                    for (String string : this.options.getUniqueIdentifier()) {
                        writer.writeString(string);
                    }
                    writer.writeEndArray();
                }
            }
            if (this.options.getVariables() != null) {
                writer.writeStartDocument("let");
                for (Variable variable : this.options.getVariables()) {
                    writer.writeName(variable.getName());
                    BuildersHelper.encodeValue(writer, variable.getValue(), codecRegistry);
                }
                writer.writeEndDocument();
            }
            if (this.options.getWhenMatched() != null) {
                writer.writeName("whenMatched");
                switch (this.options.getWhenMatched()) {
                    case REPLACE: {
                        writer.writeString("replace");
                        break;
                    }
                    case KEEP_EXISTING: {
                        writer.writeString("keepExisting");
                        break;
                    }
                    case MERGE: {
                        writer.writeString("merge");
                        break;
                    }
                    case PIPELINE: {
                        writer.writeStartArray();
                        for (Bson bson : this.options.getWhenMatchedPipeline()) {
                            BuildersHelper.encodeValue(writer, bson, codecRegistry);
                        }
                        writer.writeEndArray();
                        break;
                    }
                    case FAIL: {
                        writer.writeString("fail");
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unexpected value: " + (Object)((Object)this.options.getWhenMatched()));
                    }
                }
            }
            if (this.options.getWhenNotMatched() != null) {
                writer.writeName("whenNotMatched");
                switch (this.options.getWhenNotMatched()) {
                    case INSERT: {
                        writer.writeString("insert");
                        break;
                    }
                    case DISCARD: {
                        writer.writeString("discard");
                        break;
                    }
                    case FAIL: {
                        writer.writeString("fail");
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unexpected value: " + (Object)((Object)this.options.getWhenNotMatched()));
                    }
                }
            }
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MergeStage that = (MergeStage)o;
            if (!this.intoValue.equals(that.intoValue)) {
                return false;
            }
            return this.options.equals(that.options);
        }

        public int hashCode() {
            int result = this.intoValue.hashCode();
            result = 31 * result + this.options.hashCode();
            return result;
        }

        public String toString() {
            return "Stage{name='$merge', , into=" + this.intoValue + ", options=" + this.options + '}';
        }
    }

    private static class ReplaceStage<TExpression>
    implements Bson {
        private final TExpression value;
        private final boolean replaceWith;

        ReplaceStage(TExpression value) {
            this(value, false);
        }

        ReplaceStage(TExpression value, boolean replaceWith) {
            this.value = value;
            this.replaceWith = replaceWith;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            if (this.replaceWith) {
                writer.writeName("$replaceWith");
                BuildersHelper.encodeValue(writer, this.value, codecRegistry);
            } else {
                writer.writeName("$replaceRoot");
                writer.writeStartDocument();
                writer.writeName("newRoot");
                BuildersHelper.encodeValue(writer, this.value, codecRegistry);
                writer.writeEndDocument();
            }
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReplaceStage that = (ReplaceStage)o;
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public String toString() {
            return "Stage{name='$replaceRoot', value=" + this.value + '}';
        }
    }

    private static final class SetWindowFieldsStage<TExpression>
    implements Bson {
        @Nullable
        private final TExpression partitionBy;
        @Nullable
        private final Bson sortBy;
        private final Iterable<? extends WindowOutputField> output;

        SetWindowFieldsStage(@Nullable TExpression partitionBy, @Nullable Bson sortBy2, Iterable<? extends WindowOutputField> output) {
            this.partitionBy = partitionBy;
            this.sortBy = sortBy2;
            this.output = output;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartDocument("$setWindowFields");
            if (this.partitionBy != null) {
                writer.writeName("partitionBy");
                BuildersHelper.encodeValue(writer, this.partitionBy, codecRegistry);
            }
            if (this.sortBy != null) {
                writer.writeName("sortBy");
                BuildersHelper.encodeValue(writer, this.sortBy, codecRegistry);
            }
            writer.writeStartDocument("output");
            for (WindowOutputField windowOutputField : this.output) {
                BsonField field = windowOutputField.toBsonField();
                writer.writeName(field.getName());
                BuildersHelper.encodeValue(writer, field.getValue(), codecRegistry);
            }
            writer.writeEndDocument();
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetWindowFieldsStage that = (SetWindowFieldsStage)o;
            return Objects.equals(this.partitionBy, that.partitionBy) && Objects.equals(this.sortBy, that.sortBy) && this.output.equals(that.output);
        }

        public int hashCode() {
            return Objects.hash(this.partitionBy, this.sortBy, this.output);
        }

        public String toString() {
            return "Stage{name='$setWindowFields', partitionBy=" + this.partitionBy + ", sortBy=" + this.sortBy + ", output=" + this.output + '}';
        }
    }

    private static final class SearchStage
    implements Bson {
        private final String name;
        private final Bson operatorOrCollector;
        @Nullable
        private final SearchOptions options;

        SearchStage(String name, Bson operatorOrCollector, @Nullable SearchOptions options) {
            this.name = name;
            this.operatorOrCollector = operatorOrCollector;
            this.options = options;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartDocument(this.name);
            BsonDocument operatorOrCollectorDoc = this.operatorOrCollector.toBsonDocument(documentClass, codecRegistry);
            Assertions.assertTrue(operatorOrCollectorDoc.size() == 1);
            Map.Entry<String, BsonValue> operatorOrCollectorEntry = operatorOrCollectorDoc.entrySet().iterator().next();
            writer.writeName(operatorOrCollectorEntry.getKey());
            BuildersHelper.encodeValue(writer, operatorOrCollectorEntry.getValue(), codecRegistry);
            if (this.options != null) {
                this.options.toBsonDocument(documentClass, codecRegistry).forEach((optionName, optionValue) -> {
                    writer.writeName((String)optionName);
                    BuildersHelper.encodeValue(writer, optionValue, codecRegistry);
                });
            }
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearchStage that = (SearchStage)o;
            return this.name.equals(that.name) && this.operatorOrCollector.equals(that.operatorOrCollector) && Objects.equals(this.options, that.options);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.operatorOrCollector, this.options);
        }

        public String toString() {
            return "Stage{name='" + this.name + "', operatorOrCollector=" + this.operatorOrCollector + ", options=" + this.options + '}';
        }
    }
}

