/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.mongodb.client.internal;

import com.cobblemon.mod.relocations.mongodb.AutoEncryptionSettings;
import com.cobblemon.mod.relocations.mongodb.MongoClientException;
import com.cobblemon.mod.relocations.mongodb.MongoException;
import com.cobblemon.mod.relocations.mongodb.MongoTimeoutException;
import com.cobblemon.mod.relocations.mongodb.ReadConcern;
import com.cobblemon.mod.relocations.mongodb.ReadPreference;
import com.cobblemon.mod.relocations.mongodb.assertions.Assertions;
import com.cobblemon.mod.relocations.mongodb.client.MongoClient;
import com.cobblemon.mod.relocations.mongodb.client.MongoClients;
import com.cobblemon.mod.relocations.mongodb.crypt.capi.MongoCrypt;
import com.cobblemon.mod.relocations.mongodb.internal.capi.MongoCryptHelper;
import com.cobblemon.mod.relocations.mongodb.lang.Nullable;
import java.io.Closeable;
import java.util.Map;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;

class CommandMarker
implements Closeable {
    @Nullable
    private final MongoClient client;
    @Nullable
    private final ProcessBuilder processBuilder;

    CommandMarker(MongoCrypt mongoCrypt, AutoEncryptionSettings settings) {
        if (MongoCryptHelper.isMongocryptdSpawningDisabled(mongoCrypt.getCryptSharedLibVersionString(), settings)) {
            this.processBuilder = null;
            this.client = null;
        } else {
            Map<String, Object> extraOptions = settings.getExtraOptions();
            boolean mongocryptdBypassSpawn = (Boolean)extraOptions.getOrDefault("mongocryptdBypassSpawn", false);
            if (!mongocryptdBypassSpawn) {
                this.processBuilder = MongoCryptHelper.createProcessBuilder(extraOptions);
                MongoCryptHelper.startProcess(this.processBuilder);
            } else {
                this.processBuilder = null;
            }
            this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)extraOptions.get("mongocryptdURI")));
        }
    }

    RawBsonDocument mark(String databaseName, RawBsonDocument command) {
        if (this.client != null) {
            try {
                try {
                    return this.executeCommand(databaseName, command);
                }
                catch (MongoTimeoutException e) {
                    if (this.processBuilder == null) {
                        throw e;
                    }
                    MongoCryptHelper.startProcess(this.processBuilder);
                    return this.executeCommand(databaseName, command);
                }
            }
            catch (MongoException e) {
                throw this.wrapInClientException(e);
            }
        }
        return command;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    private RawBsonDocument executeCommand(String databaseName, RawBsonDocument markableCommand) {
        Assertions.assertNotNull(this.client);
        return this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)markableCommand, RawBsonDocument.class);
    }

    private MongoClientException wrapInClientException(MongoException e) {
        return new MongoClientException("Exception in encryption library: " + e.getMessage(), e);
    }
}

