/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.relocations.graalvm.home;

import com.cobblemon.mod.relocations.graalvm.nativeimage.ImageInfo;
import com.cobblemon.mod.relocations.graalvm.nativeimage.ImageSingletons;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;

public abstract class HomeFinder {
    public abstract Path getHomeFolder();

    public abstract String getVersion();

    public abstract Map<String, Path> getLanguageHomes();

    public abstract Map<String, Path> getToolHomes();

    public static HomeFinder getInstance() {
        if (ImageInfo.inImageCode() && ImageSingletons.contains(HomeFinder.class)) {
            return ImageSingletons.lookup(HomeFinder.class);
        }
        Class<HomeFinder> lookupClass = HomeFinder.class;
        ModuleLayer moduleLayer = lookupClass.getModule().getLayer();
        ServiceLoader<HomeFinder> services = moduleLayer != null ? ServiceLoader.load(moduleLayer, HomeFinder.class) : ServiceLoader.load(HomeFinder.class, lookupClass.getClassLoader());
        Iterator iterator = services.iterator();
        if (!iterator.hasNext()) {
            services = ServiceLoader.load(HomeFinder.class);
            iterator = services.iterator();
        }
        try {
            return (HomeFinder)iterator.next();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("No implementation of " + HomeFinder.class.getName() + " could be found");
        }
    }
}

