/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokemon.evolution;

import com.cobblemon.mod.common.api.pokemon.evolution.Evolution;
import com.cobblemon.mod.common.api.pokemon.evolution.EvolutionController;
import com.cobblemon.mod.common.api.pokemon.evolution.EvolutionDisplay;
import com.cobblemon.mod.common.api.pokemon.evolution.EvolutionLike;
import com.cobblemon.mod.common.api.pokemon.evolution.EvolutionProxy;
import com.cobblemon.mod.common.api.pokemon.evolution.PreProcessor;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.evolution.controller.ClientEvolutionController;
import com.cobblemon.mod.common.pokemon.evolution.controller.ServerEvolutionController;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001B\u000f\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u000f\u001a\u000e\u0012\u0006\b\u0001\u0012\u00020\u000e\u0012\u0002\b\u00030\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u001b\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\rH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0010J%\u0010\u0018\u001a\u00020\u00152\u0014\u0010\u0014\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00130\rH\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/cobblemon/mod/common/pokemon/evolution/CobblemonEvolutionProxy;", "Lcom/cobblemon/mod/common/api/pokemon/evolution/EvolutionProxy;", "Lcom/cobblemon/mod/common/api/pokemon/evolution/EvolutionDisplay;", "Lcom/cobblemon/mod/common/api/pokemon/evolution/Evolution;", "Lcom/cobblemon/mod/common/pokemon/evolution/controller/ClientEvolutionController$Intermediate;", "Lcom/cobblemon/mod/common/pokemon/evolution/controller/ServerEvolutionController$Intermediate;", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "pokemon", "<init>", "(Lcom/cobblemon/mod/common/pokemon/Pokemon;)V", "", "isClient", "()Z", "Lcom/cobblemon/mod/common/api/pokemon/evolution/EvolutionController;", "Lcom/cobblemon/mod/common/api/pokemon/evolution/EvolutionLike;", "current", "()Lcom/cobblemon/mod/common/api/pokemon/evolution/EvolutionController;", "client", "server", "Lcom/cobblemon/mod/common/api/pokemon/evolution/PreProcessor;", "newInstance", "", "overrideController$common", "(Lcom/cobblemon/mod/common/api/pokemon/evolution/EvolutionController;)V", "overrideController", "Lcom/cobblemon/mod/common/pokemon/Pokemon;", "Lcom/cobblemon/mod/common/pokemon/evolution/controller/ClientEvolutionController;", "clientController", "Lcom/cobblemon/mod/common/pokemon/evolution/controller/ClientEvolutionController;", "Lcom/cobblemon/mod/common/pokemon/evolution/controller/ServerEvolutionController;", "serverController", "Lcom/cobblemon/mod/common/pokemon/evolution/controller/ServerEvolutionController;", "common"})
public final class CobblemonEvolutionProxy
implements EvolutionProxy<EvolutionDisplay, Evolution, ClientEvolutionController.Intermediate, ServerEvolutionController.Intermediate> {
    @NotNull
    private final Pokemon pokemon;
    @NotNull
    private ClientEvolutionController clientController;
    @NotNull
    private ServerEvolutionController serverController;

    public CobblemonEvolutionProxy(@NotNull Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        this.pokemon = pokemon;
        this.clientController = new ClientEvolutionController(this.pokemon, SetsKt.emptySet());
        this.serverController = new ServerEvolutionController(this.pokemon, SetsKt.emptySet(), SetsKt.emptySet());
    }

    @Override
    public boolean isClient() {
        return this.pokemon.isClient$common();
    }

    @Override
    @NotNull
    public EvolutionController<? extends EvolutionLike, ?> current() {
        return this.isClient() ? (EvolutionController)this.clientController : (EvolutionController)this.serverController;
    }

    @Override
    @NotNull
    public EvolutionController<EvolutionDisplay, ClientEvolutionController.Intermediate> client() {
        if (!this.isClient()) {
            throw new ClassCastException("Cannot use the client implementation from the server side");
        }
        return this.clientController;
    }

    @Override
    @NotNull
    public EvolutionController<Evolution, ServerEvolutionController.Intermediate> server() {
        if (this.isClient()) {
            throw new ClassCastException("Cannot use the server implementation from the client side");
        }
        return this.serverController;
    }

    public final void overrideController$common(@NotNull EvolutionController<? extends EvolutionLike, ? extends PreProcessor> newInstance) {
        Intrinsics.checkNotNullParameter(newInstance, (String)"newInstance");
        EvolutionController<? extends EvolutionLike, ? extends PreProcessor> evolutionController = newInstance;
        if (evolutionController instanceof ClientEvolutionController) {
            this.clientController = (ClientEvolutionController)newInstance;
        } else if (evolutionController instanceof ServerEvolutionController) {
            this.serverController = (ServerEvolutionController)newInstance;
        } else {
            throw new IllegalArgumentException("Cannot resolve override of type " + Reflection.getOrCreateKotlinClass(newInstance.getClass()).getSimpleName());
        }
    }
}

