/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.api.riding.behaviour.ActiveRidingContext;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.behaviour.RidingController;
import com.cobblemon.mod.common.duck.PlayerDuck;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.mixin.accessor.ChunkMapAccessor;
import com.cobblemon.mod.common.mixin.accessor.TrackedEntityAccessor;
import com.cobblemon.mod.common.net.messages.client.orientation.ClientboundUpdateDriverInputPacket;
import com.cobblemon.mod.common.net.messages.client.orientation.ClientboundUpdateOrientationPacket;
import com.cobblemon.mod.common.net.messages.client.pokemon.update.ClientboundUpdateRidingStatePacket;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3898;
import net.minecraft.class_5629;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3231.class})
public abstract class ServerEntityMixin {
    @Shadow
    @Final
    private Consumer<class_2596<?>> field_18259;
    @Shadow
    @Final
    private class_1297 field_14049;
    @Unique
    private Matrix3f cobblemon$lastSentOrientation;
    @Unique
    private boolean cobblemon$lastSentActive;

    @Inject(method={"sendChanges"}, at={@At(value="TAIL")})
    private void cobblemon$sendChanges(CallbackInfo ci) {
        this.cobblemon$sendOrientationChanges();
        this.cobblemon$sendRidingStateChanges();
        this.cobblemon$sendDriverInput();
    }

    private void cobblemon$sendRidingStateChanges() {
        class_1297 class_12972 = this.field_14049;
        if (!(class_12972 instanceof PokemonEntity)) {
            return;
        }
        PokemonEntity pokemonEntity = (PokemonEntity)class_12972;
        if (pokemonEntity.getRidingController() == null) {
            return;
        }
        RidingController ridingController = pokemonEntity.getRidingController();
        if (ridingController.getContext() == null) {
            return;
        }
        ActiveRidingContext context = ridingController.getContext();
        class_2960 ridingBehaviour = context.getBehaviour();
        RidingBehaviourState ridingState = context.getState();
        RidingBehaviourState previousRidingState = pokemonEntity.getPreviousRidingState();
        if (previousRidingState != null && !ridingState.shouldSync(previousRidingState)) {
            return;
        }
        this.cobblemon$broadcast(new ClientboundUpdateRidingStatePacket(pokemonEntity.method_5628(), ridingBehaviour, ridingState, null));
    }

    private void cobblemon$sendOrientationChanges() {
        class_1297 class_12972 = this.field_14049;
        if (!(class_12972 instanceof OrientationControllable)) {
            return;
        }
        OrientationControllable controllable = (OrientationControllable)class_12972;
        OrientationController controller = controllable.getOrientationController();
        Matrix3f currOrientation = controller.getOrientation();
        boolean currActive = controller.getActive();
        if (currOrientation == null || currOrientation.equals((Object)this.cobblemon$lastSentOrientation) && currActive == this.cobblemon$lastSentActive) {
            return;
        }
        this.cobblemon$lastSentOrientation = new Matrix3f((Matrix3fc)currOrientation);
        this.cobblemon$lastSentActive = currActive;
        this.cobblemon$broadcast(new ClientboundUpdateOrientationPacket(currOrientation, currActive, this.field_14049.method_5628()));
    }

    private void cobblemon$sendDriverInput() {
        class_1297 class_12972 = this.field_14049;
        if (!(class_12972 instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)class_12972;
        if (!(serverPlayer.method_5854() instanceof PokemonEntity)) {
            return;
        }
        Vector3f driverInput = ((PlayerDuck)serverPlayer).getDriverInput();
        if (driverInput == null) {
            return;
        }
        Vector3f lastSentDriverInput = ((PlayerDuck)serverPlayer).getLastSentDriverInput();
        if (driverInput.equals((Object)lastSentDriverInput)) {
            return;
        }
        ((PlayerDuck)serverPlayer).setLastSentDriverInput(driverInput);
        this.cobblemon$broadcast(new ClientboundUpdateDriverInputPacket(driverInput, this.field_14049.method_5628()));
    }

    private void cobblemon$broadcast(NetworkPacket<?> packet) {
        class_1937 class_19372 = this.field_14049.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 level = (class_3218)class_19372;
        class_3898 chunkMap = level.method_14178().field_17254;
        Int2ObjectMap<?> entityMap = ((ChunkMapAccessor)chunkMap).getEntityMap();
        Object tracked = entityMap.get(this.field_14049.method_5628());
        if (!(tracked instanceof TrackedEntityAccessor)) {
            return;
        }
        TrackedEntityAccessor tracker = (TrackedEntityAccessor)tracked;
        Set<class_5629> seenBy = tracker.getSeenBy();
        for (class_5629 conn : seenBy) {
            class_3222 player = conn.method_32311();
            if (player == this.field_14049) continue;
            CobblemonNetwork.INSTANCE.sendPacketToPlayer(player, packet);
        }
    }
}

