/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.mixin;

import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.entity.PokemonSideDelegate;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.api.pokemon.effect.ShoulderEffectRegistry;
import com.cobblemon.mod.common.api.riding.RidingStyle;
import com.cobblemon.mod.common.api.riding.Seat;
import com.cobblemon.mod.common.api.riding.behaviour.ActiveRidingContext;
import com.cobblemon.mod.common.api.riding.behaviour.RidingController;
import com.cobblemon.mod.common.api.riding.behaviour.types.liquid.SubmarineBehaviour;
import com.cobblemon.mod.common.client.entity.PokemonClientDelegate;
import com.cobblemon.mod.common.client.render.MatrixWrapper;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements OrientationControllable {
    @Unique
    private final OrientationController cobblemon$orientationController = new OrientationController((class_1309)this);

    public LivingEntityMixin(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    public OrientationController getOrientationController() {
        return this.cobblemon$orientationController;
    }

    @Inject(method={"onEffectRemoved"}, at={@At(value="TAIL")})
    private void cobblemon$onEffectRemoved(class_1293 effect, CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (entity instanceof class_3222) {
            ShoulderEffectRegistry.INSTANCE.onEffectEnd((class_3222)entity);
        }
    }

    @WrapOperation(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInWall()Z")})
    public boolean cobblemon$preventMountSuffocation(class_1309 instance, Operation<Boolean> original) {
        if (instance.method_5854() instanceof PokemonEntity) {
            return false;
        }
        return (Boolean)original.call(new Object[]{instance});
    }

    @NotNull
    public class_239 method_5745(double hitDistance, float partialTicks, boolean hitFluids) {
        PokemonEntity pokemonEntity;
        PokemonSideDelegate pokemonSideDelegate;
        class_1297 vehicle = this.method_5854();
        if (vehicle instanceof PokemonEntity && (pokemonSideDelegate = (pokemonEntity = (PokemonEntity)vehicle).getDelegate()) instanceof PokemonClientDelegate) {
            PokemonClientDelegate delegate = (PokemonClientDelegate)pokemonSideDelegate;
            int seatIndex = pokemonEntity.method_5685().indexOf(this);
            Seat seat = pokemonEntity.getSeats().get(seatIndex);
            MatrixWrapper locator = delegate.getLocatorStates().get(seat.getLocator());
            class_243 locatorOffset = new class_243(locator.getMatrix().getTranslation(new Vector3f()));
            class_243 eyePosition = this.cobblemon$getEyePosition(partialTicks, pokemonEntity, locatorOffset);
            class_243 viewVector = this.method_5828(partialTicks);
            class_243 viewDistanceVector = eyePosition.method_1031(viewVector.field_1352 * hitDistance, viewVector.field_1351 * hitDistance, viewVector.field_1350 * hitDistance);
            return this.method_37908().method_17742(new class_3959(eyePosition, viewDistanceVector, class_3959.class_3960.field_17559, hitFluids ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, (class_1297)this));
        }
        return super.method_5745(hitDistance, partialTicks, hitFluids);
    }

    @Unique
    private class_243 cobblemon$getEyePosition(float partialTicks, PokemonEntity pokemonEntity, class_243 locatorOffset) {
        OrientationController controller = this.getOrientationController();
        float currEyeHeight = this.method_5751();
        class_243 offset = locatorOffset.method_1019(pokemonEntity.method_19538());
        if (controller.isActive() && controller.getOrientation() != null) {
            Quaternionf orientation = controller.getRenderOrientation(partialTicks);
            class_243 rotatedEyeHeight = new class_243(orientation.transform(new Vector3f(0.0f, currEyeHeight - this.method_17682() / 2.0f, 0.0f)));
            offset.method_1019(rotatedEyeHeight);
        }
        return offset;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void cobblemon$updateRenderOrientation(CallbackInfo ci) {
        this.cobblemon$orientationController.tick();
    }

    public void method_5641(double x, double y, double z, float yaw, float pitch) {
        if (this.cobblemon$orientationController.getActive()) {
            this.method_30634(x, y, z);
            this.method_36456(yaw % 360.0f);
            this.method_36457(pitch % 360.0f);
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        } else {
            this.method_30634(x, y, z);
            this.method_60608(yaw, pitch);
        }
    }

    @Inject(method={"decreaseAirSupply"}, at={@At(value="HEAD")}, cancellable=true)
    private void cobblemon$conditionalWaterBreathing(int currentAir, CallbackInfoReturnable<Integer> cir) {
        class_1309 entity = (class_1309)this;
        if (!(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        class_1297 class_12972 = player.method_5854();
        if (!(class_12972 instanceof PokemonEntity)) {
            return;
        }
        PokemonEntity vehicle = (PokemonEntity)class_12972;
        RidingController ridingController = vehicle.getRidingController();
        if (ridingController == null) {
            return;
        }
        ActiveRidingContext activeContext = ridingController.getContext();
        if (activeContext == null) {
            return;
        }
        Float stamina = activeContext.getState().getStamina().get();
        if (activeContext.getStyle() == RidingStyle.LIQUID && activeContext.getBehaviour().equals((Object)SubmarineBehaviour.Companion.getKEY()) && stamina.floatValue() > 0.0f) {
            cir.setReturnValue((Object)currentAir);
            cir.cancel();
        }
    }
}

