/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.item.crafting;

import com.cobblemon.mod.common.CobblemonItemComponents;
import com.cobblemon.mod.common.api.cooking.Seasoning;
import com.cobblemon.mod.common.api.cooking.Seasonings;
import com.cobblemon.mod.common.api.fishing.SpawnBaitEffects;
import com.cobblemon.mod.common.item.components.BaitEffectsComponent;
import com.cobblemon.mod.common.item.crafting.SeasoningProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u000f\u001a\u00020\u000e8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/item/crafting/BaitSeasoningProcessor;", "Lcom/cobblemon/mod/common/item/crafting/SeasoningProcessor;", "<init>", "()V", "Lnet/minecraft/class_1799;", "result", "", "seasoning", "", "apply", "(Lnet/minecraft/class_1799;Ljava/util/List;)V", "", "consumesItem", "(Lnet/minecraft/class_1799;)Z", "", "type", "Ljava/lang/String;", "getType", "()Ljava/lang/String;", "common"})
public final class BaitSeasoningProcessor
implements SeasoningProcessor {
    @NotNull
    public static final BaitSeasoningProcessor INSTANCE = new BaitSeasoningProcessor();
    @NotNull
    private static final String type = "spawn_bait";

    private BaitSeasoningProcessor() {
    }

    @Override
    @NotNull
    public String getType() {
        return type;
    }

    @Override
    public void apply(@NotNull class_1799 result, @NotNull List<class_1799> seasoning) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter(seasoning, (String)"seasoning");
        List baitIdentifiers = new ArrayList();
        for (class_1799 seasoningStack : seasoning) {
            Collection collection;
            class_6880 class_68802 = seasoningStack.method_41409();
            Intrinsics.checkNotNullExpressionValue((Object)class_68802, (String)"getItemHolder(...)");
            baitIdentifiers.addAll((Collection)SpawnBaitEffects.getBaitIdentifiersFromItem((class_6880<class_1792>)class_68802));
            Seasoning seasoningData = Seasonings.INSTANCE.getFromItemStack(seasoningStack);
            if (seasoningData == null || (collection = (Collection)seasoningData.getBaitEffects()) == null || collection.isEmpty()) continue;
            class_2960 itemId = ((class_5321)seasoningStack.method_41409().method_40230().get()).method_29177();
            class_2960 id = new class_2960("seasonings", itemId.method_12832());
            baitIdentifiers.add(id);
        }
        result.method_57379(CobblemonItemComponents.BAIT_EFFECTS, (Object)new BaitEffectsComponent(CollectionsKt.toList((Iterable)baitIdentifiers)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean consumesItem(@NotNull class_1799 seasoning) {
        Intrinsics.checkNotNullParameter((Object)seasoning, (String)"seasoning");
        Seasoning seasoningData = Seasonings.INSTANCE.getFromItemStack(seasoning);
        if (seasoningData == null) return false;
        Collection collection = seasoningData.getBaitEffects();
        if (collection != null) {
            if (!collection.isEmpty()) return true;
        }
        boolean bl = true;
        if (!bl) return true;
        class_6880 class_68802 = seasoning.method_41409();
        Intrinsics.checkNotNullExpressionValue((Object)class_68802, (String)"getItemHolder(...)");
        if (((Collection)SpawnBaitEffects.getBaitIdentifiersFromItem((class_6880<class_1792>)class_68802)).isEmpty()) return false;
        return true;
    }
}

