/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.entity.ai;

import com.cobblemon.mod.common.CobblemonMemories;
import com.cobblemon.mod.common.api.pokemon.status.Statuses;
import com.cobblemon.mod.common.entity.PoseType;
import com.cobblemon.mod.common.entity.ai.CobblemonWalkTarget;
import com.cobblemon.mod.common.entity.ai.FollowHerdLeaderTask;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.entity.pokemon.ai.PokemonMoveControl;
import com.cobblemon.mod.common.pokemon.ai.ToleratedHerdLeader;
import com.cobblemon.mod.common.pokemon.status.PersistentStatusContainer;
import com.cobblemon.mod.common.util.BrainExtensionsKt;
import com.cobblemon.mod.common.util.Vec3ExtensionsKt;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.class_1297;
import net.minecraft.class_1335;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\t\u0010\nJ'\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017R$\u0010\u0019\u001a\u0004\u0018\u00010\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u0017R\"\u0010\u001f\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\"\u0010%\u001a\u00020\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010 \u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u0017\u0010(\u001a\u00020\u001e8\u0006\u00a2\u0006\f\n\u0004\b(\u0010 \u001a\u0004\b)\u0010\"\u00a8\u0006*"}, d2={"Lcom/cobblemon/mod/common/entity/ai/FollowHerdLeaderTask;", "Lnet/minecraft/class_4097;", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "<init>", "()V", "Lnet/minecraft/class_3218;", "level", "owner", "", "checkExtraStartConditions", "(Lnet/minecraft/class_3218;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)Z", "entity", "", "gameTime", "canStillUse", "(Lnet/minecraft/class_3218;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)Z", "", "tick", "(Lnet/minecraft/class_3218;Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;J)V", "Lnet/minecraft/class_243;", "getRandomOffset", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;Lnet/minecraft/class_3218;)Lnet/minecraft/class_243;", "applySleep", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "removeSleep", "leader", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getLeader", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "setLeader", "", "tooFar", "F", "getTooFar", "()F", "setTooFar", "(F)V", "closeEnough", "getCloseEnough", "setCloseEnough", "chance", "getChance", "common"})
@SourceDebugExtension(value={"SMAP\nFollowHerdLeaderTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FollowHerdLeaderTask.kt\ncom/cobblemon/mod/common/entity/ai/FollowHerdLeaderTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
public final class FollowHerdLeaderTask
extends class_4097<PokemonEntity> {
    @Nullable
    private PokemonEntity leader;
    private float tooFar = 8.0f;
    private float closeEnough = 4.0f;
    private final float chance;

    public FollowHerdLeaderTask() {
        super((Map)ImmutableMap.of(CobblemonMemories.HERD_LEADER, (Object)class_4141.field_18456, (Object)class_4140.field_18445, (Object)class_4141.field_18458), Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.chance = 0.016666668f;
    }

    @Nullable
    public final PokemonEntity getLeader() {
        return this.leader;
    }

    public final void setLeader(@Nullable PokemonEntity pokemonEntity) {
        this.leader = pokemonEntity;
    }

    public final float getTooFar() {
        return this.tooFar;
    }

    public final void setTooFar(float f) {
        this.tooFar = f;
    }

    public final float getCloseEnough() {
        return this.closeEnough;
    }

    public final void setCloseEnough(float f) {
        this.closeEnough = f;
    }

    public final float getChance() {
        return this.chance;
    }

    protected boolean checkExtraStartConditions(@NotNull class_3218 level, @NotNull PokemonEntity owner) {
        block3: {
            ToleratedHerdLeader definition;
            ToleratedHerdLeader toleratedHerdLeader;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            UUID uUID = owner.method_18868().method_18904(CobblemonMemories.HERD_LEADER).map(arg_0 -> FollowHerdLeaderTask.checkExtraStartConditions$lambda$0(checkExtraStartConditions.1.INSTANCE, arg_0)).orElse(null);
            if (uUID == null) {
                return false;
            }
            class_1297 class_12972 = level.method_14190(uUID);
            PokemonEntity pokemonEntity = this.leader = class_12972 instanceof PokemonEntity ? (PokemonEntity)class_12972 : null;
            if (pokemonEntity != null) {
                PokemonEntity leader = pokemonEntity;
                boolean bl = false;
                toleratedHerdLeader = owner.getBehaviour().getHerd().bestMatchLeader(owner, leader);
            } else {
                toleratedHerdLeader = null;
            }
            ToleratedHerdLeader toleratedHerdLeader2 = definition = toleratedHerdLeader;
            if (toleratedHerdLeader2 == null) break block3;
            ToleratedHerdLeader it = toleratedHerdLeader2;
            boolean bl = false;
            IntRange intRange = it.getFollowDistance();
            this.tooFar = intRange != null ? intRange.getEndInclusive().intValue() : owner.getBehaviour().getHerd().getFollowDistance().getEndInclusive().intValue();
            IntRange intRange2 = it.getFollowDistance();
            this.closeEnough = intRange2 != null ? intRange2.getStart().intValue() : owner.getBehaviour().getHerd().getFollowDistance().getStart().intValue();
        }
        return this.leader != null;
    }

    protected boolean canStillUse(@NotNull class_3218 level, @NotNull PokemonEntity entity, long gameTime) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        PokemonEntity pokemonEntity = this.leader;
        return (pokemonEntity != null ? pokemonEntity.method_5805() : false) && Intrinsics.areEqual((Object)((object = this.leader) != null && (object = object.method_5667()) != null ? ((UUID)object).toString() : null), entity.method_18868().method_18904(CobblemonMemories.HERD_LEADER).orElse(null));
    }

    protected void tick(@NotNull class_3218 level, @NotNull PokemonEntity entity, long gameTime) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        PokemonEntity pokemonEntity = this.leader;
        if (pokemonEntity == null) {
            return;
        }
        PokemonEntity leader = pokemonEntity;
        if (entity.method_18868().method_18896(class_4140.field_18445)) {
            return;
        }
        class_1335 class_13352 = entity.method_5962();
        PokemonMoveControl pokemonMoveControl = class_13352 instanceof PokemonMoveControl ? (PokemonMoveControl)class_13352 : null;
        if (pokemonMoveControl == null) {
            return;
        }
        PokemonMoveControl moveControl = pokemonMoveControl;
        class_1335 class_13353 = leader.method_5962();
        PokemonMoveControl pokemonMoveControl2 = class_13353 instanceof PokemonMoveControl ? (PokemonMoveControl)class_13353 : null;
        if (pokemonMoveControl2 == null) {
            return;
        }
        PokemonMoveControl leaderMoveControl = pokemonMoveControl2;
        if (leader.method_5739((class_1297)entity) > this.tooFar) {
            this.removeSleep(entity);
            class_4095<PokemonEntity> class_40952 = entity.method_18868();
            class_243 class_2432 = leader.method_19538().method_1019(this.getRandomOffset(entity, level));
            Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"add(...)");
            class_40952.method_18878(class_4140.field_18445, (Object)new CobblemonWalkTarget(Vec3ExtensionsKt.toBlockPos(class_2432), 0.4f, (int)this.closeEnough, null, null, 24, null));
        } else if (leader.isFlying() && !entity.isFlying()) {
            if (!entity.canFly()) {
                entity.method_18868().method_18875(CobblemonMemories.HERD_LEADER);
                return;
            }
            this.removeSleep(entity);
            class_4095<PokemonEntity> class_40953 = entity.method_18868();
            class_243 class_2433 = leader.method_19538().method_1019(this.getRandomOffset(entity, level));
            Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"add(...)");
            class_40953.method_18878(class_4140.field_18445, (Object)new CobblemonWalkTarget(Vec3ExtensionsKt.toBlockPos(class_2433), 0.3f, (int)this.closeEnough, null, null, 24, null));
        } else if (leaderMoveControl.getBanking()) {
            this.removeSleep(entity);
            if (leader.method_52535() && !entity.method_52535()) {
                class_4095<PokemonEntity> class_40954 = entity.method_18868();
                class_243 class_2434 = leader.method_19538().method_1019(this.getRandomOffset(entity, level));
                Intrinsics.checkNotNullExpressionValue((Object)class_2434, (String)"add(...)");
                class_40954.method_18878(class_4140.field_18445, (Object)new CobblemonWalkTarget(Vec3ExtensionsKt.toBlockPos(class_2434), 0.4f, 1, null, null, 24, null));
            } else {
                entity.method_36456(leader.method_36454());
                float f = leaderMoveControl.getBankForwardBlocksPerTick();
                float f2 = leaderMoveControl.getBankUpwardsBlocksPerTick();
                moveControl.startBanking(f, f2, 0.0f, 2);
            }
        } else if (leader.method_18868().method_18896(class_4140.field_18445)) {
            if (entity.method_59922().method_43057() > this.chance) {
                return;
            }
            this.removeSleep(entity);
            class_4142 class_41422 = leader.method_18868().method_18904(class_4140.field_18445).orElse(null);
            if (class_41422 == null) {
                return;
            }
            class_4142 walkTarget = class_41422;
            if (entity.method_5707(walkTarget.method_19094().method_18991()) + (double)this.closeEnough < leader.method_5707(walkTarget.method_19094().method_18991())) {
                return;
            }
            class_4095<PokemonEntity> class_40955 = entity.method_18868();
            class_243 class_2435 = walkTarget.method_19094().method_18991().method_1019(this.getRandomOffset(entity, level));
            Intrinsics.checkNotNullExpressionValue((Object)class_2435, (String)"add(...)");
            class_13353 = Vec3ExtensionsKt.toBlockPos(class_2435);
            float f = walkTarget.method_19095();
            Function1 function1 = walkTarget instanceof CobblemonWalkTarget ? (Function1)walkTarget : null;
            if (function1 == null || (function1 = function1.getNodeTypeFilter()) == null) {
                function1 = FollowHerdLeaderTask::tick$lambda$0;
            }
            Function1 function12 = function1;
            int n = (int)this.closeEnough;
            class_40955.method_18878(class_4140.field_18445, (Object)new CobblemonWalkTarget((class_2338)class_13353, f, n, function12, null, 16, null));
        } else if (leader.getCurrentPoseType() == PoseType.SLEEP) {
            class_2338 class_23382 = entity.method_24515().method_10069(0, -1, 0);
            Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"offset(...)");
            if (entity.canSleepAt(class_23382) && BrainExtensionsKt.getMemorySafely(entity.method_18868(), CobblemonMemories.POKEMON_DROWSY).orElse(false).booleanValue() && entity.method_59922().method_43057() < 0.025f) {
                this.applySleep(entity);
            }
        } else if (BrainExtensionsKt.getMemorySafely(entity.method_18868(), CobblemonMemories.POKEMON_SLEEPING).orElse(false).booleanValue() && entity.method_59922().method_43057() < 0.06666667f) {
            this.removeSleep(entity);
        }
    }

    @NotNull
    public final class_243 getRandomOffset(@NotNull PokemonEntity entity, @NotNull class_3218 level) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        PokemonEntity pokemonEntity = this.leader;
        if (pokemonEntity == null) {
            class_243 class_2432 = class_243.field_1353;
            Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"ZERO");
            return class_2432;
        }
        PokemonEntity leader = pokemonEntity;
        double minRange = this.closeEnough;
        double maxRange = this.tooFar - this.closeEnough / (float)2;
        double randomDistance = class_3532.method_15366((class_5819)level.field_9229, (double)minRange, (double)maxRange);
        double randomAngle = class_3532.method_15366((class_5819)level.field_9229, (double)0.0, (double)(Math.PI * 2));
        class_243 offset = new class_243(Math.cos(randomAngle) * randomDistance, 0.0, Math.sin(randomAngle) * randomDistance);
        if (entity.method_52535() && leader.method_52535() || entity.isFlying() && leader.isFlying()) {
            double verticalRange = randomDistance * 0.5;
            double randomY = class_3532.method_15366((class_5819)level.field_9229, (double)(-verticalRange), (double)verticalRange);
            class_243 class_2433 = offset.method_1031(0.0, randomY, 0.0);
            Intrinsics.checkNotNullExpressionValue((Object)class_2433, (String)"add(...)");
            offset = class_2433;
        }
        return offset;
    }

    public final void applySleep(@NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        entity.method_18868().method_18878(CobblemonMemories.POKEMON_SLEEPING, (Object)true);
        entity.getPokemon().setStatus(new PersistentStatusContainer(Statuses.SLEEP, 0, 2, null));
    }

    public final void removeSleep(@NotNull PokemonEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.method_18868().method_18896(CobblemonMemories.POKEMON_SLEEPING)) {
            entity.method_18868().method_18875(CobblemonMemories.POKEMON_SLEEPING);
            PersistentStatusContainer status = entity.getPokemon().getStatus();
            if (status != null && Intrinsics.areEqual((Object)status.getStatus(), (Object)Statuses.SLEEP)) {
                entity.getPokemon().setStatus(null);
            }
        }
    }

    private static final UUID checkExtraStartConditions$lambda$0(Function1 $tmp0, Object p0) {
        return (UUID)$tmp0.invoke(p0);
    }

    private static final boolean tick$lambda$0(class_7 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

