/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.datafixer.fix;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.class_1208;
import net.minecraft.class_9228;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ3\u0010\u000f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J3\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00112\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\rH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00152\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/cobblemon/mod/common/datafixer/fix/BlockPosUpdateFix;", "Lcom/mojang/datafixers/DataFix;", "Lcom/mojang/datafixers/schemas/Schema;", "outputSchema", "<init>", "(Lcom/mojang/datafixers/schemas/Schema;)V", "Lcom/mojang/datafixers/TypeRewriteRule;", "makeRule", "()Lcom/mojang/datafixers/TypeRewriteRule;", "Lcom/mojang/datafixers/DSL$TypeReference;", "typeReference", "", "string", "", "map", "createBlockEntityFixer", "(Lcom/mojang/datafixers/DSL$TypeReference;Ljava/lang/String;Ljava/util/Map;)Lcom/mojang/datafixers/TypeRewriteRule;", "Lcom/mojang/datafixers/Typed;", "typed", "fixFields", "(Lcom/mojang/datafixers/Typed;Ljava/util/Map;)Lcom/mojang/datafixers/Typed;", "Lcom/mojang/serialization/Dynamic;", "entityNbt", "fixPokemonEntity", "(Lcom/mojang/serialization/Dynamic;)Lcom/mojang/serialization/Dynamic;", "multiblockNbt", "fixFossilMultiblock", "common"})
public final class BlockPosUpdateFix
extends DataFix {
    public BlockPosUpdateFix(@NotNull Schema outputSchema) {
        Intrinsics.checkNotNullParameter((Object)outputSchema, (String)"outputSchema");
        super(outputSchema, false);
    }

    @NotNull
    protected TypeRewriteRule makeRule() {
        Type pokemonType = this.getInputSchema().getChoiceType(class_1208.field_5729, "cobblemon:pokemon");
        OpticFinder controllerFinder = DSL.namedChoice((String)"cobblemon:fossil_analyzer", (Type)this.getInputSchema().getChoiceType(class_1208.field_5727, "cobblemon:fossil_multiblock"));
        DSL.TypeReference typeReference = class_1208.field_5727;
        Intrinsics.checkNotNullExpressionValue((Object)typeReference, (String)"BLOCK_ENTITY");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"TetherMaxRoamPos", (Object)"TetherMaxRoamPos"), TuplesKt.to((Object)"TetherMinRoamPos", (Object)"TetherMinRoamPos")};
        TypeRewriteRule typeRewriteRule = this.createBlockEntityFixer(typeReference, "cobblemon:pasture", MapsKt.mapOf((Pair[])pairArray));
        pairArray = new TypeRewriteRule[5];
        DSL.TypeReference typeReference2 = class_1208.field_5727;
        Intrinsics.checkNotNullExpressionValue((Object)typeReference2, (String)"BLOCK_ENTITY");
        pairArray[0] = this.createBlockEntityFixer(typeReference2, "cobblemon:fossil_analyzer", MapsKt.mapOf((Pair)TuplesKt.to((Object)"ControllerBlock", (Object)"ControllerBlock")));
        DSL.TypeReference typeReference3 = class_1208.field_5727;
        Intrinsics.checkNotNullExpressionValue((Object)typeReference3, (String)"BLOCK_ENTITY");
        pairArray[1] = this.createBlockEntityFixer(typeReference3, "cobblemon:restoration_tank", MapsKt.mapOf((Pair)TuplesKt.to((Object)"ControllerBlock", (Object)"ControllerBlock")));
        DSL.TypeReference typeReference4 = class_1208.field_5727;
        Intrinsics.checkNotNullExpressionValue((Object)typeReference4, (String)"BLOCK_ENTITY");
        pairArray[2] = this.createBlockEntityFixer(typeReference4, "cobblemon:fossil_multiblock", MapsKt.mapOf((Pair)TuplesKt.to((Object)"ControllerBlock", (Object)"ControllerBlock")));
        pairArray[3] = this.fixTypeEverywhereTyped("Fossil multiblock pos fixer", this.getInputSchema().getType(class_1208.field_5727), arg_0 -> BlockPosUpdateFix.makeRule$lambda$0(controllerFinder, this, arg_0));
        pairArray[4] = this.fixTypeEverywhereTyped("Pokemon entity tethering pos fixer", pokemonType, arg_0 -> BlockPosUpdateFix.makeRule$lambda$1(this, arg_0));
        TypeRewriteRule typeRewriteRule2 = TypeRewriteRule.seq((TypeRewriteRule)typeRewriteRule, (TypeRewriteRule[])pairArray);
        Intrinsics.checkNotNullExpressionValue((Object)typeRewriteRule2, (String)"seq(...)");
        return typeRewriteRule2;
    }

    private final TypeRewriteRule createBlockEntityFixer(DSL.TypeReference typeReference, String string, Map<String, String> map) {
        String fixerName = "Block pos fixer for " + string + "}";
        OpticFinder opticFinder = DSL.namedChoice((String)string, (Type)this.getInputSchema().getChoiceType(typeReference, string));
        TypeRewriteRule typeRewriteRule = this.fixTypeEverywhereTyped(fixerName, this.getInputSchema().getType(typeReference), arg_0 -> BlockPosUpdateFix.createBlockEntityFixer$lambda$0(opticFinder, this, map, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)typeRewriteRule, (String)"fixTypeEverywhereTyped(...)");
        return typeRewriteRule;
    }

    private final Typed<?> fixFields(Typed<?> typed, Map<String, String> map) {
        Typed typed2 = typed.update(DSL.remainderFinder(), arg_0 -> BlockPosUpdateFix.fixFields$lambda$0(map, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)typed2, (String)"update(...)");
        return typed2;
    }

    private final Dynamic<?> fixPokemonEntity(Dynamic<?> entityNbt) {
        Dynamic dynamic = entityNbt.update("Tethering", BlockPosUpdateFix::fixPokemonEntity$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)dynamic, (String)"update(...)");
        return dynamic;
    }

    private final Dynamic<?> fixFossilMultiblock(Dynamic<?> multiblockNbt) {
        Dynamic dynamic = multiblockNbt.update("MonitorPos", class_9228::method_56943).update("TankBasePos", class_9228::method_56943).update("AnalyzerPos", class_9228::method_56943);
        Intrinsics.checkNotNullExpressionValue((Object)dynamic, (String)"update(...)");
        return dynamic;
    }

    private static final Typed makeRule$lambda$0(OpticFinder $controllerFinder, BlockPosUpdateFix this$0, Typed typed) {
        return typed.updateTyped($controllerFinder, arg_0 -> BlockPosUpdateFix.makeRule$lambda$0$0(this$0, arg_0));
    }

    private static final Typed makeRule$lambda$0$0(BlockPosUpdateFix this$0, Typed controllerTyped) {
        return controllerTyped.update(DSL.remainderFinder(), arg_0 -> BlockPosUpdateFix.makeRule$lambda$0$0$0(this$0, arg_0));
    }

    private static final Dynamic makeRule$lambda$0$0$0(BlockPosUpdateFix this$0, Dynamic it) {
        return it.update("MultiblockStore", this$0::fixFossilMultiblock);
    }

    private static final Typed makeRule$lambda$1(BlockPosUpdateFix this$0, Typed typed) {
        return typed.update(DSL.remainderFinder(), this$0::fixPokemonEntity);
    }

    private static final Typed createBlockEntityFixer$lambda$0(OpticFinder $opticFinder, BlockPosUpdateFix this$0, Map $map, Typed typed) {
        return typed.updateTyped($opticFinder, arg_0 -> BlockPosUpdateFix.createBlockEntityFixer$lambda$0$0(this$0, $map, arg_0));
    }

    private static final Typed createBlockEntityFixer$lambda$0$0(BlockPosUpdateFix this$0, Map $map, Typed typedx) {
        Intrinsics.checkNotNull((Object)typedx);
        return this$0.fixFields(typedx, $map);
    }

    private static final Dynamic fixFields$lambda$0(Map $map, Dynamic it) {
        Ref.ObjectRef result = new Ref.ObjectRef();
        result.element = it;
        $map.forEach((arg_0, arg_1) -> BlockPosUpdateFix.fixFields$lambda$0$1((arg_0, arg_1) -> BlockPosUpdateFix.fixFields$lambda$0$0(result, arg_0, arg_1), arg_0, arg_1));
        return (Dynamic)result.element;
    }

    private static final Unit fixFields$lambda$0$0(Ref.ObjectRef $result, String key, String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $result.element = ((Dynamic)$result.element).renameAndFixField(key, value, BlockPosUpdateFix::fixFields$lambda$0$0$0);
        return Unit.INSTANCE;
    }

    private static final Dynamic fixFields$lambda$0$0$0(Dynamic dynamic) {
        Dynamic dynamic2 = dynamic;
        Intrinsics.checkNotNull((Object)dynamic2);
        return class_9228.method_56943((Dynamic)dynamic2);
    }

    private static final void fixFields$lambda$0$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final Dynamic fixPokemonEntity$lambda$0(Dynamic it) {
        return it.update("TetherMaxRoamPos", class_9228::method_56943).update("TetherMinRoamPos", class_9228::method_56943);
    }
}

