/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.compat.lambdynamiclights;

import com.cobblemon.mod.common.client.render.layer.PokemonOnShoulderRenderer;
import com.cobblemon.mod.common.compat.lambdynamiclights.CustomLuminance;
import com.cobblemon.mod.common.compat.lambdynamiclights.LambDynamicLightsInitializer;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class PlayerLuminance
extends CustomLuminance
implements EntityLuminance {
    public static final PlayerLuminance INSTANCE = new PlayerLuminance();
    private static final class_6862<class_1792> POKEDEX = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"cobblemon", (String)"pokedex"));

    @NotNull
    public EntityLuminance.Type type() {
        return LambDynamicLightsInitializer.PLAYER_LUMINANCE;
    }

    public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            int shoulderLightLevel = PlayerLuminance.shoulderLuminance(itemLightSourceManager, player);
            int itemLightLevel = player.method_24520(stack -> stack.method_31573(POKEDEX)) ? 13 : 0;
            return Math.max(shoulderLightLevel, itemLightLevel);
        }
        return 0;
    }

    private static @Range(from=0L, to=15L) int shoulderLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull class_1657 player) {
        PokemonOnShoulderRenderer.ShoulderData leftShoulder = PokemonOnShoulderRenderer.shoulderDataFrom(player.method_7356());
        PokemonOnShoulderRenderer.ShoulderData rightShoulder = PokemonOnShoulderRenderer.shoulderDataFrom(player.method_7308());
        if (leftShoulder == null && rightShoulder == null) {
            return 0;
        }
        int leftShoulderLightLevel = PlayerLuminance.extractShoulderLightLevel(leftShoulder, itemLightSourceManager, player.method_5869());
        int rightShoulderLightLevel = PlayerLuminance.extractShoulderLightLevel(rightShoulder, itemLightSourceManager, player.method_5869());
        return Math.max(leftShoulderLightLevel, rightShoulderLightLevel);
    }

    private static int extractShoulderLightLevel(@Nullable PokemonOnShoulderRenderer.ShoulderData shoulderData, @NotNull ItemLightSourceManager itemLightSourceManager, boolean underwater) {
        if (shoulderData == null) {
            return 0;
        }
        class_1799 item = shoulderData.getShownItem();
        int itemLightLevel = item.method_7960() ? 0 : itemLightSourceManager.getLuminance(item, underwater);
        int formLightLevel = PlayerLuminance.extractFormLightLevel(shoulderData.getForm(), underwater).orElse(0);
        return Math.max(itemLightLevel, formLightLevel);
    }
}

