/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.command;

import com.cobblemon.mod.common.api.permission.CobblemonPermissions;
import com.cobblemon.mod.common.api.spawning.SpawnCause;
import com.cobblemon.mod.common.api.spawning.detail.EntitySpawnResult;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawner;
import com.cobblemon.mod.common.api.spawning.spawner.SpawningZoneInput;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.util.CommandUtilsKt;
import com.cobblemon.mod.common.util.EntityExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.PermissionUtilsKt;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000e\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012R\u001c\u0010\u0016\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/cobblemon/mod/common/command/SpawnPokemonFromPool;", "", "<init>", "()V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "", "register", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "amount", "execute", "(Lcom/mojang/brigadier/context/CommandContext;I)I", "", "NAME", "Ljava/lang/String;", "ALIAS", "Lnet/minecraft/class_5250;", "kotlin.jvm.PlatformType", "UNABLE_TO_SPAWN", "Lnet/minecraft/class_5250;", "common"})
@SourceDebugExtension(value={"SMAP\nSpawnPokemonFromPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpawnPokemonFromPool.kt\ncom/cobblemon/mod/common/command/SpawnPokemonFromPool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1869#2,2:82\n*S KotlinDebug\n*F\n+ 1 SpawnPokemonFromPool.kt\ncom/cobblemon/mod/common/command/SpawnPokemonFromPool\n*L\n69#1:82,2\n*E\n"})
public final class SpawnPokemonFromPool {
    @NotNull
    public static final SpawnPokemonFromPool INSTANCE = new SpawnPokemonFromPool();
    @NotNull
    public static final String NAME = "spawnpokemonfrompool";
    @NotNull
    public static final String ALIAS = "forcespawn";
    private static final class_5250 UNABLE_TO_SPAWN = LocalizationUtilsKt.commandLang("spawnpokemonfrompool.unable_to_spawn", new Object[0]);

    private SpawnPokemonFromPool() {
    }

    public final void register(@NotNull CommandDispatcher<class_2168> dispatcher) {
        Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
        LiteralArgumentBuilder literalArgumentBuilder = class_2170.method_9247((String)NAME);
        Intrinsics.checkNotNullExpressionValue((Object)literalArgumentBuilder, (String)"literal(...)");
        LiteralCommandNode spawnPokemonFromPoolCommand = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)PermissionUtilsKt.permission$default((ArgumentBuilder)literalArgumentBuilder, CobblemonPermissions.getSPAWN_POKEMON(), false, 2, null)).then(class_2170.method_9244((String)"amount", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1))).executes(SpawnPokemonFromPool::register$lambda$0))).executes(SpawnPokemonFromPool::register$lambda$1));
        Intrinsics.checkNotNull((Object)spawnPokemonFromPoolCommand);
        dispatcher.register(CommandUtilsKt.alias(spawnPokemonFromPoolCommand, ALIAS));
    }

    private final int execute(CommandContext<class_2168> context, int amount) {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Intrinsics.checkNotNull((Object)player);
        PlayerSpawner spawner = PlayerExtensionsKt.getSpawner(player);
        int spawnsTriggered = 0;
        for (int i = 0; i < amount; ++i) {
            int it = i;
            boolean bl = false;
            SpawnCause spawnCause = new SpawnCause(spawner, (class_1297)player);
            SpawningZoneInput spawningZoneInput = spawner.getZoneInput(spawnCause);
            if (spawningZoneInput == null) continue;
            List<Object> results = spawner.runForArea(spawningZoneInput, 1);
            if (results.isEmpty()) {
                class_5250 class_52502 = UNABLE_TO_SPAWN;
                Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"UNABLE_TO_SPAWN");
                player.method_43496((class_2561)TextKt.red(class_52502));
                continue;
            }
            Iterable $this$forEach$iv = results;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it2 = element$iv = iterator.next();
                boolean bl2 = false;
                if (!(it2 instanceof EntitySpawnResult)) continue;
                for (class_1297 entity : ((EntitySpawnResult)it2).getEntities()) {
                    ++spawnsTriggered;
                    Object[] objectArray = new Object[1];
                    Intrinsics.checkNotNullExpressionValue((Object)EntityExtensionsKt.effectiveName(entity), (String)"effectiveName(...)");
                    class_5250 class_52503 = LocalizationUtilsKt.commandLang(NAME, objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"commandLang(...)");
                    player.method_43496((class_2561)TextKt.green(class_52503));
                }
            }
        }
        return spawnsTriggered;
    }

    private static final int register$lambda$0(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.execute((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"));
    }

    private static final int register$lambda$1(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return INSTANCE.execute((CommandContext<class_2168>)context, 1);
    }
}

