/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.client.gui.pasture;

import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.pasture.PasturePermissions;
import com.cobblemon.mod.common.api.reactive.SettableObservable;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.client.gui.pc.PCGUI;
import com.cobblemon.mod.common.client.gui.pc.PCGUIConfiguration;
import com.cobblemon.mod.common.net.messages.client.pasture.OpenPasturePacket;
import com.cobblemon.mod.common.net.messages.server.pasture.PasturePokemonPacket;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R#\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u000b\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/cobblemon/mod/common/client/gui/pasture/PasturePCGUIConfiguration;", "Lcom/cobblemon/mod/common/client/gui/pc/PCGUIConfiguration;", "Ljava/util/UUID;", "pastureId", "", "limit", "Lcom/cobblemon/mod/common/api/reactive/SettableObservable;", "", "Lcom/cobblemon/mod/common/net/messages/client/pasture/OpenPasturePacket$PasturePokemonDataDTO;", "pasturedPokemon", "Lcom/cobblemon/mod/common/api/pasture/PasturePermissions;", "permissions", "<init>", "(Ljava/util/UUID;ILcom/cobblemon/mod/common/api/reactive/SettableObservable;Lcom/cobblemon/mod/common/api/pasture/PasturePermissions;)V", "Ljava/util/UUID;", "getPastureId", "()Ljava/util/UUID;", "I", "getLimit", "()I", "Lcom/cobblemon/mod/common/api/reactive/SettableObservable;", "getPasturedPokemon", "()Lcom/cobblemon/mod/common/api/reactive/SettableObservable;", "Lcom/cobblemon/mod/common/api/pasture/PasturePermissions;", "getPermissions", "()Lcom/cobblemon/mod/common/api/pasture/PasturePermissions;", "setPermissions", "(Lcom/cobblemon/mod/common/api/pasture/PasturePermissions;)V", "common"})
public final class PasturePCGUIConfiguration
extends PCGUIConfiguration {
    @NotNull
    private final UUID pastureId;
    private final int limit;
    @NotNull
    private final SettableObservable<List<OpenPasturePacket.PasturePokemonDataDTO>> pasturedPokemon;
    @NotNull
    private PasturePermissions permissions;

    public PasturePCGUIConfiguration(@NotNull UUID pastureId, int limit, @NotNull SettableObservable<List<OpenPasturePacket.PasturePokemonDataDTO>> pasturedPokemon, @NotNull PasturePermissions permissions) {
        Intrinsics.checkNotNullParameter((Object)pastureId, (String)"pastureId");
        Intrinsics.checkNotNullParameter(pasturedPokemon, (String)"pasturedPokemon");
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        super((Function1<? super PCGUI, Unit>)((Function1)PasturePCGUIConfiguration::_init_$lambda$0), (Function3<? super PCGUI, ? super StorePosition, ? super Pokemon, Unit>)((Function3)(arg_0, arg_1, arg_2) -> PasturePCGUIConfiguration._init_$lambda$1(permissions, pastureId, arg_0, arg_1, arg_2)), false, (Function1<? super Pokemon, Boolean>)((Function1)PasturePCGUIConfiguration::_init_$lambda$2));
        this.pastureId = pastureId;
        this.limit = limit;
        this.pasturedPokemon = pasturedPokemon;
        this.permissions = permissions;
    }

    @NotNull
    public final UUID getPastureId() {
        return this.pastureId;
    }

    public final int getLimit() {
        return this.limit;
    }

    @NotNull
    public final SettableObservable<List<OpenPasturePacket.PasturePokemonDataDTO>> getPasturedPokemon() {
        return this.pasturedPokemon;
    }

    @NotNull
    public final PasturePermissions getPermissions() {
        return this.permissions;
    }

    public final void setPermissions(@NotNull PasturePermissions pasturePermissions) {
        Intrinsics.checkNotNullParameter((Object)pasturePermissions, (String)"<set-?>");
        this.permissions = pasturePermissions;
    }

    private static final Unit _init_$lambda$0(PCGUI it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.closeNormally(true);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(PasturePermissions $permissions, UUID $pastureId, PCGUI pcGui, StorePosition position, Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pcGui, (String)"pcGui");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        if (pokemon != null && !pokemon.isFainted() && pokemon.getTetheringId() == null && $permissions.getCanPasture()) {
            UUID uUID = pokemon.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            CobblemonNetwork.sendToServer(new PasturePokemonPacket(uUID, $pastureId));
            pcGui.playSound(CobblemonSounds.PC_CLICK);
        }
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$2(Pokemon pokemon) {
        Intrinsics.checkNotNullParameter((Object)pokemon, (String)"pokemon");
        return !pokemon.isFainted() && pokemon.getTetheringId() == null;
    }
}

