/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.interpreter.instructions;

import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.net.messages.client.battle.BattleHealthChangePacket;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0011\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/cobblemon/mod/common/battles/interpreter/instructions/SetHpInstruction;", "Lcom/cobblemon/mod/common/battles/dispatch/InterpreterInstruction;", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "actor", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "publicMessage", "privateMessage", "<init>", "(Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;)V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "", "invoke", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "getActor", "()Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getPublicMessage", "()Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getPrivateMessage", "common"})
public final class SetHpInstruction
implements InterpreterInstruction {
    @NotNull
    private final BattleActor actor;
    @NotNull
    private final BattleMessage publicMessage;
    @NotNull
    private final BattleMessage privateMessage;

    public SetHpInstruction(@NotNull BattleActor actor, @NotNull BattleMessage publicMessage, @NotNull BattleMessage privateMessage) {
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        Intrinsics.checkNotNullParameter((Object)publicMessage, (String)"publicMessage");
        Intrinsics.checkNotNullParameter((Object)privateMessage, (String)"privateMessage");
        this.actor = actor;
        this.publicMessage = publicMessage;
        this.privateMessage = privateMessage;
    }

    @NotNull
    public final BattleActor getActor() {
        return this.actor;
    }

    @NotNull
    public final BattleMessage getPublicMessage() {
        return this.publicMessage;
    }

    @NotNull
    public final BattleMessage getPrivateMessage() {
        return this.privateMessage;
    }

    @Override
    public void invoke(@NotNull PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        PokemonBattle.dispatchWaiting$default(battle, 0.0f, () -> SetHpInstruction.invoke$lambda$0(this, battle), 1, null);
    }

    private static final Unit invoke$lambda$0(SetHpInstruction this$0, PokemonBattle $battle) {
        String[] stringArray;
        String[] stringArray2;
        Pair<String, String> pair = this$0.privateMessage.pnxAndUuid(0);
        if (pair == null) {
            return Unit.INSTANCE;
        }
        String pnx = (String)pair.component1();
        Object object = this$0.privateMessage.argumentAt(1);
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray2 = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) == null || (object = (String)CollectionsKt.getOrNull((List)object, (int)0)) == null || (object = StringsKt.toFloatOrNull((String)object)) == null) {
            return Unit.INSTANCE;
        }
        float flatHp = ((Float)object).floatValue();
        Object object2 = this$0.publicMessage.argumentAt(1);
        if (object2 == null || (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])(stringArray = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) == null || (object2 = (String)CollectionsKt.getOrNull((List)object2, (int)0)) == null || (object2 = StringsKt.toFloatOrNull((String)object2)) == null) {
            return Unit.INSTANCE;
        }
        float ratioHp = ((Float)object2).floatValue() * 0.01f;
        BattlePokemon battlePokemon = this$0.privateMessage.battlePokemon(0, $battle);
        if (battlePokemon == null) {
            return Unit.INSTANCE;
        }
        BattlePokemon battlePokemon2 = battlePokemon;
        battlePokemon2.getEffectedPokemon().setCurrentHealth(MathKt.roundToInt((float)flatHp));
        PokemonBattle.sendSidedUpdate$default($battle, this$0.actor, new BattleHealthChangePacket(pnx, flatHp, null, 4, null), new BattleHealthChangePacket(pnx, ratioHp, null, 4, null), false, 8, null);
        if (!this$0.publicMessage.hasOptionalArgument("silent")) {
            Object object3 = BattleMessage.effect$default(this$0.publicMessage, null, 1, null);
            if (object3 == null || (object3 = object3.getId()) == null) {
                return Unit.INSTANCE;
            }
            Object effectID = object3;
            class_5250 lang = LocalizationUtilsKt.battleLang("sethp." + (String)effectID, new Object[0]);
            Intrinsics.checkNotNull((Object)lang);
            $battle.broadcastChatMessage((class_2561)lang);
        }
        ((Map)$battle.getMinorBattleActions()).put(battlePokemon2.getUuid(), this$0.publicMessage);
        return Unit.INSTANCE;
    }
}

