/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles.interpreter.instructions;

import com.cobblemon.mod.common.api.battles.interpreter.BattleMessage;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.ShowdownActionRequest;
import com.cobblemon.mod.common.battles.dispatch.InterpreterInstruction;
import com.cobblemon.mod.common.net.messages.client.battle.BattleMakeChoicePacket;
import com.cobblemon.mod.common.net.messages.client.battle.BattleQueueRequestPacket;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/cobblemon/mod/common/battles/interpreter/instructions/RequestInstruction;", "Lcom/cobblemon/mod/common/battles/dispatch/InterpreterInstruction;", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "battleActor", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "message", "<init>", "(Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;)V", "Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;", "battle", "", "invoke", "(Lcom/cobblemon/mod/common/api/battles/model/PokemonBattle;)V", "Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "getBattleActor", "()Lcom/cobblemon/mod/common/api/battles/model/actor/BattleActor;", "Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "getMessage", "()Lcom/cobblemon/mod/common/api/battles/interpreter/BattleMessage;", "common"})
public final class RequestInstruction
implements InterpreterInstruction {
    @NotNull
    private final BattleActor battleActor;
    @NotNull
    private final BattleMessage message;

    public RequestInstruction(@NotNull BattleActor battleActor, @NotNull BattleMessage message) {
        Intrinsics.checkNotNullParameter((Object)battleActor, (String)"battleActor");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.battleActor = battleActor;
        this.message = message;
    }

    @NotNull
    public final BattleActor getBattleActor() {
        return this.battleActor;
    }

    @NotNull
    public final BattleMessage getMessage() {
        return this.message;
    }

    @Override
    public void invoke(@NotNull PokemonBattle battle) {
        Intrinsics.checkNotNullParameter((Object)battle, (String)"battle");
        battle.log("Request Instruction");
        if (StringsKt.contains$default((CharSequence)this.message.getRawMessage(), (CharSequence)"teamPreview", (boolean)false, (int)2, null)) {
            return;
        }
        String[] stringArray = new String[]{"|request|"};
        ShowdownActionRequest request = (ShowdownActionRequest)BattleRegistry.INSTANCE.getGson().fromJson((String)StringsKt.split$default((CharSequence)this.message.getRawMessage(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1), ShowdownActionRequest.class);
        request.sanitize(battle, this.battleActor);
        battle.dispatchGo((Function0<Unit>)((Function0)() -> RequestInstruction.invoke$lambda$0(this, request, battle)));
    }

    private static final Unit invoke$lambda$0(RequestInstruction this$0, ShowdownActionRequest $request, PokemonBattle $battle) {
        BattleActor battleActor = this$0.battleActor;
        Intrinsics.checkNotNull((Object)$request);
        battleActor.sendUpdate(new BattleQueueRequestPacket($request));
        this$0.battleActor.setRequest($request);
        this$0.battleActor.getResponses().clear();
        if ($request.getForceSwitch().contains(true)) {
            $battle.doWhenClear((Function0<Unit>)((Function0)() -> RequestInstruction.invoke$lambda$0$0(this$0)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$0$0(RequestInstruction this$0) {
        this$0.battleActor.setMustChoose(true);
        this$0.battleActor.sendUpdate(new BattleMakeChoicePacket());
        return Unit.INSTANCE;
    }
}

