/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.battles;

import com.cobblemon.mod.common.battles.BattleStartError;
import com.cobblemon.mod.common.util.EntityExtensionsKt;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0010\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/cobblemon/mod/common/battles/InsufficientPokemonError;", "Lcom/cobblemon/mod/common/battles/BattleStartError;", "Lnet/minecraft/class_1297;", "actorEntity", "", "requiredCount", "hadCount", "<init>", "(Lnet/minecraft/class_1297;II)V", "entity", "Lnet/minecraft/class_5250;", "getMessageFor", "(Lnet/minecraft/class_1297;)Lnet/minecraft/class_5250;", "Lnet/minecraft/class_1297;", "getActorEntity", "()Lnet/minecraft/class_1297;", "I", "getRequiredCount", "()I", "getHadCount", "common"})
public final class InsufficientPokemonError
implements BattleStartError {
    @NotNull
    private final class_1297 actorEntity;
    private final int requiredCount;
    private final int hadCount;

    public InsufficientPokemonError(@NotNull class_1297 actorEntity, int requiredCount, int hadCount) {
        Intrinsics.checkNotNullParameter((Object)actorEntity, (String)"actorEntity");
        this.actorEntity = actorEntity;
        this.requiredCount = requiredCount;
        this.hadCount = hadCount;
    }

    @NotNull
    public final class_1297 getActorEntity() {
        return this.actorEntity;
    }

    public final int getRequiredCount() {
        return this.requiredCount;
    }

    public final int getHadCount() {
        return this.hadCount;
    }

    @Override
    @NotNull
    public class_5250 getMessageFor(@NotNull class_1297 entity) {
        class_5250 class_52502;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (Intrinsics.areEqual((Object)this.actorEntity, (Object)entity)) {
            String key = this.hadCount == 0 ? "no_pokemon" : "insufficient_pokemon.personal";
            Object[] objectArray = new Object[]{this.hadCount, this.requiredCount};
            class_5250 class_52503 = LocalizationUtilsKt.battleLang("error." + key, objectArray);
            Intrinsics.checkNotNull((Object)class_52503);
            class_52502 = class_52503;
        } else {
            Object[] objectArray = new Object[3];
            Intrinsics.checkNotNullExpressionValue((Object)EntityExtensionsKt.effectiveName(this.actorEntity), (String)"effectiveName(...)");
            objectArray[1] = this.hadCount;
            objectArray[2] = this.requiredCount;
            class_5250 class_52504 = LocalizationUtilsKt.battleLang("error.insufficient_pokemon", objectArray);
            Intrinsics.checkNotNull((Object)class_52504);
            class_52502 = class_52504;
        }
        return class_52502;
    }
}

