/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.player.adapter;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.player.InstancedPlayerData;
import com.cobblemon.mod.common.api.storage.player.PlayerInstancedDataStoreType;
import com.cobblemon.mod.common.api.storage.player.adapter.PlayerDataStoreBackend;
import java.io.File;
import java.nio.file.Path;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000 4*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003:\u00014B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0010H\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0013J+\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00028\u00000\u0014H\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018J#\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00102\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ#\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00102\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010!\u001a\u0004\b\"\u0010#R\u0017\u0010\b\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001e\u001a\u0004\b$\u0010 R \u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00028\u00000\u00148&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\"\u0010)\u001a\u00020(8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u00100\u001a\u00020/8\u0006X\u0086D\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103\u00a8\u00065"}, d2={"Lcom/cobblemon/mod/common/api/storage/player/adapter/FileBasedPlayerDataStoreBackend;", "Lcom/cobblemon/mod/common/api/storage/player/InstancedPlayerData;", "T", "Lcom/cobblemon/mod/common/api/storage/player/adapter/PlayerDataStoreBackend;", "", "subfolder", "Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreType;", "type", "fileExt", "<init>", "(Ljava/lang/String;Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreType;Ljava/lang/String;)V", "Lnet/minecraft/server/MinecraftServer;", "server", "", "setup", "(Lnet/minecraft/server/MinecraftServer;)V", "Ljava/util/UUID;", "uuid", "postSaveFileMoving", "(Ljava/util/UUID;)V", "Lkotlin/Function1;", "Ljava/io/File;", "loadFunction", "loadWithFallback", "(Ljava/util/UUID;Lkotlin/jvm/functions/Function1;)Lcom/cobblemon/mod/common/api/storage/player/InstancedPlayerData;", "extension", "getSubFile", "(Ljava/util/UUID;Ljava/lang/String;)Ljava/lang/String;", "filePath", "(Ljava/util/UUID;Ljava/lang/String;)Ljava/io/File;", "Ljava/lang/String;", "getSubfolder", "()Ljava/lang/String;", "Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreType;", "getType", "()Lcom/cobblemon/mod/common/api/storage/player/PlayerInstancedDataStoreType;", "getFileExt", "getDefaultData", "()Lkotlin/jvm/functions/Function1;", "defaultData", "Ljava/nio/file/Path;", "savePath", "Ljava/nio/file/Path;", "getSavePath", "()Ljava/nio/file/Path;", "setSavePath", "(Ljava/nio/file/Path;)V", "", "useNestedStructure", "Z", "getUseNestedStructure", "()Z", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nFileBasedPlayerDataStoreBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileBasedPlayerDataStoreBackend.kt\ncom/cobblemon/mod/common/api/storage/player/adapter/FileBasedPlayerDataStoreBackend\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,106:1\n1#2:107\n*E\n"})
public abstract class FileBasedPlayerDataStoreBackend<T extends InstancedPlayerData>
extends PlayerDataStoreBackend<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String subfolder;
    @NotNull
    private final PlayerInstancedDataStoreType type;
    @NotNull
    private final String fileExt;
    public Path savePath;
    private final boolean useNestedStructure;
    @NotNull
    public static final String OLD_FILE_EXTENSION = "old";
    @NotNull
    public static final String TEMPORARY_FILE_EXTENSION = "tmp";

    public FileBasedPlayerDataStoreBackend(@NotNull String subfolder, @NotNull PlayerInstancedDataStoreType type, @NotNull String fileExt) {
        Intrinsics.checkNotNullParameter((Object)subfolder, (String)"subfolder");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)fileExt, (String)"fileExt");
        super(type);
        this.subfolder = subfolder;
        this.type = type;
        this.fileExt = fileExt;
        this.useNestedStructure = true;
    }

    @NotNull
    public final String getSubfolder() {
        return this.subfolder;
    }

    @NotNull
    public final PlayerInstancedDataStoreType getType() {
        return this.type;
    }

    @NotNull
    public final String getFileExt() {
        return this.fileExt;
    }

    @NotNull
    public abstract Function1<UUID, T> getDefaultData();

    @NotNull
    public final Path getSavePath() {
        Path path = this.savePath;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"savePath");
        return null;
    }

    public final void setSavePath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.savePath = path;
    }

    public final boolean getUseNestedStructure() {
        return this.useNestedStructure;
    }

    @Override
    public void setup(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Path path = server.method_27050(class_5218.field_24182).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        this.setSavePath(path);
    }

    protected final void postSaveFileMoving(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        File tempFile = this.filePath(uuid, TEMPORARY_FILE_EXTENSION);
        File oldFile = this.filePath(uuid, OLD_FILE_EXTENSION);
        File file = FileBasedPlayerDataStoreBackend.filePath$default(this, uuid, null, 2, null);
        if (file.exists()) {
            FilesKt.copyTo$default((File)file, (File)oldFile, (boolean)true, (int)0, (int)4, null);
        }
        FilesKt.copyTo$default((File)tempFile, (File)file, (boolean)true, (int)0, (int)4, null);
        tempFile.delete();
    }

    @NotNull
    protected final T loadWithFallback(@NotNull UUID uuid, @NotNull Function1<? super File, ? extends T> loadFunction) {
        InstancedPlayerData instancedPlayerData;
        InstancedPlayerData instancedPlayerData2;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter(loadFunction, (String)"loadFunction");
        File playerFile = FileBasedPlayerDataStoreBackend.filePath$default(this, uuid, null, 2, null);
        File playerFileOld = this.filePath(uuid, OLD_FILE_EXTENSION);
        playerFile.getParentFile().mkdirs();
        Function0 loadFallback = () -> FileBasedPlayerDataStoreBackend.loadWithFallback$lambda$0(playerFile, playerFileOld, loadFunction, this, uuid);
        if (playerFile.exists() && playerFile.length() > 0L) {
            try {
                instancedPlayerData2 = (InstancedPlayerData)loadFunction.invoke((Object)playerFile);
            }
            catch (Exception e) {
                Cobblemon.LOGGER.warn("Failed to load " + this.subfolder + " for " + uuid + " due to " + e.getMessage());
                Cobblemon.LOGGER.warn((Object)e);
                instancedPlayerData2 = (InstancedPlayerData)loadFallback.invoke();
            }
            instancedPlayerData = instancedPlayerData2;
        } else {
            instancedPlayerData = (InstancedPlayerData)loadFallback.invoke();
        }
        InstancedPlayerData it = instancedPlayerData2 = instancedPlayerData;
        boolean bl = false;
        it.initialize();
        return (T)instancedPlayerData2;
    }

    @JvmOverloads
    @NotNull
    public final String getSubFile(@NotNull UUID uuid, @Nullable String extension) {
        String string;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        if (this.useNestedStructure) {
            String string2 = uuid.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            String string3 = string2;
            int n = 0;
            int n2 = 2;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String string5 = extension;
            string = string4 + "/" + uuid + "." + this.fileExt + (String)(string5 != null ? "." + string5 : "");
        } else {
            String string6 = extension;
            string = uuid + "." + this.fileExt + "." + (String)(string6 != null ? "." + string6 : "");
        }
        return string;
    }

    public static /* synthetic */ String getSubFile$default(FileBasedPlayerDataStoreBackend fileBasedPlayerDataStoreBackend, UUID uUID, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getSubFile");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return fileBasedPlayerDataStoreBackend.getSubFile(uUID, string);
    }

    @JvmOverloads
    @NotNull
    public final File filePath(@NotNull UUID uuid, @Nullable String extension) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        File file = this.getSavePath().resolve(this.subfolder + "/" + this.getSubFile(uuid, extension)).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return file;
    }

    public static /* synthetic */ File filePath$default(FileBasedPlayerDataStoreBackend fileBasedPlayerDataStoreBackend, UUID uUID, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: filePath");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return fileBasedPlayerDataStoreBackend.filePath(uUID, string);
    }

    @JvmOverloads
    @NotNull
    public final String getSubFile(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return FileBasedPlayerDataStoreBackend.getSubFile$default(this, uuid, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final File filePath(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return FileBasedPlayerDataStoreBackend.filePath$default(this, uuid, null, 2, null);
    }

    private static final InstancedPlayerData loadWithFallback$lambda$0(File $playerFile, File $playerFileOld, Function1 $loadFunction, FileBasedPlayerDataStoreBackend this$0, UUID $uuid) {
        InstancedPlayerData instancedPlayerData;
        $playerFile.delete();
        if ($playerFileOld.exists() && $playerFileOld.length() > 0L) {
            InstancedPlayerData instancedPlayerData2;
            try {
                InstancedPlayerData result = (InstancedPlayerData)$loadFunction.invoke((Object)$playerFileOld);
                FilesKt.copyTo$default((File)$playerFileOld, (File)$playerFile, (boolean)false, (int)0, (int)6, null);
                Cobblemon.LOGGER.debug("Loaded .old {} for {}", (Object)this$0.subfolder, (Object)$uuid);
                instancedPlayerData2 = result;
            }
            catch (Exception e) {
                Cobblemon.LOGGER.error("Failed to load .old " + this$0.subfolder + " for " + $uuid + " due to " + e.getMessage() + ". Data is lost");
                Cobblemon.LOGGER.error((Object)e);
                $playerFileOld.delete();
                Object object = this$0.getDefaultData().invoke((Object)$uuid);
                InstancedPlayerData p0 = (InstancedPlayerData)object;
                boolean bl = false;
                this$0.save(p0);
                instancedPlayerData2 = (InstancedPlayerData)object;
            }
            instancedPlayerData = instancedPlayerData2;
        } else {
            Cobblemon.LOGGER.error(".old File " + this$0.subfolder + " for " + $uuid + " is corrupt or missing. Data is lost");
            $playerFileOld.delete();
            Object object = this$0.getDefaultData().invoke((Object)$uuid);
            InstancedPlayerData p0 = (InstancedPlayerData)object;
            boolean bl = false;
            this$0.save(p0);
            instancedPlayerData = (InstancedPlayerData)object;
        }
        return instancedPlayerData;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/cobblemon/mod/common/api/storage/player/adapter/FileBasedPlayerDataStoreBackend$Companion;", "", "<init>", "()V", "", "OLD_FILE_EXTENSION", "Ljava/lang/String;", "TEMPORARY_FILE_EXTENSION", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

