/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.molang;

import com.bedrockk.molang.runtime.struct.VariableStruct;
import com.bedrockk.molang.runtime.value.MoValue;
import com.cobblemon.mod.common.api.molang.MoLangFunctions;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.storage.molang.MoLangDataStoreFactory;
import com.cobblemon.mod.common.platform.events.PlatformEvents;
import com.cobblemon.mod.common.platform.events.ServerEvent;
import com.cobblemon.mod.common.platform.events.ServerPlayerEvent;
import com.cobblemon.mod.common.platform.events.ServerTickEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_5218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000f\u0010\u0010J)\u0010\u0013\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\n8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\n8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00118\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR#\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u001e8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001d\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060#8\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\"\u0010)\u001a\u00020(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\"\u0010/\u001a\u00020(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u0010*\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.\u00a8\u00062"}, d2={"Lcom/cobblemon/mod/common/api/storage/molang/NbtMoLangDataStoreFactory;", "Lcom/cobblemon/mod/common/api/storage/molang/MoLangDataStoreFactory;", "<init>", "()V", "", "saveAll", "Ljava/util/UUID;", "uuid", "markDirty", "(Ljava/util/UUID;)V", "", "filePath", "Lcom/bedrockk/molang/runtime/struct/VariableStruct;", "load", "(Ljava/util/UUID;Ljava/lang/String;)Lcom/bedrockk/molang/runtime/struct/VariableStruct;", "save", "(Ljava/util/UUID;Ljava/lang/String;)V", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "file", "(Ljava/util/UUID;Ljava/lang/String;)Ljava/nio/file/Path;", "DEFAULT_PATH", "Ljava/lang/String;", "DEFAULT_FOLDER_STRUCTURE", "savePath", "Ljava/nio/file/Path;", "getSavePath", "()Ljava/nio/file/Path;", "setSavePath", "(Ljava/nio/file/Path;)V", "", "cache", "Ljava/util/Map;", "getCache", "()Ljava/util/Map;", "", "dirty", "Ljava/util/List;", "getDirty", "()Ljava/util/List;", "", "ticker", "I", "getTicker", "()I", "setTicker", "(I)V", "saveTicks", "getSaveTicks", "setSaveTicks", "common"})
@SourceDebugExtension(value={"SMAP\nNbtMoLangDataStoreFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NbtMoLangDataStoreFactory.kt\ncom/cobblemon/mod/common/api/storage/molang/NbtMoLangDataStoreFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1869#2,2:93\n*S KotlinDebug\n*F\n+ 1 NbtMoLangDataStoreFactory.kt\ncom/cobblemon/mod/common/api/storage/molang/NbtMoLangDataStoreFactory\n*L\n55#1:93,2\n*E\n"})
public final class NbtMoLangDataStoreFactory
implements MoLangDataStoreFactory {
    @NotNull
    public static final NbtMoLangDataStoreFactory INSTANCE = new NbtMoLangDataStoreFactory();
    @NotNull
    public static final String DEFAULT_PATH = "playermolangdata/";
    @NotNull
    public static final String DEFAULT_FOLDER_STRUCTURE = "%s/%s.dat";
    public static Path savePath;
    @NotNull
    private static final Map<UUID, VariableStruct> cache;
    @NotNull
    private static final List<UUID> dirty;
    private static int ticker;
    private static int saveTicks;

    private NbtMoLangDataStoreFactory() {
    }

    @NotNull
    public final Path getSavePath() {
        Path path = savePath;
        if (path != null) {
            return path;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"savePath");
        return null;
    }

    public final void setSavePath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        savePath = path;
    }

    @NotNull
    public final Map<UUID, VariableStruct> getCache() {
        return cache;
    }

    @NotNull
    public final List<UUID> getDirty() {
        return dirty;
    }

    public final int getTicker() {
        return ticker;
    }

    public final void setTicker(int n) {
        ticker = n;
    }

    public final int getSaveTicks() {
        return saveTicks;
    }

    public final void setSaveTicks(int n) {
        saveTicks = n;
    }

    public final void saveAll() {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)dirty);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID p0 = (UUID)element$iv;
            boolean bl = false;
            NbtMoLangDataStoreFactory.save$default(this, p0, null, 2, null);
        }
    }

    @Override
    public void markDirty(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        dirty.add(uuid);
    }

    @Override
    @NotNull
    public VariableStruct load(@NotNull UUID uuid, @Nullable String filePath) {
        VariableStruct variableStruct;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        if (cache.containsKey(uuid)) {
            VariableStruct variableStruct2 = cache.get(uuid);
            Intrinsics.checkNotNull((Object)variableStruct2);
            variableStruct = variableStruct2;
        } else {
            Path file = NbtMoLangDataStoreFactory.file$default(this, uuid, null, 2, null);
            if (!file.toFile().exists()) {
                VariableStruct data = new VariableStruct();
                cache.put(uuid, data);
                return data;
            }
            String string = filePath;
            if (string == null) {
                string = DEFAULT_PATH;
            }
            class_2487 nbt = class_2507.method_30613((Path)this.file(uuid, string), (class_2505)class_2505.method_53898());
            Intrinsics.checkNotNull((Object)nbt);
            MoValue moValue = MoLangFunctions.INSTANCE.readMoValueFromNBT((class_2520)nbt);
            Intrinsics.checkNotNull((Object)moValue, (String)"null cannot be cast to non-null type com.bedrockk.molang.runtime.struct.VariableStruct");
            VariableStruct data = (VariableStruct)moValue;
            cache.put(uuid, data);
            variableStruct = data;
        }
        return variableStruct;
    }

    public final void save(@NotNull UUID uuid, @Nullable String filePath) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        String string = filePath;
        if (string == null) {
            string = DEFAULT_PATH;
        }
        Path file = this.file(uuid, string);
        VariableStruct variableStruct = cache.get(uuid);
        if (variableStruct == null) {
            return;
        }
        VariableStruct data = variableStruct;
        class_2520 class_25202 = MoLangFunctions.INSTANCE.writeMoValueToNBT(data);
        Intrinsics.checkNotNull((Object)class_25202);
        class_2487 nbt = (class_2487)class_25202;
        file.toFile().getParentFile().mkdirs();
        class_2507.method_30614((class_2487)nbt, (Path)file);
        ((Collection)dirty).remove(uuid);
    }

    public static /* synthetic */ void save$default(NbtMoLangDataStoreFactory nbtMoLangDataStoreFactory, UUID uUID, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        nbtMoLangDataStoreFactory.save(uUID, string);
    }

    private final Path file(UUID uuid, String filePath) {
        Path path = this.getSavePath();
        String string = DEFAULT_FOLDER_STRUCTURE;
        Object[] objectArray = new Object[2];
        String string2 = uuid.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = string2;
        int n = 0;
        int n2 = 2;
        Intrinsics.checkNotNullExpressionValue((Object)string3.substring(n, n2), (String)"substring(...)");
        objectArray[1] = uuid;
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        return path.resolve(filePath + string4);
    }

    static /* synthetic */ Path file$default(NbtMoLangDataStoreFactory nbtMoLangDataStoreFactory, UUID uUID, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = DEFAULT_PATH;
        }
        return nbtMoLangDataStoreFactory.file(uUID, string);
    }

    private static final Unit _init_$lambda$0(ServerEvent.Started event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Path path = event.getServer().method_27050(class_5218.field_24182).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
        INSTANCE.setSavePath(path);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ServerPlayerEvent.Logout event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        UUID uuid = event.getPlayer().method_5667();
        if (dirty.contains(uuid)) {
            Intrinsics.checkNotNull((Object)uuid);
            NbtMoLangDataStoreFactory.save$default(INSTANCE, uuid, null, 2, null);
            cache.remove(uuid);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ServerEvent.Stopping it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.saveAll();
        cache.clear();
        dirty.clear();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(ServerTickEvent.Post it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int n = ticker;
        ticker = n + 1;
        if (ticker % saveTicks == 0) {
            if (dirty.size() > 0) {
                INSTANCE.saveAll();
            }
        }
        return Unit.INSTANCE;
    }

    static {
        cache = new LinkedHashMap();
        dirty = new ArrayList();
        saveTicks = 100;
        Observable.subscribe$default(PlatformEvents.SERVER_STARTED, null, NbtMoLangDataStoreFactory::_init_$lambda$0, 1, null);
        Observable.subscribe$default(PlatformEvents.SERVER_PLAYER_LOGOUT, null, NbtMoLangDataStoreFactory::_init_$lambda$1, 1, null);
        Observable.subscribe$default(PlatformEvents.SERVER_STOPPING, null, NbtMoLangDataStoreFactory::_init_$lambda$2, 1, null);
        Observable.subscribe$default(PlatformEvents.SERVER_TICK_POST, null, NbtMoLangDataStoreFactory::_init_$lambda$3, 1, null);
    }
}

