/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.storage.adapter.flatfile;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.api.storage.adapter.CobblemonAdapterParent;
import com.cobblemon.mod.common.api.storage.adapter.flatfile.FileStoreAdapter;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.class_5455;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0003B'\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00028\u0000H&\u00a2\u0006\u0004\b\u0010\u0010\u0011JO\u0010\u001b\u001a\u0004\u0018\u00018\u0002\"\u0004\b\u0001\u0010\u0012\"\u000e\b\u0002\u0010\u0014*\b\u0012\u0004\u0012\u00028\u00010\u00132\u0006\u0010\r\u001a\u00020\f2\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H&\u00a2\u0006\u0004\b\u001b\u0010\u001cJ)\u0010\u001d\u001a\u00020\f2\u0012\u0010\u0016\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00130\u00152\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001d\u0010\u001eJ3\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u0016\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00130\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u001fJI\u0010!\u001a\u0004\u0018\u00018\u0002\"\b\b\u0001\u0010\u0012*\u00020 \"\u000e\b\u0002\u0010\u0014*\b\u0012\u0004\u0012\u00028\u00010\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010#R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010$R\u0014\u0010\b\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010$R\u0014\u0010\t\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010#\u00a8\u0006%"}, d2={"Lcom/cobblemon/mod/common/api/storage/adapter/flatfile/OneToOneFileStoreAdapter;", "S", "Lcom/cobblemon/mod/common/api/storage/adapter/flatfile/FileStoreAdapter;", "Lcom/cobblemon/mod/common/api/storage/adapter/CobblemonAdapterParent;", "", "rootFolder", "", "useNestedFolders", "folderPerClass", "fileExtension", "<init>", "(Ljava/lang/String;ZZLjava/lang/String;)V", "Ljava/io/File;", "file", "serialized", "", "save", "(Ljava/io/File;Ljava/lang/Object;)V", "E", "Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "T", "Ljava/lang/Class;", "storeClass", "Ljava/util/UUID;", "uuid", "Lnet/minecraft/class_5455;", "registryAccess", "load", "(Ljava/io/File;Ljava/lang/Class;Ljava/util/UUID;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "getFile", "(Ljava/lang/Class;Ljava/util/UUID;)Ljava/io/File;", "(Ljava/lang/Class;Ljava/util/UUID;Ljava/lang/Object;)V", "Lcom/cobblemon/mod/common/api/storage/StorePosition;", "provide", "(Ljava/lang/Class;Ljava/util/UUID;Lnet/minecraft/class_5455;)Lcom/cobblemon/mod/common/api/storage/PokemonStore;", "Ljava/lang/String;", "Z", "common"})
public abstract class OneToOneFileStoreAdapter<S>
extends CobblemonAdapterParent<S>
implements FileStoreAdapter<S> {
    @NotNull
    private final String rootFolder;
    private final boolean useNestedFolders;
    private final boolean folderPerClass;
    @NotNull
    private final String fileExtension;

    public OneToOneFileStoreAdapter(@NotNull String rootFolder, boolean useNestedFolders, boolean folderPerClass, @NotNull String fileExtension) {
        Intrinsics.checkNotNullParameter((Object)rootFolder, (String)"rootFolder");
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        this.rootFolder = rootFolder;
        this.useNestedFolders = useNestedFolders;
        this.folderPerClass = folderPerClass;
        this.fileExtension = fileExtension;
    }

    public abstract void save(@NotNull File var1, S var2);

    @Nullable
    public abstract <E, T extends PokemonStore<E>> T load(@NotNull File var1, @NotNull Class<? extends T> var2, @NotNull UUID var3, @NotNull class_5455 var4);

    @NotNull
    public final File getFile(@NotNull Class<? extends PokemonStore<?>> storeClass, @NotNull UUID uuid) {
        Object object;
        Object subfolder1;
        Intrinsics.checkNotNullParameter(storeClass, (String)"storeClass");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        String string = storeClass.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String className = string2;
        Object object2 = subfolder1 = this.folderPerClass ? className + "/" : "";
        if (this.useNestedFolders) {
            String string3 = uuid.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            String string4 = string3;
            int n = 0;
            int n2 = 2;
            String string5 = string4.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            object = string5 + "/";
        } else {
            object = "";
        }
        String subfolder2 = object;
        Object folder = !StringsKt.endsWith$default((String)this.rootFolder, (String)"/", (boolean)false, (int)2, null) ? this.rootFolder + "/" : this.rootFolder;
        String fileName = this.folderPerClass ? uuid + "." + this.fileExtension : uuid + "-" + className + "." + this.fileExtension;
        File file = new File((String)folder + (String)subfolder1 + subfolder2, fileName);
        file.getParentFile().mkdirs();
        return file;
    }

    @Override
    public void save(@NotNull Class<? extends PokemonStore<?>> storeClass, @NotNull UUID uuid, S serialized) {
        Intrinsics.checkNotNullParameter(storeClass, (String)"storeClass");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        File file = this.getFile(storeClass, uuid);
        File tempFile = new File(file.getAbsolutePath() + ".temp");
        File oldFile = new File(file.getAbsolutePath() + ".old");
        tempFile.createNewFile();
        this.save(tempFile, serialized);
        if (file.exists()) {
            FilesKt.copyTo$default((File)file, (File)oldFile, (boolean)true, (int)0, (int)4, null);
        }
        FilesKt.copyTo$default((File)tempFile, (File)file, (boolean)true, (int)0, (int)4, null);
        tempFile.delete();
    }

    @Override
    @Nullable
    public <E extends StorePosition, T extends PokemonStore<E>> T provide(@NotNull Class<T> storeClass, @NotNull UUID uuid, @NotNull class_5455 registryAccess) {
        PokemonStore pokemonStore;
        Intrinsics.checkNotNullParameter(storeClass, (String)"storeClass");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)registryAccess, (String)"registryAccess");
        File file = this.getFile(storeClass, uuid);
        File oldFile = new File(file.getAbsolutePath() + ".old");
        if (file.exists() && file.length() > 0L) {
            T t = this.load(file, storeClass, uuid, registryAccess);
            pokemonStore = (PokemonStore)t;
            if (t == null) {
                OneToOneFileStoreAdapter it = this;
                boolean bl = false;
                file.delete();
                if (oldFile.exists() && oldFile.length() > 0L) {
                    T t2 = this.load(oldFile, storeClass, uuid, registryAccess);
                    if (t2 == null) {
                        OneToOneFileStoreAdapter it2 = this;
                        boolean bl2 = false;
                        Cobblemon.LOGGER.error("Pok\u00e9mon save file for " + storeClass.getSimpleName() + " (" + uuid + ") was corrupted. A fresh file will be created.");
                        Object object = new Class[]{UUID.class};
                        Constructor<T> constructor = storeClass.getConstructor((Class<?>[])object);
                        object = new Object[]{uuid};
                        PokemonStore result = (PokemonStore)constructor.newInstance(object);
                        object = result;
                        Intrinsics.checkNotNull((Object)object);
                        this.save(storeClass, uuid, this.serialize(object, registryAccess));
                        oldFile.delete();
                        return (T)result;
                    }
                    T result = t2;
                    Cobblemon.LOGGER.warn("Loading old Pok\u00e9mon save file for " + storeClass.getSimpleName() + " (" + uuid + ") due to corruption of current file.");
                    FilesKt.copyTo$default((File)oldFile, (File)file, (boolean)true, (int)0, (int)4, null);
                    pokemonStore = (PokemonStore)result;
                } else {
                    Object object = new Class[]{UUID.class};
                    Constructor<T> constructor = storeClass.getConstructor((Class<?>[])object);
                    object = new Object[]{uuid};
                    PokemonStore result = (PokemonStore)constructor.newInstance(object);
                    object = result;
                    Intrinsics.checkNotNull((Object)object);
                    this.save(storeClass, uuid, this.serialize(object, registryAccess));
                    oldFile.delete();
                    pokemonStore = result;
                }
            }
        } else {
            file.delete();
            if (oldFile.exists() && oldFile.length() > 0L) {
                T t = this.load(oldFile, storeClass, uuid, registryAccess);
                if (t == null) {
                    OneToOneFileStoreAdapter it = this;
                    boolean bl = false;
                    oldFile.delete();
                    return null;
                }
                T result = t;
                FilesKt.copyTo$default((File)oldFile, (File)file, (boolean)true, (int)0, (int)4, null);
            }
            pokemonStore = null;
        }
        return (T)pokemonStore;
    }
}

