/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.spawning.selection;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePosition;
import com.cobblemon.mod.common.api.spawning.position.SpawnablePositionType;
import com.cobblemon.mod.common.api.spawning.selection.SpawnSelectionData;
import com.cobblemon.mod.common.api.spawning.selection.SpawningSelector;
import com.cobblemon.mod.common.api.spawning.spawner.Spawner;
import com.cobblemon.mod.common.util.CollectionUtilsKt;
import com.cobblemon.mod.common.util.MapExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001f !B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\b\u001a\u00020\u00072\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ-\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J-\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J+\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0017H\u0004\u00a2\u0006\u0004\b\u001b\u0010\u001cJ9\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00070\u00192\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001e\u00a8\u0006\""}, d2={"Lcom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector;", "Lcom/cobblemon/mod/common/api/spawning/selection/SpawningSelector;", "Lcom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SeparatedSelectionData;", "<init>", "()V", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePositionType;", "spawnablePositionType", "", "getWeight", "(Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePositionType;)F", "Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;", "spawner", "Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;", "bucket", "", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePositions", "getSelectionData", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;Ljava/util/List;)Lcom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SeparatedSelectionData;", "selectionData", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "selectSpawnAction", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;Lcom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SeparatedSelectionData;)Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "Lcom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SpawnablePositionSelectionData;", "spawnablePositionSelectionData", "", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "getProbabilitiesFromSpawnablePositionType", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lcom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SpawnablePositionSelectionData;)Ljava/util/Map;", "getTotalWeights", "(Lcom/cobblemon/mod/common/api/spawning/spawner/Spawner;Lcom/cobblemon/mod/common/api/spawning/SpawnBucket;Ljava/util/List;)Ljava/util/Map;", "SelectingSpawnInformation", "SpawnablePositionSelectionData", "SeparatedSelectionData", "common"})
@SourceDebugExtension(value={"SMAP\nFlatSpawnablePositionWeightedSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlatSpawnablePositionWeightedSelector.kt\ncom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,259:1\n1869#2:260\n1869#2:268\n1870#2:276\n1870#2:277\n1869#2,2:279\n382#3,7:261\n382#3,7:269\n1#4:278\n*S KotlinDebug\n*F\n+ 1 FlatSpawnablePositionWeightedSelector.kt\ncom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector\n*L\n115#1:260\n121#1:268\n121#1:276\n115#1:277\n252#1:279,2\n120#1:261,7\n129#1:269,7\n*E\n"})
public class FlatSpawnablePositionWeightedSelector
implements SpawningSelector<SeparatedSelectionData> {
    public float getWeight(@NotNull SpawnablePositionType<?> spawnablePositionType) {
        Intrinsics.checkNotNullParameter(spawnablePositionType, (String)"spawnablePositionType");
        return spawnablePositionType.getWeight();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SeparatedSelectionData getSelectionData(@NotNull Spawner spawner, @NotNull SpawnBucket bucket, @NotNull List<? extends SpawnablePosition> spawnablePositions) {
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter(spawnablePositions, (String)"spawnablePositions");
        Map spawnablePositionTypeToSpawns = new LinkedHashMap();
        Iterable $this$forEach$iv = spawnablePositions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            SpawnablePositionType<?> spawnablePositionType;
            SpawnablePosition spawnablePosition = (SpawnablePosition)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(SpawnablePosition.Companion.getByClass(spawnablePosition));
            List<SpawnDetail> possible = spawner.getMatchingSpawns(bucket, spawnablePosition);
            if (!(!((Collection)possible).isEmpty())) continue;
            Map map = spawnablePositionTypeToSpawns;
            SpawnablePositionType<?> key$iv = spawnablePositionType;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                SpawnablePositionSelectionData answer$iv = new SpawnablePositionSelectionData(new LinkedHashMap(), 0.0f);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            SpawnablePositionSelectionData spawnablePositionSelectionData = (SpawnablePositionSelectionData)object;
            Iterable $this$forEach$iv2 = possible;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object2;
                void key$iv2;
                void $this$getOrPut$iv2;
                SpawnDetail it = (SpawnDetail)element$iv2;
                boolean bl3 = false;
                if (it.getPercentage() > 0.0f && !spawnablePositionSelectionData.getSpawnToSpawnablePosition().containsKey(it)) {
                    spawnablePositionSelectionData.setPercentSum(spawnablePositionSelectionData.getPercentSum() + it.getPercentage());
                }
                Map<SpawnDetail, SelectingSpawnInformation> map2 = spawnablePositionSelectionData.getSpawnToSpawnablePosition();
                SpawnDetail spawnDetail = it;
                KClass kClass = Reflection.getOrCreateKotlinClass(SelectingSpawnInformation.class);
                boolean $i$f$getOrPut2 = false;
                Object value$iv2 = $this$getOrPut$iv2.get(key$iv2);
                if (value$iv2 == null) {
                    boolean bl4 = false;
                    SelectingSpawnInformation answer$iv = (SelectingSpawnInformation)KClasses.createInstance((KClass)kClass);
                    $this$getOrPut$iv2.put(key$iv2, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv2;
                }
                SelectingSpawnInformation selectingSpawnInformation = (SelectingSpawnInformation)object2;
                selectingSpawnInformation.add(it, spawnablePosition, this.getWeight(spawnablePositionType));
            }
        }
        return new SeparatedSelectionData(spawnablePositionTypeToSpawns);
    }

    @Override
    @Nullable
    public SpawnAction<?> selectSpawnAction(@NotNull Spawner spawner, @NotNull SpawnBucket bucket, @NotNull SeparatedSelectionData selectionData) {
        SpawnablePositionSelectionData spawnablePositionSelectionData;
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)selectionData, (String)"selectionData");
        if (selectionData.getSpawnablePositionTypeToSpawns().isEmpty()) {
            return null;
        }
        Map.Entry entry = (Map.Entry)CollectionUtilsKt.weightedSelection$default(CollectionsKt.toList((Iterable)selectionData.getSpawnablePositionTypeToSpawns().entrySet()), null, arg_0 -> FlatSpawnablePositionWeightedSelector.selectSpawnAction$lambda$0(this, arg_0), 1, null);
        if (entry == null || (spawnablePositionSelectionData = (SpawnablePositionSelectionData)entry.getValue()) == null) {
            return null;
        }
        SpawnablePositionSelectionData spawnablePositionSelectionData2 = spawnablePositionSelectionData;
        Map<SpawnDetail, SelectingSpawnInformation> spawnToSpawnablePosition = spawnablePositionSelectionData2.getSpawnToSpawnablePosition();
        float percentSum = spawnablePositionSelectionData2.getPercentSum();
        if (percentSum > 0.0f) {
            if (percentSum > 100.0f) {
                Cobblemon.LOGGER.warn(StringsKt.trimIndent((String)("\n                        A spawn list for " + spawner.getName() + " exceeded 100% on percentage sums...\n                        This means you don't understand how this option works.\n                    ")));
                return null;
            }
            float selectedPercentage = (float)100 - Random.Default.nextFloat() * (float)100;
            percentSum = 0.0f;
            for (Map.Entry<SpawnDetail, SelectingSpawnInformation> entry2 : spawnToSpawnablePosition.entrySet()) {
                SpawnDetail spawnDetail = entry2.getKey();
                SelectingSpawnInformation info = entry2.getValue();
                if (!(spawnDetail.getPercentage() > 0.0f) || !((percentSum += spawnDetail.getPercentage()) >= selectedPercentage)) continue;
                return spawnDetail.choose(info.chooseSpawnablePosition(), bucket, selectionData);
            }
        }
        Map.Entry entry3 = (Map.Entry)CollectionUtilsKt.weightedSelection$default(CollectionsKt.toList((Iterable)spawnToSpawnablePosition.entrySet()), null, FlatSpawnablePositionWeightedSelector::selectSpawnAction$lambda$1, 1, null);
        if (entry3 == null) {
            return null;
        }
        Map.Entry selectedSpawn = entry3;
        return ((SpawnDetail)selectedSpawn.getKey()).choose(((SelectingSpawnInformation)selectedSpawn.getValue()).chooseSpawnablePosition(), bucket, selectionData);
    }

    @NotNull
    protected final Map<SpawnDetail, Float> getProbabilitiesFromSpawnablePositionType(@NotNull Spawner spawner, @NotNull SpawnablePositionSelectionData spawnablePositionSelectionData) {
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        Intrinsics.checkNotNullParameter((Object)spawnablePositionSelectionData, (String)"spawnablePositionSelectionData");
        float percentSum = spawnablePositionSelectionData.getPercentSum();
        float weightPortion = (float)100 - percentSum;
        float totalWeightMultiplier = (float)100 / weightPortion;
        Map<SpawnDetail, SelectingSpawnInformation> spawnToSpawnablePosition = spawnablePositionSelectionData.getSpawnToSpawnablePosition();
        if (percentSum > 100.0f) {
            Cobblemon.LOGGER.warn(StringsKt.trimIndent((String)("\n                    A spawn list for " + spawner.getName() + " exceeded 100% on percentage sums...\n                    This means you don't understand how this option works.\n                ")));
            return MapsKt.emptyMap();
        }
        Map totalWeights = new LinkedHashMap();
        float totalWeight = 0.0f;
        for (SelectingSpawnInformation spawn : spawnToSpawnablePosition.values()) {
            totalWeight += spawn.getHighestWeight();
        }
        float rescaledTotalWeight = totalWeight * totalWeightMultiplier;
        float percentageWeight = (rescaledTotalWeight - totalWeight) / percentSum;
        for (Map.Entry<SpawnDetail, SelectingSpawnInformation> entry : spawnToSpawnablePosition.entrySet()) {
            SpawnDetail spawnDetail = entry.getKey();
            SelectingSpawnInformation info = entry.getValue();
            totalWeights.put(spawnDetail, Float.valueOf(info.getHighestWeight() + (spawnDetail.getPercentage() > 0.0f ? spawnDetail.getPercentage() * percentageWeight : 0.0f)));
        }
        return totalWeights;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<SpawnDetail, Float> getTotalWeights(@NotNull Spawner spawner, @NotNull SpawnBucket bucket, @NotNull List<? extends SpawnablePosition> spawnablePositions) {
        Intrinsics.checkNotNullParameter((Object)spawner, (String)"spawner");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter(spawnablePositions, (String)"spawnablePositions");
        SpawnSelectionData selectionData = this.getSelectionData(spawner, bucket, (List)spawnablePositions);
        if (((SeparatedSelectionData)selectionData).getSpawnablePositionTypeToSpawns().isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map totalWeights = new LinkedHashMap();
        Iterable iterable = ((SeparatedSelectionData)selectionData).getSpawnablePositionTypeToSpawns().keySet();
        double d = 0.0;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            void it;
            Object t = iterator.next();
            SpawnablePositionType spawnablePositionType = (SpawnablePositionType)t;
            double d2 = d;
            boolean bl = false;
            double d3 = this.getWeight((SpawnablePositionType<?>)it);
            d = d2 + d3;
        }
        float totalSpawnablePositionWeight = (float)d;
        for (Map.Entry entry : ((SeparatedSelectionData)selectionData).getSpawnablePositionTypeToSpawns().entrySet()) {
            SpawnablePositionType spawnablePositionType = (SpawnablePositionType)entry.getKey();
            SpawnablePositionSelectionData spawnPositionSelectionData = (SpawnablePositionSelectionData)entry.getValue();
            float spawnPositionWeightCorrection = this.getWeight(spawnablePositionType) / totalSpawnablePositionWeight;
            Map<SpawnDetail, Float> spawnPositionProbabilities = this.getProbabilitiesFromSpawnablePositionType(spawner, spawnPositionSelectionData);
            Iterable $this$forEach$iv = spawnPositionProbabilities.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                totalWeights.put(it.getKey(), Float.valueOf(((Number)it.getValue()).floatValue() * spawnPositionWeightCorrection));
            }
        }
        return totalWeights;
    }

    private static final Number selectSpawnAction$lambda$0(FlatSpawnablePositionWeightedSelector this$0, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Float.valueOf(this$0.getWeight((SpawnablePositionType)it.getKey()) * (float)((SpawnablePositionSelectionData)it.getValue()).getSize());
    }

    private static final Number selectSpawnAction$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Float.valueOf(((SelectingSpawnInformation)it.getValue()).getHighestWeight());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\u000eR#\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lcom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SelectingSpawnInformation;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "spawnDetail", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "spawnablePosition", "", "spawnablePositionTypeWeight", "", "add", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;F)V", "chooseSpawnablePosition", "()Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "", "spawnablePositionWeights", "Ljava/util/Map;", "getSpawnablePositionWeights", "()Ljava/util/Map;", "highestWeight", "F", "getHighestWeight", "()F", "setHighestWeight", "(F)V", "common"})
    public static final class SelectingSpawnInformation {
        @NotNull
        private final Map<SpawnablePosition, Float> spawnablePositionWeights = new LinkedHashMap();
        private float highestWeight;

        @NotNull
        public final Map<SpawnablePosition, Float> getSpawnablePositionWeights() {
            return this.spawnablePositionWeights;
        }

        public final float getHighestWeight() {
            return this.highestWeight;
        }

        public final void setHighestWeight(float f) {
            this.highestWeight = f;
        }

        public final void add(@NotNull SpawnDetail spawnDetail, @NotNull SpawnablePosition spawnablePosition, float spawnablePositionTypeWeight) {
            Intrinsics.checkNotNullParameter((Object)spawnDetail, (String)"spawnDetail");
            Intrinsics.checkNotNullParameter((Object)spawnablePosition, (String)"spawnablePosition");
            float weight = spawnablePosition.getWeight(spawnDetail) * spawnablePositionTypeWeight;
            this.spawnablePositionWeights.put(spawnablePosition, Float.valueOf(weight));
            if (weight > this.highestWeight) {
                this.highestWeight = weight;
            }
        }

        @NotNull
        public final SpawnablePosition chooseSpawnablePosition() {
            Object object = CollectionUtilsKt.weightedSelection$default(CollectionsKt.toList((Iterable)this.spawnablePositionWeights.keySet()), null, arg_0 -> SelectingSpawnInformation.chooseSpawnablePosition$lambda$0(this, arg_0), 1, null);
            Intrinsics.checkNotNull((Object)object);
            return (SpawnablePosition)object;
        }

        private static final Number chooseSpawnablePosition$lambda$0(SelectingSpawnInformation this$0, SpawnablePosition it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Float f = this$0.spawnablePositionWeights.get(it);
            Intrinsics.checkNotNull((Object)f);
            return f;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0016\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J#\u0010\r\u001a\u00020\f2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ)\u0010\u0011\u001a\u00020\f2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n0\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R'\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00168\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR&\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0013\u001a\u0004\b\u001f\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SeparatedSelectionData;", "Lcom/cobblemon/mod/common/api/spawning/selection/SpawnSelectionData;", "", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePositionType;", "Lcom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SpawnablePositionSelectionData;", "spawnablePositionTypeToSpawns", "<init>", "(Ljava/util/Map;)V", "Lkotlin/Function1;", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "", "shouldRemove", "", "removeSpawnDetails", "(Lkotlin/jvm/functions/Function1;)V", "Lkotlin/Function2;", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "removeSpawnablePositions", "(Lkotlin/jvm/functions/Function2;)V", "Ljava/util/Map;", "getSpawnablePositionTypeToSpawns", "()Ljava/util/Map;", "", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "spawnActions", "Ljava/util/List;", "getSpawnActions", "()Ljava/util/List;", "", "", "context", "getContext", "common"})
    @SourceDebugExtension(value={"SMAP\nFlatSpawnablePositionWeightedSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlatSpawnablePositionWeightedSelector.kt\ncom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SeparatedSelectionData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,259:1\n1869#2,2:260\n1869#2,2:262\n*S KotlinDebug\n*F\n+ 1 FlatSpawnablePositionWeightedSelector.kt\ncom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SeparatedSelectionData\n*L\n98#1:260,2\n103#1:262,2\n*E\n"})
    public static final class SeparatedSelectionData
    implements SpawnSelectionData {
        @NotNull
        private final Map<SpawnablePositionType<?>, SpawnablePositionSelectionData> spawnablePositionTypeToSpawns;
        @NotNull
        private final List<SpawnAction<?>> spawnActions;
        @NotNull
        private final Map<String, Object> context;

        public SeparatedSelectionData(@NotNull Map<SpawnablePositionType<?>, SpawnablePositionSelectionData> spawnablePositionTypeToSpawns) {
            Intrinsics.checkNotNullParameter(spawnablePositionTypeToSpawns, (String)"spawnablePositionTypeToSpawns");
            this.spawnablePositionTypeToSpawns = spawnablePositionTypeToSpawns;
            this.spawnActions = new ArrayList();
            this.context = new LinkedHashMap();
        }

        @NotNull
        public final Map<SpawnablePositionType<?>, SpawnablePositionSelectionData> getSpawnablePositionTypeToSpawns() {
            return this.spawnablePositionTypeToSpawns;
        }

        @Override
        @NotNull
        public List<SpawnAction<?>> getSpawnActions() {
            return this.spawnActions;
        }

        @Override
        @NotNull
        public Map<String, Object> getContext() {
            return this.context;
        }

        @Override
        public void removeSpawnDetails(@NotNull Function1<? super SpawnDetail, Boolean> shouldRemove) {
            Intrinsics.checkNotNullParameter(shouldRemove, (String)"shouldRemove");
            Iterable $this$forEach$iv = this.spawnablePositionTypeToSpawns.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SpawnablePositionSelectionData it = (SpawnablePositionSelectionData)element$iv;
                boolean bl = false;
                it.removeSpawnDetails(shouldRemove);
            }
            MapExtensionsKt.removeIf(this.spawnablePositionTypeToSpawns, SeparatedSelectionData::removeSpawnDetails$lambda$1);
        }

        @Override
        public void removeSpawnablePositions(@NotNull Function2<? super SpawnDetail, ? super SpawnablePosition, Boolean> shouldRemove) {
            Intrinsics.checkNotNullParameter(shouldRemove, (String)"shouldRemove");
            Iterable $this$forEach$iv = this.spawnablePositionTypeToSpawns.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SpawnablePositionSelectionData it = (SpawnablePositionSelectionData)element$iv;
                boolean bl = false;
                it.removeSpawnablePositions(shouldRemove);
            }
            MapExtensionsKt.removeIf(this.spawnablePositionTypeToSpawns, SeparatedSelectionData::removeSpawnablePositions$lambda$1);
        }

        private static final boolean removeSpawnDetails$lambda$1(Map.Entry it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ((SpawnablePositionSelectionData)it.getValue()).getSize() == 0;
        }

        private static final boolean removeSpawnablePositions$lambda$1(Map.Entry it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ((SpawnablePositionSelectionData)it.getValue()).getSize() == 0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\u000e\u001a\u00020\r2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0012\u001a\u00020\r2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000b0\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013R#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001f\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SpawnablePositionSelectionData;", "", "", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnDetail;", "Lcom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SelectingSpawnInformation;", "spawnToSpawnablePosition", "", "percentSum", "<init>", "(Ljava/util/Map;F)V", "Lkotlin/Function1;", "", "shouldRemove", "", "removeSpawnDetails", "(Lkotlin/jvm/functions/Function1;)V", "Lkotlin/Function2;", "Lcom/cobblemon/mod/common/api/spawning/position/SpawnablePosition;", "removeSpawnablePositions", "(Lkotlin/jvm/functions/Function2;)V", "Ljava/util/Map;", "getSpawnToSpawnablePosition", "()Ljava/util/Map;", "F", "getPercentSum", "()F", "setPercentSum", "(F)V", "", "getSize", "()I", "size", "common"})
    @SourceDebugExtension(value={"SMAP\nFlatSpawnablePositionWeightedSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlatSpawnablePositionWeightedSelector.kt\ncom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SpawnablePositionSelectionData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,259:1\n774#2:260\n865#2,2:261\n1869#2,2:263\n774#2:266\n865#2,2:267\n1869#2,2:269\n1#3:265\n*S KotlinDebug\n*F\n+ 1 FlatSpawnablePositionWeightedSelector.kt\ncom/cobblemon/mod/common/api/spawning/selection/FlatSpawnablePositionWeightedSelector$SpawnablePositionSelectionData\n*L\n73#1:260\n73#1:261,2\n74#1:263,2\n79#1:266\n79#1:267,2\n85#1:269,2\n*E\n"})
    public static final class SpawnablePositionSelectionData {
        @NotNull
        private final Map<SpawnDetail, SelectingSpawnInformation> spawnToSpawnablePosition;
        private float percentSum;

        public SpawnablePositionSelectionData(@NotNull Map<SpawnDetail, SelectingSpawnInformation> spawnToSpawnablePosition, float percentSum) {
            Intrinsics.checkNotNullParameter(spawnToSpawnablePosition, (String)"spawnToSpawnablePosition");
            this.spawnToSpawnablePosition = spawnToSpawnablePosition;
            this.percentSum = percentSum;
        }

        @NotNull
        public final Map<SpawnDetail, SelectingSpawnInformation> getSpawnToSpawnablePosition() {
            return this.spawnToSpawnablePosition;
        }

        public final float getPercentSum() {
            return this.percentSum;
        }

        public final void setPercentSum(float f) {
            this.percentSum = f;
        }

        public final int getSize() {
            return this.spawnToSpawnablePosition.size();
        }

        /*
         * WARNING - void declaration
         */
        public final void removeSpawnDetails(@NotNull Function1<? super SpawnDetail, Boolean> shouldRemove) {
            double d;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(shouldRemove, (String)"shouldRemove");
            Iterable $this$filter$iv = this.spawnToSpawnablePosition.entrySet();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!((Boolean)shouldRemove.invoke(it.getKey())).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List toRemove = (List)destination$iv$iv;
            Iterable $this$forEach$iv = toRemove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                this.spawnToSpawnablePosition.remove(it.getKey());
            }
            Iterable iterable2 = toRemove;
            float f = this.percentSum;
            SpawnablePositionSelectionData spawnablePositionSelectionData = this;
            double d2 = 0.0;
            for (Object t : iterable2) {
                void it;
                Map.Entry bl = (Map.Entry)t;
                d = d2;
                boolean bl2 = false;
                Double d3 = ((SpawnDetail)it.getKey()).getPercentage();
                double it2 = ((Number)d3).doubleValue();
                boolean bl3 = false;
                Double d4 = it2 > 0.0 ? d3 : null;
                double d5 = d4 != null ? d4 : 0.0;
                d2 = d + d5;
            }
            d = d2;
            spawnablePositionSelectionData.percentSum = f - (float)d;
        }

        /*
         * WARNING - void declaration
         */
        public final void removeSpawnablePositions(@NotNull Function2<? super SpawnDetail, ? super SpawnablePosition, Boolean> shouldRemove) {
            double d;
            Object object;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(shouldRemove, (String)"shouldRemove");
            Iterable $this$filter$iv = this.spawnToSpawnablePosition.entrySet();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Float f;
                object = (Map.Entry)element$iv$iv;
                boolean bl = false;
                SpawnDetail spawnDetail = (SpawnDetail)object.getKey();
                SelectingSpawnInformation positionData = (SelectingSpawnInformation)object.getValue();
                MapExtensionsKt.removeIf(positionData.getSpawnablePositionWeights(), arg_0 -> SpawnablePositionSelectionData.removeSpawnablePositions$lambda$0$0(shouldRemove, spawnDetail, arg_0));
                Map<SpawnablePosition, Float> map = positionData.getSpawnablePositionWeights();
                SelectingSpawnInformation selectingSpawnInformation = positionData;
                Iterator iterator = ((Iterable)map.entrySet()).iterator();
                if (!iterator.hasNext()) {
                    f = null;
                } else {
                    Map.Entry it = (Map.Entry)iterator.next();
                    boolean bl2 = false;
                    float f2 = ((Number)it.getValue()).floatValue();
                    while (iterator.hasNext()) {
                        Map.Entry it2 = (Map.Entry)iterator.next();
                        $i$a$-maxOfOrNull-FlatSpawnablePositionWeightedSelector$SpawnablePositionSelectionData$removeSpawnablePositions$toRemove$1$2 = false;
                        float f3 = ((Number)it2.getValue()).floatValue();
                        f2 = Math.max(f2, f3);
                    }
                    f = Float.valueOf(f2);
                }
                selectingSpawnInformation.setHighestWeight(f != null ? f.floatValue() : 0.0f);
                if (!positionData.getSpawnablePositionWeights().isEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List toRemove = (List)destination$iv$iv;
            Iterable $this$forEach$iv = toRemove;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                this.spawnToSpawnablePosition.remove(it.getKey());
            }
            Iterable iterable2 = toRemove;
            float f = this.percentSum;
            SpawnablePositionSelectionData spawnablePositionSelectionData = this;
            double d2 = 0.0;
            for (Object t : iterable2) {
                void it;
                Map.Entry bl = (Map.Entry)t;
                d = d2;
                boolean bl3 = false;
                object = (double)((SpawnDetail)it.getKey()).getPercentage();
                double it3 = ((Number)object).doubleValue();
                boolean bl4 = false;
                Object object2 = it3 > 0.0 ? object : null;
                double d3 = object2 != null ? (Double)object2 : 0.0;
                d2 = d + d3;
            }
            d = d2;
            spawnablePositionSelectionData.percentSum = f - (float)d;
        }

        private static final boolean removeSpawnablePositions$lambda$0$0(Function2 $shouldRemove, SpawnDetail $spawnDetail, Map.Entry it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (Boolean)$shouldRemove.invoke((Object)$spawnDetail, it.getKey());
        }
    }
}

