/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.snowstorm;

import com.cobblemon.mod.common.client.render.MatrixWrapper;
import com.cobblemon.mod.common.util.codec.ExpressionCodecKt;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nR\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0005\u00a8\u0006\u0011"}, d2={"Lcom/cobblemon/mod/common/api/snowstorm/EmitterSpace;", "", "Lcom/cobblemon/mod/common/api/snowstorm/EmitterSpace$ScalingMode;", "scaling", "<init>", "(Lcom/cobblemon/mod/common/api/snowstorm/EmitterSpace$ScalingMode;)V", "Lcom/cobblemon/mod/common/client/render/MatrixWrapper;", "rootMatrix", "locatorMatrix", "initializeEmitterMatrix", "(Lcom/cobblemon/mod/common/client/render/MatrixWrapper;Lcom/cobblemon/mod/common/client/render/MatrixWrapper;)Lcom/cobblemon/mod/common/client/render/MatrixWrapper;", "Lcom/cobblemon/mod/common/api/snowstorm/EmitterSpace$ScalingMode;", "getScaling", "()Lcom/cobblemon/mod/common/api/snowstorm/EmitterSpace$ScalingMode;", "setScaling", "Companion", "ScalingMode", "common"})
public final class EmitterSpace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ScalingMode scaling;
    @NotNull
    private static final Codec<EmitterSpace> CODEC;

    public EmitterSpace(@NotNull ScalingMode scaling) {
        Intrinsics.checkNotNullParameter((Object)((Object)scaling), (String)"scaling");
        this.scaling = scaling;
    }

    public /* synthetic */ EmitterSpace(ScalingMode scalingMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            scalingMode = ScalingMode.WORLD;
        }
        this(scalingMode);
    }

    @NotNull
    public final ScalingMode getScaling() {
        return this.scaling;
    }

    public final void setScaling(@NotNull ScalingMode scalingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)scalingMode), (String)"<set-?>");
        this.scaling = scalingMode;
    }

    @NotNull
    public final MatrixWrapper initializeEmitterMatrix(@NotNull MatrixWrapper rootMatrix, @NotNull MatrixWrapper locatorMatrix) {
        Intrinsics.checkNotNullParameter((Object)rootMatrix, (String)"rootMatrix");
        Intrinsics.checkNotNullParameter((Object)locatorMatrix, (String)"locatorMatrix");
        AxisAngle4f rootRotation = rootMatrix.getMatrix().getRotation(new AxisAngle4f());
        if (Float.isNaN(rootRotation.x) || Float.isNaN(rootRotation.y) || Float.isNaN(rootRotation.z) || Float.isNaN(rootRotation.angle)) {
            rootRotation = new AxisAngle4f();
        }
        Vector3f scale = new Vector3f(1.0f, 1.0f, 1.0f);
        if (this.scaling == ScalingMode.ENTITY) {
            locatorMatrix.getMatrix().getScale(scale);
            RangesKt.coerceAtLeast((float)scale.x, (float)0.01f);
            RangesKt.coerceAtLeast((float)scale.y, (float)0.01f);
            RangesKt.coerceAtLeast((float)scale.z, (float)0.01f);
        }
        Matrix4f particleRawMatrix = new Matrix4f().scale((Vector3fc)scale).rotate(rootRotation);
        MatrixWrapper matrixWrapper = new MatrixWrapper();
        Intrinsics.checkNotNull((Object)particleRawMatrix);
        return matrixWrapper.updateMatrix(particleRawMatrix).updatePosition(locatorMatrix.getOrigin());
    }

    private static final App CODEC$lambda$0(RecordCodecBuilder.Instance instance) {
        PrimitiveCodec primitiveCodec = Codec.STRING;
        Intrinsics.checkNotNullExpressionValue((Object)primitiveCodec, (String)"STRING");
        return instance.group((App)ExpressionCodecKt.optionalFieldOfWithDefault$default((Codec)primitiveCodec, "scaling", "world", false, 4, null).forGetter(EmitterSpace::CODEC$lambda$0$0)).apply((Applicative)instance, EmitterSpace::CODEC$lambda$0$1);
    }

    private static final String CODEC$lambda$0$0(EmitterSpace it) {
        return it.scaling.toString();
    }

    private static final EmitterSpace CODEC$lambda$0$1(String scaling) {
        Intrinsics.checkNotNull((Object)scaling);
        String string = scaling.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return new EmitterSpace(ScalingMode.valueOf(string));
    }

    public EmitterSpace() {
        this(null, 1, null);
    }

    static {
        Codec codec = RecordCodecBuilder.create(EmitterSpace::CODEC$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/cobblemon/mod/common/api/snowstorm/EmitterSpace$Companion;", "", "<init>", "()V", "Lcom/mojang/serialization/Codec;", "Lcom/cobblemon/mod/common/api/snowstorm/EmitterSpace;", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<EmitterSpace> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/cobblemon/mod/common/api/snowstorm/EmitterSpace$ScalingMode;", "", "<init>", "(Ljava/lang/String;I)V", "WORLD", "ENTITY", "common"})
    public static final class ScalingMode
    extends Enum<ScalingMode> {
        public static final /* enum */ ScalingMode WORLD = new ScalingMode();
        public static final /* enum */ ScalingMode ENTITY = new ScalingMode();
        private static final /* synthetic */ ScalingMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ScalingMode[] values() {
            return (ScalingMode[])$VALUES.clone();
        }

        public static ScalingMode valueOf(String value) {
            return Enum.valueOf(ScalingMode.class, value);
        }

        @NotNull
        public static EnumEntries<ScalingMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = scalingModeArray = new ScalingMode[]{ScalingMode.WORLD, ScalingMode.ENTITY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

