/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.api.riding.util;

import com.cobblemon.mod.common.OrientationControllable;
import com.cobblemon.mod.common.api.orientation.OrientationController;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviour;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourSettings;
import com.cobblemon.mod.common.api.riding.behaviour.RidingBehaviourState;
import com.cobblemon.mod.common.api.riding.util.Vec3Spring;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.util.math.geometry.AngleExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\n\u001a\u0004\b\u000b\u0010\fR\"\u0010\u000e\u001a\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\"\u0010\"\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010\u001d\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\"\u0010%\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b%\u0010\u001d\u001a\u0004\b&\u0010\u001f\"\u0004\b'\u0010!R\"\u0010(\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b(\u0010\u001d\u001a\u0004\b)\u0010\u001f\"\u0004\b*\u0010!R\"\u0010+\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010\u001d\u001a\u0004\b,\u0010\u001f\"\u0004\b-\u0010!R\"\u0010.\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010\u001d\u001a\u0004\b/\u0010\u001f\"\u0004\b0\u0010!\u00a8\u00061"}, d2={"Lcom/cobblemon/mod/common/api/riding/util/RidingAnimationData;", "", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "ride", "<init>", "(Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;)V", "", "clear", "()V", "update", "Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "getRide", "()Lcom/cobblemon/mod/common/entity/pokemon/PokemonEntity;", "Lorg/joml/Matrix3f;", "prevOrientation", "Lorg/joml/Matrix3f;", "getPrevOrientation", "()Lorg/joml/Matrix3f;", "setPrevOrientation", "(Lorg/joml/Matrix3f;)V", "Lnet/minecraft/class_243;", "prevRot", "Lnet/minecraft/class_243;", "getPrevRot", "()Lnet/minecraft/class_243;", "setPrevRot", "(Lnet/minecraft/class_243;)V", "Lcom/cobblemon/mod/common/api/riding/util/Vec3Spring;", "velocitySpring", "Lcom/cobblemon/mod/common/api/riding/util/Vec3Spring;", "getVelocitySpring", "()Lcom/cobblemon/mod/common/api/riding/util/Vec3Spring;", "setVelocitySpring", "(Lcom/cobblemon/mod/common/api/riding/util/Vec3Spring;)V", "rotSpring", "getRotSpring", "setRotSpring", "rotDeltaSpring", "getRotDeltaSpring", "setRotDeltaSpring", "localVelocitySpring", "getLocalVelocitySpring", "setLocalVelocitySpring", "driverInputSpring", "getDriverInputSpring", "setDriverInputSpring", "diveSpring", "getDiveSpring", "setDiveSpring", "common"})
public final class RidingAnimationData {
    @NotNull
    private final PokemonEntity ride;
    @NotNull
    private Matrix3f prevOrientation;
    @NotNull
    private class_243 prevRot;
    @NotNull
    private Vec3Spring velocitySpring;
    @NotNull
    private Vec3Spring rotSpring;
    @NotNull
    private Vec3Spring rotDeltaSpring;
    @NotNull
    private Vec3Spring localVelocitySpring;
    @NotNull
    private Vec3Spring driverInputSpring;
    @NotNull
    private Vec3Spring diveSpring;

    public RidingAnimationData(@NotNull PokemonEntity ride) {
        Intrinsics.checkNotNullParameter((Object)ride, (String)"ride");
        this.ride = ride;
        this.prevOrientation = new Matrix3f();
        class_243 class_2432 = class_243.field_1353;
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"ZERO");
        this.prevRot = class_2432;
        this.velocitySpring = new Vec3Spring(null, null, 3, null);
        this.rotSpring = new Vec3Spring(null, null, 3, null);
        this.rotDeltaSpring = new Vec3Spring(null, null, 3, null);
        this.localVelocitySpring = new Vec3Spring(null, null, 3, null);
        this.driverInputSpring = new Vec3Spring(null, null, 3, null);
        this.diveSpring = new Vec3Spring(null, null, 3, null);
    }

    @NotNull
    public final PokemonEntity getRide() {
        return this.ride;
    }

    @NotNull
    public final Matrix3f getPrevOrientation() {
        return this.prevOrientation;
    }

    public final void setPrevOrientation(@NotNull Matrix3f matrix3f) {
        Intrinsics.checkNotNullParameter((Object)matrix3f, (String)"<set-?>");
        this.prevOrientation = matrix3f;
    }

    @NotNull
    public final class_243 getPrevRot() {
        return this.prevRot;
    }

    public final void setPrevRot(@NotNull class_243 class_2432) {
        Intrinsics.checkNotNullParameter((Object)class_2432, (String)"<set-?>");
        this.prevRot = class_2432;
    }

    @NotNull
    public final Vec3Spring getVelocitySpring() {
        return this.velocitySpring;
    }

    public final void setVelocitySpring(@NotNull Vec3Spring vec3Spring) {
        Intrinsics.checkNotNullParameter((Object)vec3Spring, (String)"<set-?>");
        this.velocitySpring = vec3Spring;
    }

    @NotNull
    public final Vec3Spring getRotSpring() {
        return this.rotSpring;
    }

    public final void setRotSpring(@NotNull Vec3Spring vec3Spring) {
        Intrinsics.checkNotNullParameter((Object)vec3Spring, (String)"<set-?>");
        this.rotSpring = vec3Spring;
    }

    @NotNull
    public final Vec3Spring getRotDeltaSpring() {
        return this.rotDeltaSpring;
    }

    public final void setRotDeltaSpring(@NotNull Vec3Spring vec3Spring) {
        Intrinsics.checkNotNullParameter((Object)vec3Spring, (String)"<set-?>");
        this.rotDeltaSpring = vec3Spring;
    }

    @NotNull
    public final Vec3Spring getLocalVelocitySpring() {
        return this.localVelocitySpring;
    }

    public final void setLocalVelocitySpring(@NotNull Vec3Spring vec3Spring) {
        Intrinsics.checkNotNullParameter((Object)vec3Spring, (String)"<set-?>");
        this.localVelocitySpring = vec3Spring;
    }

    @NotNull
    public final Vec3Spring getDriverInputSpring() {
        return this.driverInputSpring;
    }

    public final void setDriverInputSpring(@NotNull Vec3Spring vec3Spring) {
        Intrinsics.checkNotNullParameter((Object)vec3Spring, (String)"<set-?>");
        this.driverInputSpring = vec3Spring;
    }

    @NotNull
    public final Vec3Spring getDiveSpring() {
        return this.diveSpring;
    }

    public final void setDiveSpring(@NotNull Vec3Spring vec3Spring) {
        Intrinsics.checkNotNullParameter((Object)vec3Spring, (String)"<set-?>");
        this.diveSpring = vec3Spring;
    }

    public final void clear() {
        this.prevOrientation = new Matrix3f();
        class_243 class_2432 = class_243.field_1353;
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"ZERO");
        this.prevRot = class_2432;
        this.velocitySpring = new Vec3Spring(null, null, 3, null);
        this.rotSpring = new Vec3Spring(null, null, 3, null);
        this.rotDeltaSpring = new Vec3Spring(null, null, 3, null);
        this.localVelocitySpring = new Vec3Spring(null, null, 3, null);
        this.driverInputSpring = new Vec3Spring(null, null, 3, null);
        this.diveSpring = new Vec3Spring(null, null, 3, null);
    }

    public final void update() {
        boolean activeRide = this.ride.method_42148();
        if (!activeRide) {
            return;
        }
        class_243 currRot = class_243.field_1353;
        class_243 angDelta = class_243.field_1353;
        double stiffness = 90.0;
        double damping = 18.0;
        class_243 currentVelocity = new class_243(this.ride.method_23317() - this.ride.field_6038, this.ride.method_23318() - this.ride.field_5971, this.ride.method_23321() - this.ride.field_5989);
        boolean r = this.ride.ifRidingAvailableSupply(false, (arg_0, arg_1, arg_2) -> RidingAnimationData.update$lambda$0(this, arg_0, arg_1, arg_2));
        if (r) {
            PokemonEntity pokemonEntity = this.ride;
            Object object = pokemonEntity instanceof OrientationControllable ? (OrientationControllable)((Object)pokemonEntity) : null;
            if (object == null || (object = object.getOrientationController()) == null) {
                return;
            }
            Object controller = object;
            Matrix3f matrix3f = ((OrientationController)controller).getOrientation();
            if (matrix3f == null) {
                matrix3f = new Matrix3f();
            }
            Matrix3f orientation = matrix3f;
            float currPitch = ((OrientationController)controller).getPitch();
            float currYaw = ((OrientationController)controller).getYaw();
            float currRoll = ((OrientationController)controller).getRoll();
            currRot = new class_243((double)currPitch, (double)currYaw, (double)currRoll);
            Matrix3f currOrientation = orientation;
            Quaternionf currQuat = new Quaternionf().setFromUnnormalized((Matrix3fc)currOrientation);
            Quaternionf prevQuat = new Quaternionf().setFromUnnormalized((Matrix3fc)this.prevOrientation);
            Quaternionf deltaQuat = new Quaternionf((Quaternionfc)currQuat).mul((Quaternionfc)new Quaternionf((Quaternionfc)prevQuat).invert());
            Quaternionf localDeltaQuat = new Quaternionf((Quaternionfc)currQuat).invert().mul((Quaternionfc)deltaQuat).mul((Quaternionfc)currQuat);
            Vector3f euler = new Vector3f();
            localDeltaQuat.getEulerAnglesXYZ(euler);
            double pitchDegrees = Math.toDegrees(euler.x);
            double yawDegrees = Math.toDegrees(euler.y);
            double rollDegrees = Math.toDegrees(euler.z);
            angDelta = new class_243(pitchDegrees, yawDegrees, rollDegrees).method_1021(20.0);
            Vector3f velocityWorldF = new Vector3f((float)currentVelocity.field_1352, (float)currentVelocity.field_1351, (float)currentVelocity.field_1350);
            Vector3f localVelocityF = new Matrix3f((Matrix3fc)orientation).transpose().transform(velocityWorldF);
            class_243 localVelocity = new class_243((double)localVelocityF.x, (double)localVelocityF.y, (double)localVelocityF.z);
            this.localVelocitySpring.update(localVelocity, stiffness, damping);
            this.prevOrientation.set((Matrix3fc)currOrientation);
        } else {
            float currPitch = this.ride.method_36455();
            float currYaw = this.ride.method_36454();
            float currRoll = 0.0f;
            currRot = new class_243((double)currPitch, (double)currYaw, (double)currRoll);
            angDelta = new class_243(currRot.field_1352 - this.prevRot.field_1352, (double)class_3532.method_15381((float)((float)currRot.field_1351), (float)((float)this.prevRot.field_1351)), (double)class_3532.method_15381((float)((float)currRot.field_1350), (float)((float)this.prevRot.field_1350))).method_1021(20.0);
            double yaw360 = -1.0 * (double)(this.ride.method_36454() + 360.0f) % (double)360.0f;
            Matrix3f orientationNonRollable = new Matrix3f().rotateY(AngleExtensionsKt.toRadians(yaw360));
            Vector3f velocityWorldF = new Vector3f((float)currentVelocity.field_1352, (float)currentVelocity.field_1351, (float)currentVelocity.field_1350);
            Vector3f localVelocityF = new Matrix3f((Matrix3fc)orientationNonRollable).transpose().transform(velocityWorldF);
            class_243 localVelocity = new class_243((double)localVelocityF.x, (double)localVelocityF.y, (double)localVelocityF.z);
            this.localVelocitySpring.update(localVelocity, stiffness, damping);
        }
        class_1309 driver = this.ride.method_5642();
        double vertInput = driver != null && driver.field_6282 ? 1.0 : (driver != null && driver.method_5715() ? -1.0 : 0.0);
        class_243 input = driver != null ? new class_243((double)driver.field_6212 * (double)-1, vertInput, (double)driver.field_6250) : class_243.field_1353;
        Intrinsics.checkNotNull((Object)input);
        this.driverInputSpring.update(input, stiffness * (double)2, damping);
        class_243 currRoll = angDelta;
        Intrinsics.checkNotNull((Object)currRoll);
        this.rotDeltaSpring.update(currRoll, stiffness, damping);
        this.velocitySpring.update(currentVelocity, stiffness, damping);
        this.rotSpring.update(currRot, stiffness, damping);
        float diving = Math.abs(Math.max((float)Math.sin(AngleExtensionsKt.toRadians(currRot.field_1352)), 0.0f));
        this.diveSpring.update(new class_243(0.0, (double)diving, 0.0), stiffness, damping);
        this.prevRot = currRot;
    }

    private static final boolean update$lambda$0(RidingAnimationData this$0, RidingBehaviour behaviour, RidingBehaviourSettings settings, RidingBehaviourState state) {
        Intrinsics.checkNotNullParameter((Object)behaviour, (String)"behaviour");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return behaviour.shouldRoll(settings, state, this$0.ride);
    }
}

