/*
 * Decompiled with CFR 0.152.
 */
package com.bedrockk.molang.runtime;

import com.bedrockk.molang.Expression;
import com.bedrockk.molang.runtime.MoLangEnvironment;
import com.bedrockk.molang.runtime.MoLangMath;
import com.bedrockk.molang.runtime.MoParams;
import com.bedrockk.molang.runtime.MoScope;
import com.bedrockk.molang.runtime.struct.ArrayStruct;
import com.bedrockk.molang.runtime.struct.ContextStruct;
import com.bedrockk.molang.runtime.struct.QueryStruct;
import com.bedrockk.molang.runtime.struct.VariableStruct;
import com.bedrockk.molang.runtime.value.DoubleValue;
import com.bedrockk.molang.runtime.value.MoValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class MoLangRuntime {
    private final MoLangEnvironment environment = new MoLangEnvironment();
    private final Map<String, MoValue> noContext = new HashMap<String, MoValue>();

    public MoLangRuntime() {
        this.environment.setStruct("math", MoLangMath.LIBRARY);
        this.environment.setStruct("temp", new VariableStruct());
        this.environment.setStruct("variable", new VariableStruct());
        this.environment.setStruct("array", new ArrayStruct());
        this.environment.setStruct("query", new QueryStruct(new HashMap<String, Function<MoParams, Object>>()));
    }

    public MoValue execute(Expression expression) {
        return this.execute(expression, this.noContext);
    }

    public MoValue execute(Expression expression, Map<String, MoValue> context) {
        MoScope scope = new MoScope();
        if (!context.isEmpty()) {
            this.environment.setStruct("context", new ContextStruct(context));
        }
        MoValue result = expression.evaluate(scope, this.environment);
        this.environment.temp.clear();
        this.environment.removeStruct("context");
        return scope.getReturnValue() != null ? scope.getReturnValue() : result;
    }

    public MoValue execute(List<Expression> expressions) {
        return this.execute(expressions, new HashMap<String, MoValue>());
    }

    public MoValue execute(List<Expression> expressions, Map<String, MoValue> context) {
        if (!context.isEmpty()) {
            this.environment.setStruct("context", new ContextStruct(context));
        }
        MoValue result = DoubleValue.ZERO;
        MoScope scope = new MoScope();
        if (expressions.size() == 1) {
            result = expressions.get(0).evaluate(scope, this.environment);
            this.environment.temp.clear();
            this.environment.removeStruct("context");
            return scope.getReturnValue() != null ? scope.getReturnValue() : result;
        }
        for (Expression expression : expressions) {
            if (scope.getReturnValue() != null) break;
            result = expression.evaluate(scope, this.environment);
        }
        this.environment.temp.clear();
        this.environment.removeStruct("context");
        return scope.getReturnValue() != null ? scope.getReturnValue() : result;
    }

    public MoLangEnvironment getEnvironment() {
        return this.environment;
    }
}

