/*
 * Decompiled with CFR 0.152.
 */
package dev.furq.resourcepackcached.mixin;

import com.google.common.hash.HashCode;
import dev.furq.resourcepackcached.utils.CachingUtils;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_9039;
import net.minecraft.class_9044;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_9044.class})
abstract class ServerPackManagerMixin {
    @Unique
    private final HashMap<UUID, Path> latestPacks = new HashMap();
    @Final
    @Shadow
    class_9039 field_47630;
    @Unique
    private boolean isNewSequence = true;

    ServerPackManagerMixin() {
    }

    @Shadow
    public abstract void method_55556(UUID var1);

    @Shadow
    abstract void method_55567();

    @Inject(method={"method_55558(Ljava/util/UUID;Ljava/net/URL;Lcom/google/common/hash/HashCode;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onPushPack(UUID id, URL url, @Nullable HashCode hashCode, CallbackInfo ci) {
        if (this.isNewSequence) {
            this.latestPacks.clear();
            this.isNewSequence = false;
        }
        if (hashCode != null) {
            Path downloadPath = new File(CachingUtils.GAME_DIR, "downloads/" + String.valueOf(id) + "/" + String.valueOf(hashCode)).toPath();
            this.latestPacks.put(id, downloadPath);
            if (CachingUtils.isCachedResourcePack(id, hashCode)) {
                this.field_47630.method_55619(id, class_9039.class_9040.field_47624);
                this.method_55567();
                ci.cancel();
            }
        }
    }

    @Inject(method={"method_55554(Ljava/util/Collection;Lnet/minecraft/class_9028$class_9030;)V"}, at={@At(value="RETURN")})
    public void afterDownload(CallbackInfo ci) {
        this.isNewSequence = true;
        if (!this.latestPacks.isEmpty()) {
            HashMap<UUID, Path> cachedPacks = CachingUtils.readCacheFile();
            cachedPacks.keySet().stream().filter(uuid -> !this.latestPacks.containsKey(uuid)).forEach(this::method_55556);
            CachingUtils.writeCacheFile(this.latestPacks);
        }
    }

    @Inject(method={"method_55567()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onRegisterForUpdate(CallbackInfo ci) {
        if (CachingUtils.isStartup) {
            ci.cancel();
        }
    }

    @Inject(method={"method_55570()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onTriggerReloadIfNeeded(CallbackInfo ci) {
        if (CachingUtils.isStartup) {
            ci.cancel();
        }
    }

    @Inject(method={"method_55552()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPopAll(CallbackInfo ci) {
        this.latestPacks.clear();
        ci.cancel();
    }
}

