/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.registry;

import com.necro.raid.dens.common.data.raid.RaidBucket;
import com.necro.raid.dens.common.util.DoubleWeightedRandomMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class RaidBucketRegistry {
    public static final class_5321<class_2378<RaidBucket>> BUCKET_KEY = class_5321.method_29180((class_2960)class_2960.method_60655((String)"raid", (String)"bucket"));
    public static class_2378<RaidBucket> REGISTRY;
    public static class_2378<class_1959> BIOME_REGISTRY;
    private static final Map<class_2960, RaidBucket> BUCKET_MAP;

    public static void register(RaidBucket bucket) {
        BUCKET_MAP.put(bucket.getId(), bucket);
    }

    public static class_2960 getRandomBucket(class_5819 random, class_6880<class_1959> biome) {
        HashSet candidates = new HashSet();
        BUCKET_MAP.forEach((location, bucket) -> {
            if (bucket.isValidBiome(biome)) {
                candidates.add(location);
            }
        });
        if (candidates.isEmpty()) {
            return null;
        }
        DoubleWeightedRandomMap<class_2960> weightedMap = new DoubleWeightedRandomMap<class_2960>();
        for (class_2960 bucket2 : candidates) {
            weightedMap.add(bucket2, RaidBucketRegistry.getBucket(bucket2).getWeight());
        }
        return weightedMap.getRandom(random).orElse(null);
    }

    public static RaidBucket getBucket(class_2960 bucket) {
        return BUCKET_MAP.getOrDefault(bucket, null);
    }

    public static void clear() {
        BUCKET_MAP.clear();
    }

    public static void init(MinecraftServer server) {
        REGISTRY = server.method_30611().method_30530(BUCKET_KEY);
        BIOME_REGISTRY = server.method_30611().method_30530(class_7924.field_41236);
    }

    static {
        BUCKET_MAP = new HashMap<class_2960, RaidBucket>();
    }
}

