/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids.helpers;

import com.necro.raid.dens.common.util.ComponentUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class RaidJoinHelper {
    private static final Map<class_1657, JoinRequest> JOIN_QUEUE = new HashMap<class_1657, JoinRequest>();
    private static final Map<UUID, Participant> RAID_PARTICIPANTS = new HashMap<UUID, Participant>();

    public static boolean isInQueue(class_1657 player) {
        return JOIN_QUEUE.containsKey(player);
    }

    public static void addToQueue(class_1657 player, @Nullable class_1799 key) {
        JOIN_QUEUE.put(player, new JoinRequest(player, key));
    }

    public static void removeFromQueue(class_1657 player, boolean refund) {
        JoinRequest joinRequest = JOIN_QUEUE.remove(player);
        if (joinRequest == null) {
            return;
        }
        if (refund) {
            joinRequest.refundItem();
        }
    }

    public static boolean addParticipant(class_1657 player, UUID raid, boolean isHost, boolean sendMessage) {
        boolean isParticipating = RaidJoinHelper.isParticipatingOrInQueue(player, sendMessage);
        if (!isParticipating) {
            RAID_PARTICIPANTS.put(player.method_5667(), new Participant(raid, isHost));
        }
        return !isParticipating;
    }

    public static Participant getParticipant(class_1657 player) {
        return RAID_PARTICIPANTS.get(player.method_5667());
    }

    public static void removeParticipant(class_1657 player) {
        RAID_PARTICIPANTS.remove(player.method_5667());
    }

    public static void removeParticipants(Collection<? extends class_1657> players) {
        players.forEach(player -> RAID_PARTICIPANTS.remove(player.method_5667()));
    }

    public static boolean isParticipating(class_1657 player, UUID raid) {
        Participant participant = RAID_PARTICIPANTS.get(player.method_5667());
        if (participant == null) {
            return false;
        }
        return participant.raid() == raid;
    }

    public static boolean isParticipating(class_1657 player, boolean sendMessage) {
        Participant participant = RAID_PARTICIPANTS.get(player.method_5667());
        if (participant == null) {
            return false;
        }
        if (participant.isHost()) {
            if (sendMessage) {
                player.method_7353(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.already_hosting"), true);
            }
        } else if (sendMessage) {
            player.method_7353(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.already_participating"), true);
        }
        return true;
    }

    public static boolean isParticipatingOrInQueue(class_1657 player, boolean sendMessage) {
        if (RaidJoinHelper.isInQueue(player)) {
            if (sendMessage) {
                player.method_7353(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.already_in_queue"), true);
            }
            return true;
        }
        return RaidJoinHelper.isParticipating(player, sendMessage);
    }

    public static void onServerClose() {
        JOIN_QUEUE.forEach((player, instance) -> instance.refundItem());
        JOIN_QUEUE.clear();
        RAID_PARTICIPANTS.clear();
    }

    public static void serverTick() {
        JOIN_QUEUE.values().removeIf(instance -> !instance.tick());
    }

    public static void onPlayerDisconnect(class_1657 player) {
        RaidJoinHelper.refundItem(player);
    }

    private static void refundItem(class_1657 player) {
        if (!JOIN_QUEUE.containsKey(player)) {
            return;
        }
        JOIN_QUEUE.get(player).refundItem();
        JOIN_QUEUE.remove(player);
    }

    public static class JoinRequest {
        private final class_1657 player;
        private final class_1799 itemStack;
        private int tick;

        public JoinRequest(class_1657 player, @Nullable class_1799 itemStack) {
            this.player = player;
            if (itemStack == null) {
                this.itemStack = null;
            } else {
                this.itemStack = itemStack.method_7972();
                this.itemStack.method_7939(1);
            }
            this.tick = 0;
        }

        public void refundItem() {
            if (this.itemStack != null) {
                this.player.method_7270(this.itemStack);
            }
        }

        public boolean tick() {
            if (++this.tick > 1200) {
                this.player.method_7353(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.request_time_out"), true);
                return false;
            }
            return true;
        }
    }

    public record Participant(UUID raid, boolean isHost) {
    }
}

