/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids.battle;

import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.api.pokemon.status.Status;
import com.cobblemon.mod.common.pokemon.status.VolatileStatus;
import com.necro.raid.dens.common.showdown.events.ClearBoostShowdownEvent;
import com.necro.raid.dens.common.showdown.events.ClearNegativeBoostShowdownEvent;
import com.necro.raid.dens.common.showdown.events.CureStatusShowdownEvent;
import com.necro.raid.dens.common.showdown.events.InvertBoostShowdownEvent;
import com.necro.raid.dens.common.showdown.events.SetBoostShowdownEvent;
import com.necro.raid.dens.common.showdown.events.SetStatusShowdownEvent;
import com.necro.raid.dens.common.showdown.events.ShowdownEvent;
import com.necro.raid.dens.common.showdown.events.StatBoostShowdownEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_3532;

public class RaidPokemon {
    Status status = null;
    public final Set<VolatileStatus> volatileStatus = new HashSet<VolatileStatus>();
    public final Map<Stat, Integer> boosts = new HashMap<Stat, Integer>();

    public Optional<ShowdownEvent> addStatus(Status status) {
        if (this.status != null) {
            return Optional.empty();
        }
        this.status = status;
        return Optional.of(new SetStatusShowdownEvent(status, 2));
    }

    public Optional<ShowdownEvent> removeStatus() {
        if (this.status == null) {
            return Optional.empty();
        }
        this.status = null;
        return Optional.of(new CureStatusShowdownEvent(null, 2));
    }

    public Optional<ShowdownEvent> addVolatile(VolatileStatus status) {
        if (this.volatileStatus.contains(status)) {
            return Optional.empty();
        }
        this.volatileStatus.add(status);
        return Optional.of(new SetStatusShowdownEvent((Status)status, 2));
    }

    public Optional<ShowdownEvent> removeVolatile(VolatileStatus status) {
        if (!this.volatileStatus.contains(status)) {
            return Optional.empty();
        }
        this.volatileStatus.remove(status);
        return Optional.of(new CureStatusShowdownEvent((Status)status, 2));
    }

    public Optional<ShowdownEvent> boost(Stat stat, int boost) {
        int stages;
        int originalStages = this.boosts.getOrDefault(stat, 0);
        if (originalStages == (stages = class_3532.method_15340((int)(originalStages + boost), (int)-6, (int)6))) {
            return Optional.empty();
        }
        this.boosts.put(stat, stages);
        boost = stages - originalStages;
        return Optional.of(new StatBoostShowdownEvent(stat, boost, 2, true));
    }

    public Optional<ShowdownEvent> setBoost(Stat stat, int boost) {
        int stages = this.boosts.getOrDefault(stat, 0);
        if (stages == boost) {
            return Optional.empty();
        }
        this.boosts.put(stat, boost);
        return Optional.of(new SetBoostShowdownEvent(stat, boost, 2));
    }

    public Optional<ShowdownEvent> clearBoosts() {
        if (this.boosts.isEmpty()) {
            return Optional.empty();
        }
        this.boosts.clear();
        return Optional.of(new ClearBoostShowdownEvent(2));
    }

    public Optional<ShowdownEvent> clearNegativeBoosts() {
        boolean wasCleared = false;
        Iterator<Map.Entry<Stat, Integer>> it = this.boosts.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next().getValue() >= 0) continue;
            it.remove();
            wasCleared = true;
        }
        if (!wasCleared) {
            return Optional.empty();
        }
        return Optional.of(new ClearNegativeBoostShowdownEvent(2));
    }

    public Optional<ShowdownEvent> invertBoosts() {
        if (this.boosts.isEmpty()) {
            return Optional.empty();
        }
        this.boosts.replaceAll((stat, stages) -> -stages.intValue());
        return Optional.of(new InvertBoostShowdownEvent(2));
    }
}

