/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.raids;

import com.cobblemon.mod.common.item.PokeBallItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.advancements.RaidDenCriteriaTriggers;
import com.necro.raid.dens.common.compat.ModCompat;
import com.necro.raid.dens.common.compat.cobbledollars.RaidDensCobbleDollarsCompat;
import com.necro.raid.dens.common.components.ModComponents;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.events.RewardPokemonEvent;
import com.necro.raid.dens.common.items.ModItems;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.registry.RaidRegistry;
import com.necro.raid.dens.common.util.ComponentUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_9331;

public class RewardHandler {
    private final class_2960 raidBossId;
    private RaidBoss raidBoss;
    private final UUID playerUUID;
    private final boolean isCatchable;
    private final Pokemon cachedReward;

    public RewardHandler(RaidBoss raidBoss, UUID playerUUID, boolean isCatchable, Pokemon cachedReward) {
        this.raidBossId = raidBoss.getId();
        this.raidBoss = raidBoss;
        this.playerUUID = playerUUID;
        this.isCatchable = isCatchable;
        this.cachedReward = cachedReward == null ? null : cachedReward.clone(true, null);
    }

    public RewardHandler(class_2960 raidBossId, UUID playerUUID, boolean isCatchable, Pokemon cachedReward) {
        this.raidBossId = raidBossId;
        this.raidBoss = null;
        this.playerUUID = playerUUID;
        this.isCatchable = isCatchable;
        this.cachedReward = cachedReward == null ? null : cachedReward.clone(true, null);
    }

    public RewardHandler(RaidBoss raidBoss, class_3222 player, boolean isCatchable, Pokemon cachedReward) {
        this(raidBoss, player.method_5667(), isCatchable, cachedReward);
    }

    public RewardHandler(RaidBoss raidBoss, class_3222 player, boolean isCatchable) {
        this(raidBoss, player, isCatchable, null);
    }

    public void sendRewardMessage(class_3222 player) {
        if (this.raidBoss == null) {
            this.raidBoss = RaidRegistry.getRaidBoss(this.raidBossId);
        }
        if (this.raidBoss.getDisplaySpecies() == null) {
            this.raidBoss.createDisplayAspects();
        }
        String speciesName = ((class_2588)this.raidBoss.getDisplaySpecies().getTranslatedName().method_10851()).method_11022();
        RaidDenNetworkMessages.REWARD_PACKET.accept((Object)player, (Object)this.isCatchable, (Object)speciesName);
        RaidHelper.REWARD_QUEUE.put(player.method_5667(), this);
    }

    public boolean givePokemonToPlayer(class_3222 player) {
        class_1792 class_17922;
        if (this.raidBoss == null) {
            this.raidBoss = RaidRegistry.getRaidBoss(this.raidBossId);
        }
        if (!((class_17922 = player.method_6047().method_7909()) instanceof PokeBallItem)) {
            player.method_7353(ComponentUtils.getSystemMessage("message.cobblemonraiddens.reward.reward_not_pokeball"), true);
            return false;
        }
        PokeBallItem pokeBallItem = (PokeBallItem)class_17922;
        Pokemon pokemon = this.cachedReward == null ? this.raidBoss.getRewardPokemon(player) : this.cachedReward;
        pokemon.setCaughtBall(pokeBallItem.getPokeBall());
        if (!RaidEvents.REWARD_POKEMON.postWithResult(new RewardPokemonEvent(player, pokemon))) {
            return false;
        }
        if (!this.giveItemToPlayer(player)) {
            return false;
        }
        PlayerExtensionsKt.party((class_3222)player).add(pokemon);
        player.method_6047().method_57008(1, (class_1309)player);
        RaidDenCriteriaTriggers.triggerRaidShiny(player, pokemon);
        return true;
    }

    public boolean giveItemToPlayer(class_3222 player) {
        if (this.raidBoss == null) {
            this.raidBoss = RaidRegistry.getRaidBoss(this.raidBossId);
        }
        class_1799 raidPouch = this.buildRaidPouch();
        List<class_1799> rewards = this.raidBoss.getRandomRewards(player.method_51469());
        rewards.addFirst(raidPouch);
        for (class_1799 item : rewards) {
            class_1542 itemEntity;
            if (player.method_31548().method_7394(item) || (itemEntity = player.method_7328(item, false)) == null) continue;
            itemEntity.method_6975();
            itemEntity.method_48349(player.method_5667());
        }
        return true;
    }

    public void giveCurrency(class_3222 player) {
        if (this.raidBoss == null) {
            this.raidBoss = RaidRegistry.getRaidBoss(this.raidBossId);
        }
        if (!ModCompat.COBBLEDOLLARS.isLoaded()) {
            return;
        }
        if (this.raidBoss.getCurrency() <= 0) {
            return;
        }
        RaidDensCobbleDollarsCompat.addCurrency(player, this.raidBoss.getCurrency());
    }

    private class_1799 buildRaidPouch() {
        if (this.raidBoss == null) {
            this.raidBoss = RaidRegistry.getRaidBoss(this.raidBossId);
        }
        class_1799 item = ((class_1792)ModItems.RAID_POUCH.comp_349()).method_7854();
        item.method_57379((class_9331)ModComponents.TIER_COMPONENT.comp_349(), (Object)this.raidBoss.getTier());
        item.method_57379((class_9331)ModComponents.FEATURE_COMPONENT.comp_349(), (Object)this.raidBoss.getFeature());
        item.method_57379((class_9331)ModComponents.TYPE_COMPONENT.comp_349(), (Object)this.raidBoss.getType());
        return item;
    }

    public class_2487 serialize(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        tag.method_10582("raid_boss", this.raidBossId.toString());
        tag.method_25927("player", this.playerUUID);
        tag.method_10556("is_catchable", this.isCatchable);
        if (this.cachedReward != null) {
            tag.method_10566("cached_reward", (class_2520)this.cachedReward.saveToNBT((class_5455)provider, new class_2487()));
        }
        return tag;
    }

    public static RewardHandler deserialize(class_2487 tag, class_7225.class_7874 provider) {
        class_2960 raidBossId = class_2960.method_60654((String)tag.method_10558("raid_boss"));
        UUID playerUUID = tag.method_25926("player");
        boolean isCatchable = tag.method_10577("is_catchable");
        Pokemon cachedReward = null;
        if (tag.method_10545("cached_reward")) {
            cachedReward = new Pokemon();
            cachedReward.loadFromNBT((class_5455)provider, tag.method_10562("cached_reward"));
        }
        return new RewardHandler(raidBossId, playerUUID, isCatchable, cachedReward);
    }
}

