/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.mixins.raid;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.raids.RaidState;
import com.necro.raid.dens.common.registry.RaidRegistry;
import com.necro.raid.dens.common.util.IRaidAccessor;
import com.necro.raid.dens.common.util.IShinyRate;
import com.necro.raid.dens.common.util.ITransformer;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PokemonEntity.class})
public abstract class PokemonEntityMixin
extends class_1321
implements IRaidAccessor,
ITransformer {
    @Unique
    private UUID crd_raidId;
    @Unique
    private class_2960 crd_raidBoss;
    @Unique
    private boolean crd_flagRemove = false;
    @Unique
    private RaidState crd_raidState = RaidState.IN_PROGRESS;
    @Unique
    private Pokemon crd_transformTarget = null;

    @Shadow(remap=false)
    public abstract Pokemon getPokemon();

    protected PokemonEntityMixin(class_1299<? extends class_1321> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    public UUID crd_getRaidId() {
        return this.crd_raidId;
    }

    @Override
    public void crd_setRaidId(UUID raidId) {
        this.crd_raidId = raidId;
    }

    @Override
    public boolean crd_isRaidBoss() {
        return this.getPokemon().getAspects().contains("raid") || this.getPokemon().getForcedAspects().contains("raid") || this.crd_raidBoss != null;
    }

    @Override
    public RaidBoss crd_getRaidBoss() {
        return RaidRegistry.getRaidBoss(this.crd_raidBoss);
    }

    @Override
    public void crd_setRaidBoss(class_2960 raidBoss) {
        this.crd_raidBoss = raidBoss;
    }

    @Override
    public void crd_flagForRemoval() {
        this.crd_flagRemove = true;
    }

    @Override
    public void crd_setRaidState(RaidState state) {
        this.crd_raidState = state;
    }

    @Override
    public RaidState crd_getRaidState() {
        return this.crd_raidState;
    }

    @Override
    public void crd_setTransformTarget(Pokemon pokemon) {
        if (this.crd_transformTarget != null) {
            return;
        }
        this.crd_transformTarget = pokemon.clone(false, null);
        this.crd_transformTarget.setUuid(this.getPokemon().getUuid());
        this.crd_transformTarget.setTetheringId(null);
        HashSet<String> aspects = new HashSet<String>(this.getPokemon().getAspects());
        aspects.add("raid");
        this.getPokemon().setForcedAspects(aspects);
        this.getPokemon().onChange(null);
    }

    @Override
    public Pokemon crd_getTransformTarget() {
        return this.crd_transformTarget;
    }

    @Inject(method={"method_5773()V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void tickInject(CallbackInfo ci) {
        if (this.crd_flagRemove) {
            this.method_31472();
            ci.cancel();
        }
    }

    @Inject(method={"canBattle(Lnet/minecraft/class_1657;)Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void canBattleInject(class_1657 player, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_37908().method_8608() && this.method_35057() == null) {
            cir.setReturnValue((Object)true);
        }
        if (this.crd_getRaidId() == null) {
            return;
        }
        if (this.method_6032() <= 0.0f || this.method_29504() || PlayerExtensionsKt.isPartyBusy((class_1657)player)) {
            cir.setReturnValue((Object)false);
        }
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"isBattling()Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void isBattlingInject(CallbackInfoReturnable<Boolean> cir) {
        if (this.crd_getRaidId() != null) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"method_5647(Lnet/minecraft/class_2487;)Lnet/minecraft/class_2487;"}, at={@At(value="RETURN")})
    private void saveWithoutIdInject(class_2487 nbt, CallbackInfoReturnable<class_2487> cir) {
        if (this.crd_raidId != null) {
            nbt.method_10582("raid_id", this.crd_raidId.toString());
        }
        if (this.crd_raidBoss != null) {
            nbt.method_10582("raid_boss", this.crd_raidBoss.toString());
        }
        if (this.crd_flagRemove) {
            nbt.method_10556("raid_flag_remove", true);
        }
        if (this.crd_raidState == RaidState.SUCCESS) {
            nbt.method_10569("raid_state", 1);
        } else if (this.crd_raidState == RaidState.FAILED) {
            nbt.method_10569("raid_state", -1);
        }
    }

    @Inject(method={"method_5651(Lnet/minecraft/class_2487;)V"}, at={@At(value="RETURN")})
    private void loadInject(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("raid_id")) {
            this.crd_raidId = UUID.fromString(nbt.method_10558("raid_id"));
        }
        if (nbt.method_10545("raid_boss")) {
            this.crd_raidBoss = class_2960.method_60654((String)nbt.method_10558("raid_boss"));
        }
        this.crd_flagRemove = nbt.method_10545("raid_flag_remove");
        if (nbt.method_10545("raid_state")) {
            RaidState raidState = this.crd_raidState = nbt.method_10550("raid_state") == 1 ? RaidState.SUCCESS : RaidState.FAILED;
        }
        if (this.getPokemon() == null) {
            return;
        }
        class_2487 tag = nbt.method_10562("Pokemon");
        if (tag.method_10545("raid_shiny_rate")) {
            ((IShinyRate)this.getPokemon()).crd_setRaidShinyRate(tag.method_10583("raid_shiny_rate"));
        }
    }
}

