/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.data.dimension;

import com.necro.raid.dens.common.blocks.ModBlocks;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.registry.RaidDenRegistry;
import com.necro.raid.dens.common.util.IRaidTeleporter;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3485;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3793;
import net.minecraft.class_5425;
import net.minecraft.class_7522;
import net.minecraft.class_7924;

public class RaidRegion {
    private static final int RADIUS = 128;
    private final class_2338 centre;
    private final class_238 bound;
    private class_2960 structure;

    public RaidRegion(class_2338 centre, class_2960 structure) {
        this.centre = centre;
        this.bound = new class_238((double)(centre.method_10263() - 128), -64.0, (double)(centre.method_10260() - 128), (double)(centre.method_10263() + 128), 128.0, (double)(centre.method_10260() + 128));
        this.structure = structure;
    }

    public class_2338 centre() {
        return this.centre;
    }

    public class_238 bound() {
        return this.bound;
    }

    public class_2338 getOffset() {
        return class_2338.method_49638((class_2374)RaidDenRegistry.getOffset(this.structure).method_1019(this.centre.method_61082()));
    }

    public class_243 getPlayerPos() {
        return RaidDenRegistry.getPlayerPos(this.structure).method_1019(class_243.method_24954((class_2382)this.centre));
    }

    public class_243 getBossPos() {
        return RaidDenRegistry.getBossPos(this.structure).method_1019(class_243.method_24954((class_2382)this.centre));
    }

    public void clearRegion(class_3218 level) {
        int minX = this.centre.method_10263() - 128;
        int maxX = this.centre.method_10263() + 128;
        int minZ = this.centre.method_10260() - 128;
        int maxZ = this.centre.method_10260() + 128;
        int chunkMinX = minX >> 4;
        int chunkMaxX = maxX >> 4;
        int chunkMinZ = minZ >> 4;
        int chunkMaxZ = maxZ >> 4;
        level.method_18467(class_3222.class, this.bound()).forEach(player -> {
            RaidUtils.leaveRaid((class_1657)player);
            ((IRaidTeleporter)player).crd_returnHome();
        });
        for (class_1297 e : level.method_18467(class_1297.class, this.bound())) {
            if (e == null || e instanceof class_1657) continue;
            e.method_31472();
        }
        for (int cx = chunkMinX; cx <= chunkMaxX; ++cx) {
            for (int cz = chunkMinZ; cz <= chunkMaxZ; ++cz) {
                class_2818 chunk = level.method_8497(cx, cz);
                class_2826[] sections = chunk.method_12006();
                for (int i = 0; i < sections.length; ++i) {
                    class_2826 section = sections[i];
                    if (section == null || section.method_38292()) continue;
                    class_2378 registry = level.method_30349().method_30530(class_7924.field_41236);
                    chunk.method_12006()[i] = new class_2826(new class_2841((class_2359)class_2248.field_10651, (Object)class_2246.field_10124.method_9564(), class_2841.class_6563.field_34569), (class_7522)new class_2841(registry.method_40295(), (Object)registry.method_40290(ModDimensions.RAID_DIM_BIOME), class_2841.class_6563.field_34570));
                    chunk.method_12214().keySet().forEach(arg_0 -> ((class_2818)chunk).method_12041(arg_0));
                    section.method_12253();
                }
                chunk.method_12008(true);
            }
        }
    }

    public void placeStructure(class_3218 level) {
        class_3485 manager = level.method_8503().method_27727();
        class_3499 template = manager.method_15094(this.structure).orElseGet(() -> {
            this.structure = RaidDenRegistry.DEFAULT;
            return manager.method_15091(this.structure);
        });
        class_3492 settings = new class_3492();
        settings.method_16183();
        settings.method_16184((class_3491)class_3793.field_16718);
        class_2338 offset = this.getOffset();
        template.method_15172((class_5425)level, offset, offset, settings, level.method_8409(), 0);
        level.method_8501(this.centre(), ModBlocks.INSTANCE.getRaidHomeBlock().method_9564());
        class_1923 chunkPos = new class_1923(this.centre());
        level.method_14178().method_17297(class_3230.field_14031, chunkPos, 1, (Object)chunkPos);
    }

    public void removeRegionTicket(class_3218 level) {
        class_1923 chunkPos = new class_1923(this.centre());
        level.method_14178().method_17300(class_3230.field_14031, chunkPos, 1, (Object)chunkPos);
    }
}

