/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.blocks.entity;

import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.block.RaidCrystalBlock;
import com.necro.raid.dens.common.data.dimension.RaidRegion;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.data.raid.RaidBucket;
import com.necro.raid.dens.common.data.raid.RaidCycleMode;
import com.necro.raid.dens.common.data.raid.RaidTier;
import com.necro.raid.dens.common.data.raid.RaidType;
import com.necro.raid.dens.common.dimensions.ModDimensions;
import com.necro.raid.dens.common.events.RaidDenSpawnEvent;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.events.SetRaidBossEvent;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.RaidState;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.raids.helpers.RaidRegionHelper;
import com.necro.raid.dens.common.registry.RaidBucketRegistry;
import com.necro.raid.dens.common.registry.RaidRegistry;
import com.necro.raid.dens.common.util.IRaidAccessor;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class RaidCrystalBlockEntity
extends class_2586
implements GeoBlockEntity {
    private UUID raidHost;
    private int clears;
    private int inactiveTicks;
    private int soundTicks = 0;
    private UUID uuid;
    private class_2960 raidBucket;
    private class_2960 raidBoss;
    private long lastReset;
    private boolean isOpen = false;
    private Set<String> aspects;
    private Consumer<class_3222> aspectSync;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RaidCrystalBlockEntity(class_2591<? extends RaidCrystalBlockEntity> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
        this.uuid = UUID.randomUUID();
    }

    public void tick(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        if (level.method_8608()) {
            return;
        }
        boolean isIdle = this.isIdle();
        if (RaidHelper.hasRaidState(this.getUuid()) && isIdle) {
            this.closeRaid();
        }
        if (this.canGenerateBoss(blockState) && (this.raidBoss == null || !RaidRegistry.exists(this.raidBoss))) {
            this.generateRaidBoss(level, blockPos, blockState);
        }
        if (this.raidHost != null && isIdle) {
            if (++this.inactiveTicks > 2400) {
                this.closeRaid();
            }
        } else {
            this.inactiveTicks = 0;
        }
        if (!((Boolean)blockState.method_11654((class_2769)RaidCrystalBlock.CAN_RESET)).booleanValue()) {
            return;
        }
        if (CobblemonRaidDens.CONFIG.reset_time <= 0) {
            return;
        }
        if (this.isInProgress()) {
            return;
        }
        long gameTime = level.method_8510();
        if (this.lastReset == 0L) {
            this.lastReset = gameTime;
        } else if (gameTime - this.lastReset > (long)CobblemonRaidDens.CONFIG.reset_time * 20L) {
            this.generateRaidBoss(level, blockPos, blockState);
        }
        if (!this.isActive(blockState)) {
            return;
        }
        if (++this.soundTicks % 120 == 0) {
            level.method_8396(null, blockPos, class_3417.field_26980, class_3419.field_15245, 0.5f, 1.0f);
            this.soundTicks = 0;
        }
    }

    public void generateRaidBoss(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        RaidBoss raidBoss;
        RaidCycleMode cycleMode = (RaidCycleMode)((Object)blockState.method_11654(RaidCrystalBlock.CYCLE_MODE));
        class_2960 bossLocation = null;
        if (cycleMode == RaidCycleMode.NONE) {
            return;
        }
        if (this.raidBucket != null) {
            bossLocation = RaidBucketRegistry.getBucket(this.raidBucket).getRandomRaidBoss(level.method_8409(), level);
        }
        if (bossLocation == null) {
            RaidTier tier = cycleMode.canCycleTier() ? RaidTier.getWeightedRandom(level.method_8409(), level) : (RaidTier)((Object)blockState.method_11654(RaidCrystalBlock.RAID_TIER));
            RaidType type = cycleMode.canCycleType() ? null : (RaidType)((Object)blockState.method_11654(RaidCrystalBlock.RAID_TYPE));
            bossLocation = RaidRegistry.getRandomRaidBoss(level.method_8409(), level, tier, type, null);
        }
        if ((raidBoss = RaidRegistry.getRaidBoss(bossLocation)) == null) {
            return;
        }
        SetRaidBossEvent event = new SetRaidBossEvent(raidBoss);
        RaidEvents.SET_RAID_BOSS.emit((Object[])new SetRaidBossEvent[]{event});
        raidBoss = event.getRaidBoss();
        if (raidBoss == null) {
            this.inactiveTicks = 0;
            this.lastReset = level.method_8510();
            return;
        }
        this.setRaidBoss(raidBoss.getId(), level.method_8510());
        level.method_8652(blockPos, (class_2680)((class_2680)((class_2680)blockState.method_11657(RaidCrystalBlock.RAID_TIER, (Comparable)((Object)raidBoss.getTier()))).method_11657(RaidCrystalBlock.RAID_TYPE, (Comparable)((Object)raidBoss.getType()))).method_11657((class_2769)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        RaidEvents.RAID_DEN_SPAWN.emit((Object[])new RaidDenSpawnEvent[]{new RaidDenSpawnEvent((class_3218)level, blockPos, raidBoss)});
    }

    public boolean spawnRaidBoss() {
        if (this.method_10997() == null) {
            return false;
        }
        RaidBoss raidBoss = this.getRaidBoss();
        RaidRegion region = RaidRegionHelper.getRegion(this.getUuid());
        class_3218 level = ModDimensions.getRaidDimension(this.method_10997().method_8503());
        if (raidBoss == null || region == null || level == null) {
            CobblemonRaidDens.LOGGER.error("Could not load Raid Boss {}", (Object)this.raidBoss);
            this.setRaidBoss(null, 0L);
            return false;
        }
        region.placeStructure(level);
        PokemonEntity pokemonEntity = raidBoss.getBossEntity(level, this.aspects);
        pokemonEntity.method_5977(true);
        pokemonEntity.method_5684(true);
        pokemonEntity.method_5971();
        ((IRaidAccessor)pokemonEntity).crd_setRaidId(this.getUuid());
        if (CobblemonRaidDens.CONFIG.sync_rewards && this.aspects == null) {
            this.aspects = pokemonEntity.getAspects();
        }
        pokemonEntity.method_29495(region.getBossPos());
        level.method_8649((class_1297)pokemonEntity);
        if (pokemonEntity.getPokemon().getAbility().getName().equals("imposter")) {
            this.setAspectSync(player -> RaidDenNetworkMessages.RAID_ASPECT.accept((class_3222)player, (class_1297)pokemonEntity));
        }
        RaidHelper.ACTIVE_RAIDS.put(this.getUuid(), new RaidInstance(pokemonEntity, this.raidHost));
        return true;
    }

    public void clearRaid() {
        ++this.clears;
        this.aspects = null;
        if (this.isAtMaxClears()) {
            RaidHelper.resetClearedRaids(this.getUuid());
            if (this.method_10997() != null) {
                this.method_10997().method_8652(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)RaidCrystalBlock.ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
    }

    private boolean shouldClear(RaidState raidState) {
        if (raidState == null) {
            return false;
        }
        if (raidState == RaidState.SUCCESS) {
            return true;
        }
        return CobblemonRaidDens.CONFIG.max_clears_include_fails && raidState != RaidState.CANCELLED;
    }

    public void closeRaid() {
        if (this.method_10997() == null) {
            return;
        }
        class_3218 level = ModDimensions.getRaidDimension(this.method_10997().method_8503());
        if (level == null) {
            return;
        }
        if (this.shouldClear(RaidHelper.getRaidState(this.getUuid()))) {
            this.clearRaid();
        }
        RaidRegionHelper.clearRegion(this.getUuid(), level);
        this.clearRaidHost();
        this.inactiveTicks = 0;
        this.method_10997().method_8500(this.method_11016()).method_12008(true);
        this.method_5431();
        this.isOpen = false;
        this.setAspectSync(null);
    }

    public UUID getRaidHost() {
        return this.raidHost;
    }

    public boolean canSetRaidHost() {
        return this.getRaidHost() == null;
    }

    public void setRaidHost(class_1657 player) {
        this.raidHost = player.method_5667();
        this.method_5431();
    }

    public void clearRaidHost() {
        this.raidHost = null;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public RaidBucket getRaidBucket() {
        return RaidBucketRegistry.getBucket(this.raidBucket);
    }

    public RaidBoss getRaidBoss() {
        return RaidRegistry.getRaidBoss(this.raidBoss);
    }

    public class_2960 getRaidBossLocation() {
        return this.raidBoss;
    }

    public int getPlayerCount() {
        RaidInstance raid = RaidHelper.ACTIVE_RAIDS.get(this.getUuid());
        if (raid == null) {
            return 0;
        }
        return raid.getPlayers().size();
    }

    public long getTicksUntilNextReset() {
        if (this.method_10997() == null) {
            return 0L;
        }
        if (!((Boolean)this.method_11010().method_11654((class_2769)RaidCrystalBlock.CAN_RESET)).booleanValue()) {
            return 0L;
        }
        if (CobblemonRaidDens.CONFIG.reset_time <= 0) {
            return 0L;
        }
        return (long)CobblemonRaidDens.CONFIG.reset_time * 20L - (this.method_10997().method_8510() - this.lastReset);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen() {
        this.isOpen = true;
    }

    public boolean isPlayerParticipating(class_1657 player) {
        return RaidJoinHelper.isParticipating(player, this.getUuid());
    }

    public boolean isInProgress() {
        return RaidHelper.ACTIVE_RAIDS.containsKey(this.getUuid());
    }

    public boolean isIdle() {
        if (this.method_10997() == null) {
            return false;
        }
        RaidRegion region = RaidRegionHelper.getRegion(this.getUuid());
        if (region == null) {
            return true;
        }
        class_3218 level = ModDimensions.getRaidDimension(this.method_10997().method_8503());
        if (level == null) {
            return false;
        }
        int activePlayers = level.method_18467(class_1657.class, region.bound()).size();
        return activePlayers == 0;
    }

    public boolean isActive(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)RaidCrystalBlock.ACTIVE) != false && blockState.method_11654(RaidCrystalBlock.RAID_TYPE) != RaidType.NONE && this.raidBoss != null;
    }

    public boolean canGenerateBoss(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)RaidCrystalBlock.ACTIVE) != false && blockState.method_11654(RaidCrystalBlock.RAID_TYPE) != RaidType.NONE;
    }

    public boolean renderBeacon(class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)RaidCrystalBlock.ACTIVE) != false && blockState.method_11654(RaidCrystalBlock.RAID_TYPE) != RaidType.NONE;
    }

    public void resetClears() {
        this.clears = 0;
    }

    public boolean isAtMaxClears() {
        RaidBoss boss = this.getRaidBoss();
        if (boss == null) {
            return true;
        }
        int maxClears = CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier()).maxClears();
        return maxClears != -1 && this.clears >= maxClears;
    }

    public boolean isFull() {
        RaidBoss boss = this.getRaidBoss();
        if (boss == null) {
            return true;
        }
        int maxPlayers = CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier()).maxPlayers();
        return maxPlayers != -1 && this.getPlayerCount() >= maxPlayers;
    }

    public void setRaidBucket(class_2960 bucket) {
        this.raidBucket = bucket;
    }

    public void syncAspects(class_3222 player) {
        if (this.aspectSync == null) {
            return;
        }
        CompletableFuture.delayedExecutor(1L, TimeUnit.SECONDS).execute(() -> this.aspectSync.accept(player));
    }

    public void setAspectSync(Consumer<class_3222> sync) {
        this.aspectSync = sync;
    }

    protected void method_11014(class_2487 compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 provider) {
        if (compoundTag.method_10545("raid_host_uuid")) {
            this.raidHost = UUID.fromString(compoundTag.method_10558("raid_host_uuid"));
        }
        this.clears = compoundTag.method_10550("raid_cleared");
        this.lastReset = compoundTag.method_10537("last_reset");
        this.inactiveTicks = compoundTag.method_10550("raid_inactive_for");
        this.uuid = compoundTag.method_10545("uuid") ? UUID.fromString(compoundTag.method_10558("uuid")) : UUID.randomUUID();
        if (compoundTag.method_10545("raid_bucket")) {
            this.raidBucket = class_2960.method_60654((String)compoundTag.method_10558("raid_bucket"));
        }
        if (compoundTag.method_10545("raid_boss")) {
            this.raidBoss = class_2960.method_60654((String)compoundTag.method_10558("raid_boss"));
        }
        if (compoundTag.method_10545("is_open")) {
            this.isOpen = true;
        }
        if (compoundTag.method_10545("aspects")) {
            HashSet<String> aspects = new HashSet<String>();
            for (class_2520 tag : compoundTag.method_10554("aspects", 8)) {
                aspects.add(tag.method_10714());
            }
            this.aspects = aspects;
        }
    }

    protected void method_11007(@NotNull class_2487 compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 provider) {
        if (this.raidHost != null) {
            compoundTag.method_10582("raid_host_uuid", this.raidHost.toString());
        }
        compoundTag.method_10569("raid_cleared", this.clears);
        compoundTag.method_10544("last_reset", this.lastReset);
        compoundTag.method_10569("raid_inactive_for", this.inactiveTicks);
        if (this.uuid != null) {
            compoundTag.method_10582("uuid", this.uuid.toString());
        }
        if (this.raidBucket != null) {
            compoundTag.method_10582("raid_bucket", this.raidBucket.toString());
        }
        if (this.raidBoss != null) {
            compoundTag.method_10582("raid_boss", this.raidBoss.toString());
        }
        if (this.isOpen) {
            compoundTag.method_10556("is_open", true);
        }
        if (this.aspects != null) {
            class_2499 tag = new class_2499();
            this.aspects.forEach(aspect -> tag.add((Object)class_2519.method_23256((String)aspect)));
            compoundTag.method_10566("aspects", (class_2520)tag);
        }
    }

    public void setRaidBoss(class_2960 raidBoss, long gameTime) {
        RaidHelper.resetClearedRaids(this.getUuid());
        this.resetClears();
        this.inactiveTicks = 0;
        this.lastReset = gameTime;
        this.raidBoss = raidBoss;
        this.aspects = null;
        this.method_5431();
    }

    @NotNull
    public class_2487 method_16887(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 provider) {
        class_2487 tag = super.method_16887(provider);
        if (this.raidBoss != null) {
            tag.method_10582("raid_boss", this.raidBoss.toString());
        }
        return tag;
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

