/*
 * Decompiled with CFR 0.152.
 */
package com.necro.raid.dens.common.blocks.block;

import com.necro.raid.dens.common.CobblemonRaidDens;
import com.necro.raid.dens.common.blocks.entity.RaidCrystalBlockEntity;
import com.necro.raid.dens.common.data.adapters.UniqueKeyAdapter;
import com.necro.raid.dens.common.data.dimension.RaidRegion;
import com.necro.raid.dens.common.data.raid.RaidBoss;
import com.necro.raid.dens.common.data.raid.RaidCycleMode;
import com.necro.raid.dens.common.data.raid.RaidTier;
import com.necro.raid.dens.common.data.raid.RaidType;
import com.necro.raid.dens.common.events.RaidEvents;
import com.necro.raid.dens.common.events.RaidJoinEvent;
import com.necro.raid.dens.common.network.RaidDenNetworkMessages;
import com.necro.raid.dens.common.raids.RaidInstance;
import com.necro.raid.dens.common.raids.helpers.RaidHelper;
import com.necro.raid.dens.common.raids.helpers.RaidJoinHelper;
import com.necro.raid.dens.common.raids.helpers.RaidRegionHelper;
import com.necro.raid.dens.common.util.ComponentUtils;
import com.necro.raid.dens.common.util.RaidUtils;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_9062;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RaidCrystalBlock
extends class_2237 {
    public static final class_2754<RaidType> RAID_TYPE = class_2754.method_11850((String)"raid_type", RaidType.class);
    public static final class_2754<RaidTier> RAID_TIER = class_2754.method_11850((String)"raid_tier", RaidTier.class);
    public static final class_2746 ACTIVE = class_2746.method_11825((String)"is_active");
    public static final class_2746 CAN_RESET = class_2746.method_11825((String)"can_reset");
    public static final class_2754<RaidCycleMode> CYCLE_MODE = class_2754.method_11850((String)"cycle_mode", RaidCycleMode.class);

    public RaidCrystalBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)ACTIVE, (Comparable)Boolean.valueOf(false))).method_11657(RAID_TYPE, (Comparable)((Object)RaidType.NONE))).method_11657(RAID_TIER, (Comparable)((Object)RaidTier.TIER_ONE))).method_11657((class_2769)CAN_RESET, (Comparable)Boolean.valueOf(false))).method_11657(CYCLE_MODE, (Comparable)((Object)RaidCycleMode.NONE)));
    }

    @NotNull
    protected class_1269 method_55766(@NotNull class_2680 blockState, class_1937 level, @NotNull class_2338 blockPos, @NotNull class_1657 player, @NotNull class_3965 blockHitResult) {
        if (level.method_8608()) {
            return class_1269.field_5812;
        }
        class_2586 class_25862 = level.method_8321(blockPos);
        if (!(class_25862 instanceof RaidCrystalBlockEntity)) {
            return class_1269.field_5814;
        }
        RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)class_25862;
        boolean success = this.startOrJoinRaid(player, blockState, raidCrystal, null);
        return success ? class_1269.field_5812 : class_1269.field_5814;
    }

    @NotNull
    protected class_9062 method_55765(@NotNull class_1799 itemStack, @NotNull class_2680 blockState, class_1937 level, @NotNull class_2338 blockPos, @NotNull class_1657 player, @NotNull class_1268 interactionHand, @NotNull class_3965 blockHitResult) {
        if (level.method_8608()) {
            return class_9062.field_47728;
        }
        class_2586 blockEntity = level.method_8321(blockPos);
        if (!(blockEntity instanceof RaidCrystalBlockEntity)) {
            return class_9062.field_47733;
        }
        RaidCrystalBlockEntity raidCrystal = (RaidCrystalBlockEntity)blockEntity;
        if (raidCrystal.getRaidBoss() == null) {
            return class_9062.field_47733;
        }
        if (RaidRegionHelper.getRegion(raidCrystal.getUuid()) != null && raidCrystal.isPlayerParticipating(player)) {
            return class_9062.field_47731;
        }
        if (raidCrystal.getRaidBoss().getKey().isEmpty() && !CobblemonRaidDens.TIER_CONFIG.get(blockState.method_11654(RAID_TIER)).requiresKey()) {
            return class_9062.field_47731;
        }
        if (!this.handleKey(player, raidCrystal, itemStack)) {
            return class_9062.field_47733;
        }
        boolean success = this.startOrJoinRaid(player, blockState, raidCrystal, itemStack);
        if (success) {
            itemStack.method_57008(1, (class_1309)player);
        }
        return success ? class_9062.field_47729 : class_9062.field_47733;
    }

    private boolean startOrJoinRaid(class_1657 player, class_2680 blockState, RaidCrystalBlockEntity blockEntity, @Nullable class_1799 key) {
        if (player.method_5682() == null) {
            return false;
        }
        if (!blockEntity.isActive(blockState) || blockEntity.isAtMaxClears()) {
            player.method_7353(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.is_not_active"), true);
            return false;
        }
        if (RaidHelper.hasClearedRaid(blockEntity.getUuid(), player)) {
            player.method_7353(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.player_cleared"), true);
            return false;
        }
        RaidRegion region = RaidRegionHelper.getRegion(blockEntity.getUuid());
        if (region != null && blockEntity.isPlayerParticipating(player)) {
            RaidDenNetworkMessages.JOIN_RAID.accept((class_3222)player, true);
            RaidUtils.teleportPlayerToRaid((class_3222)player, player.method_5682(), region);
            blockEntity.syncAspects((class_3222)player);
            return true;
        }
        if (RaidJoinHelper.isParticipatingOrInQueue(player, true)) {
            return false;
        }
        if (blockEntity.canSetRaidHost()) {
            boolean success = this.startRaid(player, blockEntity);
            if (!success) {
                blockEntity.clearRaidHost();
            }
            return success;
        }
        if (blockEntity.isFull()) {
            player.method_7353(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.lobby_is_full"), true);
            return false;
        }
        return this.requestJoinRaid(player, blockEntity, key);
    }

    private boolean requestJoinRaid(class_1657 player, RaidCrystalBlockEntity blockEntity, @Nullable class_1799 key) {
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return false;
        }
        class_3222 raidHost = server.method_3760().method_14602(blockEntity.getRaidHost());
        if (raidHost == null) {
            player.method_7353(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.no_host"), true);
            return false;
        }
        RaidJoinHelper.addToQueue(player, key);
        RaidHelper.addRequest(raidHost, player);
        RaidDenNetworkMessages.REQUEST_PACKET.accept(raidHost, player.method_5477().getString());
        return true;
    }

    private boolean startRaid(class_1657 player, RaidCrystalBlockEntity blockEntity) {
        if (player.method_5682() == null) {
            return false;
        }
        blockEntity.setRaidHost(player);
        boolean success = RaidEvents.RAID_JOIN.postWithResult(new RaidJoinEvent((class_3222)player, true, blockEntity.getRaidBoss()));
        if (!success) {
            return false;
        }
        class_2960 structure = blockEntity.getRaidBoss().getRandomDen(player.method_37908().method_8409());
        RaidRegion region = RaidRegionHelper.createRegion(blockEntity.getUuid(), structure);
        if (region == null || !blockEntity.spawnRaidBoss()) {
            blockEntity.closeRaid();
            player.method_7353(ComponentUtils.getErrorMessage("message.cobblemonraiddens.raid.boss_spawn_failed"), true);
            return false;
        }
        if (!RaidJoinHelper.addParticipant(player, blockEntity.getUuid(), true, true)) {
            return false;
        }
        RaidHelper.initRequest((class_3222)player, blockEntity);
        RaidHelper.ACTIVE_RAIDS.get(blockEntity.getUuid()).addPlayer((class_3222)player);
        RaidUtils.teleportPlayerToRaid((class_3222)player, player.method_5682(), region);
        blockEntity.syncAspects((class_3222)player);
        return true;
    }

    private boolean handleKey(class_1657 player, RaidCrystalBlockEntity blockEntity, class_1799 itemStack) {
        RaidBoss boss = blockEntity.getRaidBoss();
        UniqueKeyAdapter key = boss.getKey();
        if (!key.isEmpty()) {
            if (blockEntity.isOpen()) {
                return true;
            }
            if (!key.matches(itemStack)) {
                player.method_7353(ComponentUtils.getSystemMessage(class_2561.method_43469((String)"message.cobblemonraiddens.raid.no_unique_key", (Object[])new Object[]{key.item().split(":")[1]})), true);
                return false;
            }
            if (!CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier()).allRequireUniqueKey()) {
                blockEntity.setOpen();
            }
        } else if (CobblemonRaidDens.TIER_CONFIG.get((Object)boss.getTier()).requiresKey() && !RaidUtils.isRaidDenKey(itemStack)) {
            player.method_7353(ComponentUtils.getSystemMessage("message.cobblemonraiddens.raid.no_key"), true);
            return false;
        }
        return true;
    }

    protected void method_9536(@NotNull class_2680 blockState, class_1937 level, @NotNull class_2338 blockPos, @NotNull class_2680 blockState2, boolean bl) {
        class_2586 class_25862;
        if (!level.method_8608() && (class_25862 = level.method_8321(blockPos)) instanceof RaidCrystalBlockEntity) {
            RaidCrystalBlockEntity blockEntity = (RaidCrystalBlockEntity)class_25862;
            blockEntity.closeRaid();
            RaidHelper.resetClearedRaids(blockEntity.getUuid());
            RaidInstance raid = RaidHelper.ACTIVE_RAIDS.get(blockEntity.getUuid());
            if (raid != null) {
                raid.closeRaid(level.method_8503(), true);
            }
        }
        super.method_9536(blockState, level, blockPos, blockState2, bl);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{RAID_TYPE});
        builder.method_11667(new class_2769[]{RAID_TIER});
        builder.method_11667(new class_2769[]{ACTIVE});
        builder.method_11667(new class_2769[]{CAN_RESET});
        builder.method_11667(new class_2769[]{CYCLE_MODE});
    }

    public class_2586 method_10123(@NotNull class_2338 blockPos, @NotNull class_2680 blockState) {
        return null;
    }

    @NotNull
    protected class_2464 method_9604(@NotNull class_2680 blockState) {
        return class_2464.field_11456;
    }

    protected boolean method_9516(@NotNull class_2680 blockState, @NotNull class_10 pathComputationType) {
        return false;
    }
}

