/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.ArrayList;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.levelscraft7.rustlingspots.config.RustlingSpotsServerConfig;
import net.levelscraft7.rustlingspots.network.packet.RustlingSpotRemovePacket;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.levelscraft7.rustlingspots.spot.RustlingSpotService;
import net.levelscraft7.rustlingspots.spot.SpotRewardResolver;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class SpotTicker {
    public void onServerTick(MinecraftServer server) {
        for (class_3218 level : server.method_3738()) {
            this.tickLevel(level);
        }
    }

    private void tickLevel(class_3218 level) {
        if (!RustlingSpotsServerConfig.GENERAL.enabled()) {
            ArrayList<RustlingSpot> toRemove = new ArrayList<RustlingSpot>(RustlingSpotService.MANAGER.getAll((class_5321<class_1937>)level.method_27983()));
            toRemove.forEach(spot -> this.removeSpot(level, (RustlingSpot)spot));
            return;
        }
        ArrayList<RustlingSpot> pendingRemoval = new ArrayList<RustlingSpot>();
        for (RustlingSpot spot2 : RustlingSpotService.MANAGER.getAll((class_5321<class_1937>)level.method_27983())) {
            if (this.shouldDespawn(level, spot2)) {
                pendingRemoval.add(spot2);
                continue;
            }
            class_3222 player = this.findInteractingPlayer(level, spot2);
            if (player == null) continue;
            SpotRewardResolver.resolve(level, player, spot2);
            pendingRemoval.add(spot2);
        }
        pendingRemoval.forEach(spot -> this.removeSpot(level, (RustlingSpot)spot));
    }

    private boolean shouldDespawn(class_3218 level, RustlingSpot spot) {
        if (!level.method_22340(spot.getPosition())) {
            return true;
        }
        long age = level.method_8510() - spot.getCreatedTick();
        if (age > (long)RustlingSpotsServerConfig.GENERAL.spotLifetimeTicks()) {
            return true;
        }
        double maxDistance = RustlingSpotsServerConfig.GENERAL.despawnIfNoPlayerWithin();
        double maxDistanceSq = maxDistance * maxDistance;
        return level.method_18456().stream().noneMatch(p -> p.method_5649((double)spot.getPosition().method_10263() + 0.5, (double)spot.getPosition().method_10264() + 0.5, (double)spot.getPosition().method_10260() + 0.5) <= maxDistanceSq);
    }

    private class_3222 findInteractingPlayer(class_3218 level, RustlingSpot spot) {
        class_243 lowerCorner = class_243.method_24954((class_2382)spot.getPosition());
        double interactionRadius = RustlingSpotsServerConfig.GENERAL.interactionRadius();
        double interactionVerticalAllowance = RustlingSpotsServerConfig.GENERAL.interactionVerticalAllowance();
        double interactionRadiusSq = interactionRadius * interactionRadius;
        class_238 box = class_238.method_29968((class_243)lowerCorner).method_1014(interactionRadius).method_1012(0.0, interactionVerticalAllowance, 0.0);
        class_243 spotCenter = lowerCorner.method_1031(0.5, 0.5, 0.5);
        for (class_1657 player : level.method_18467(class_1657.class, box)) {
            if (RustlingSpotService.INTERACTION_BLOCKER.isBlocked(player.method_5667(), level.method_8510())) continue;
            double dx = player.method_23317() - spotCenter.field_1352;
            double dz = player.method_23321() - spotCenter.field_1350;
            double dy = player.method_23318() - spotCenter.field_1351;
            if (!(dy >= -interactionRadius) || !(dy <= interactionRadius + interactionVerticalAllowance) || !(dx * dx + dz * dz <= interactionRadiusSq)) continue;
            return (class_3222)player;
        }
        return null;
    }

    private void removeSpot(class_3218 level, RustlingSpot spot) {
        RustlingSpotService.MANAGER.remove(spot);
        for (class_3222 player : level.method_18456()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new RustlingSpotRemovePacket(spot.getId()));
        }
    }
}

