/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.levelscraft7.rustlingspots.config.RustlingSpotsFamilySpawnConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsServerConfig;
import net.levelscraft7.rustlingspots.network.packet.RustlingSpotSpawnPacket;
import net.levelscraft7.rustlingspots.registry.RustlingSoundEvents;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.levelscraft7.rustlingspots.spot.RustlingSpotService;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class SpotSpawner {
    public void onServerTick(MinecraftServer server) {
        server.method_3738().forEach(this::trySpawnInLevel);
    }

    private void trySpawnInLevel(class_3218 level) {
        if (level.method_8510() % 20L != 0L) {
            return;
        }
        if (!RustlingSpotsServerConfig.GENERAL.enabled()) {
            return;
        }
        boolean allowedDimension = RustlingSpotsServerConfig.GENERAL.allowedDimensions().stream().map(Object::toString).map(class_2960::method_12829).anyMatch(id -> id != null && id.equals((Object)level.method_27983().method_29177()));
        if (!allowedDimension) {
            return;
        }
        ArrayList<class_3222> players = new ArrayList<class_3222>(level.method_18456());
        if (players.isEmpty()) {
            return;
        }
        class_5819 random = level.field_9229;
        if (RustlingSpotService.MANAGER.getAll((class_5321<class_1937>)level.method_27983()).size() >= RustlingSpotsServerConfig.GENERAL.maxSpotsPerDimension()) {
            return;
        }
        Set<class_1923> candidateChunks = this.collectCandidateChunks(players, random);
        if (candidateChunks.isEmpty()) {
            return;
        }
        ArrayList<class_1923> shuffled = new ArrayList<class_1923>(candidateChunks);
        Collections.shuffle(shuffled, new Random(random.method_43055()));
        double spawnDensity = RustlingSpotsServerConfig.GENERAL.spawnDensity();
        for (class_1923 chunkPos : shuffled) {
            class_2680 below;
            Optional<RustlingSpotFamily> family;
            class_2338 target;
            if (RustlingSpotService.MANAGER.getAll((class_5321<class_1937>)level.method_27983()).size() >= RustlingSpotsServerConfig.GENERAL.maxSpotsPerDimension()) {
                return;
            }
            if (random.method_43058() > spawnDensity || (target = this.pickSurface(level, chunkPos, random, players)) == null || (family = RustlingSpotFamily.fromSurfaceBlock(below = level.method_8320(target.method_10074()), (class_1937)level, target.method_10074())).isEmpty() || !RustlingSpotService.MANAGER.hasSpace((class_5321<class_1937>)level.method_27983(), chunkPos, RustlingSpotsServerConfig.GENERAL.maxSpotsPerDimension())) continue;
            double familyRate = RustlingSpotsFamilySpawnConfig.FAMILIES.spawnRate(family.get());
            if (random.method_43058() > familyRate) continue;
            double minDistanceSq = RustlingSpotsServerConfig.GENERAL.minDistanceBetweenSpots() * RustlingSpotsServerConfig.GENERAL.minDistanceBetweenSpots();
            if (!RustlingSpotService.MANAGER.isFarEnough((class_5321<class_1937>)level.method_27983(), minDistanceSq, target)) continue;
            int maxDistance = RustlingSpotsServerConfig.GENERAL.maxDistanceBetweenSpots();
            if (maxDistance > 0) {
                double nearestSq = RustlingSpotService.MANAGER.nearestDistanceSq((class_5321<class_1937>)level.method_27983(), target);
                double maxDistanceSq = (double)maxDistance * (double)maxDistance;
                if (nearestSq > 0.0 && nearestSq > maxDistanceSq) continue;
            }
            UUID id2 = UUID.randomUUID();
            int variant = RustlingSoundEvents.indexForFamily(family.get());
            RustlingSpot spot = new RustlingSpot(id2, (class_5321<class_1937>)level.method_27983(), target, family.get(), level.method_8510(), variant);
            RustlingSpotService.MANAGER.add(spot);
            for (class_3222 player : level.method_18456()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new RustlingSpotSpawnPacket(spot));
            }
        }
    }

    private Set<class_1923> collectCandidateChunks(List<class_3222> players, class_5819 random) {
        int minDistance = Math.max(1, RustlingSpotsServerConfig.GENERAL.spawnMinDistanceFromPlayer());
        int maxDistance = Math.max(minDistance, RustlingSpotsServerConfig.GENERAL.spawnMaxDistanceFromPlayer());
        int minChunkRadius = Math.max(1, minDistance / 16);
        int maxChunkRadius = Math.max(minChunkRadius, (int)Math.ceil((double)maxDistance / 16.0));
        HashSet<class_1923> candidates = new HashSet<class_1923>();
        for (class_3222 player : players) {
            class_1923 origin = player.method_31476();
            for (int dx = -maxChunkRadius; dx <= maxChunkRadius; ++dx) {
                for (int dz = -maxChunkRadius; dz <= maxChunkRadius; ++dz) {
                    int absDx = origin.field_9181 + dx;
                    int absDz = origin.field_9180 + dz;
                    class_1923 pos = new class_1923(absDx, absDz);
                    double distance = player.method_19538().method_1022(class_243.method_24953((class_2382)pos.method_33943(0)));
                    if (distance < (double)minDistance || distance > (double)maxDistance) continue;
                    candidates.add(pos);
                }
            }
        }
        return candidates;
    }

    private class_2338 pickSurface(class_3218 level, class_1923 chunkPos, class_5819 random, List<class_3222> players) {
        int minDistance = Math.max(1, RustlingSpotsServerConfig.GENERAL.spawnMinDistanceFromPlayer());
        int maxDistance = Math.max(minDistance, RustlingSpotsServerConfig.GENERAL.spawnMaxDistanceFromPlayer());
        for (int attempt = 0; attempt < 8; ++attempt) {
            class_2338 target;
            int x = chunkPos.method_8326() + random.method_43048(16);
            int z = chunkPos.method_8328() + random.method_43048(16);
            class_2338 column = new class_2338(x, level.method_31600() / 2, z);
            if (!level.method_22340(column)) continue;
            if (level.method_27983().equals(class_1937.field_25179)) {
                target = this.findSurfaceUsingHeightmap(level, x, z);
                if (target == null) {
                    target = this.findCaveAirAboveConfiguredBlock(level, x, z);
                }
            } else {
                target = this.findSurfaceUsingHeightmap(level, x, z);
            }
            if (target == null) continue;
            class_2338 finalTarget = target;
            double closestPlayer = players.stream().mapToDouble(p -> p.method_19538().method_1022(class_243.method_24953((class_2382)finalTarget))).min().orElse(Double.MAX_VALUE);
            if (closestPlayer < (double)minDistance || closestPlayer > (double)maxDistance) continue;
            return finalTarget;
        }
        return null;
    }

    private class_2338 findCaveAirAboveConfiguredBlock(class_3218 level, int x, int z) {
        int maxY;
        int minY = level.method_31607();
        int seaLevel = level.method_8615();
        for (int y = maxY = Math.min(level.method_31600() - 2, seaLevel - 5); y >= minY; --y) {
            class_2680 groundState;
            Optional<RustlingSpotFamily> family;
            class_2338 airPos;
            class_2338 groundPos = new class_2338(x, y, z);
            if (!level.method_22340(groundPos) || !level.method_8320(airPos = groundPos.method_10084()).method_26215() || !(family = RustlingSpotFamily.fromSurfaceBlock(groundState = level.method_8320(groundPos), (class_1937)level, groundPos)).isPresent() || family.get() != RustlingSpotFamily.CAVE) continue;
            return airPos;
        }
        return null;
    }

    private class_2338 findAnyValidAirAboveConfiguredBlock(class_3218 level, int x, int z) {
        int maxY;
        int minY = level.method_31607();
        for (int y = maxY = level.method_31600() - 2; y >= minY; --y) {
            class_2680 groundState;
            class_2338 airPos;
            class_2338 groundPos = new class_2338(x, y, z);
            if (!level.method_22340(groundPos) || !level.method_8320(airPos = groundPos.method_10084()).method_26215() || !RustlingSpotFamily.fromSurfaceBlock(groundState = level.method_8320(groundPos), (class_1937)level, groundPos).isPresent()) continue;
            return airPos;
        }
        return null;
    }

    private class_2338 findSurfaceUsingHeightmap(class_3218 level, int x, int z) {
        int y = level.method_8624(class_2902.class_2903.field_13203, x, z);
        if (y <= level.method_31607() + 1 || y >= level.method_31600() - 1) {
            return null;
        }
        class_2338 airPos = new class_2338(x, y, z);
        class_2338 groundPos = airPos.method_10074();
        if (!level.method_22340(airPos)) {
            return null;
        }
        if (!level.method_8320(airPos).method_26215()) {
            return null;
        }
        class_2680 groundState = level.method_8320(groundPos);
        if (RustlingSpotFamily.fromSurfaceBlock(groundState, (class_1937)level, groundPos).isPresent()) {
            return airPos;
        }
        return null;
    }
}

