/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.Optional;
import net.levelscraft7.rustlingspots.config.RustlingSpotsPokemonConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsServerConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsSoundConfig;
import net.levelscraft7.rustlingspots.registry.RustlingSoundEvents;
import net.levelscraft7.rustlingspots.spot.LootPoolService;
import net.levelscraft7.rustlingspots.spot.PokemonSpawnResolver;
import net.levelscraft7.rustlingspots.spot.RustlingMessages;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public final class SpotRewardResolver {
    private SpotRewardResolver() {
    }

    public static void resolve(class_3218 level, class_3222 player, RustlingSpot spot) {
        Optional<String> spawned;
        boolean attemptPokemon;
        if (!RustlingSpotsServerConfig.GENERAL.enabled()) {
            return;
        }
        level.method_14199((class_2394)class_2398.field_11211, (double)spot.getPosition().method_10263() + 0.5, (double)spot.getPosition().method_10264() + 1.0, (double)spot.getPosition().method_10260() + 0.5, 14, 0.3, 0.3, 0.3, 0.01);
        class_5819 random = level.field_9229;
        boolean bl = attemptPokemon = RustlingSpotsPokemonConfig.POKEMON_SPAWN.enable() && random.method_43058() < RustlingSpotsPokemonConfig.POKEMON_SPAWN.encounterChance();
        if (attemptPokemon && (spawned = PokemonSpawnResolver.spawn(level, player, spot, random)).isPresent()) {
            float volume = (float)RustlingSpotsSoundConfig.SOUNDS.pokemonSpawnVolume();
            if (volume > 0.0f) {
                level.method_8396(null, spot.getPosition(), RustlingSoundEvents.POKEMON_SPAWN, class_3419.field_15256, volume, 1.0f);
            }
            player.method_43496(RustlingMessages.randomPokemonMessage(spawned.get(), random));
            return;
        }
        class_1799 stack = SpotRewardResolver.giveLoot(level, spot, random);
        if (!stack.method_7960()) {
            float volume = (float)RustlingSpotsSoundConfig.SOUNDS.itemRewardVolume();
            if (volume > 0.0f) {
                level.method_8396(null, spot.getPosition(), RustlingSoundEvents.ITEM_REWARD, class_3419.field_15256, volume, 1.0f);
            }
            player.method_43496(RustlingMessages.randomLootMessage(stack, random));
        }
    }

    private static class_1799 giveLoot(class_3218 level, RustlingSpot spot, class_5819 random) {
        class_1799 stack = LootPoolService.pickLoot(spot.getFamily(), random);
        if (!stack.method_7960()) {
            class_1799 copy = stack.method_7972();
            double x = (double)spot.getPosition().method_10263() + 0.5;
            double y = (double)spot.getPosition().method_10264() + 1.0;
            double z = (double)spot.getPosition().method_10260() + 0.5;
            class_1542 entity = new class_1542((class_1937)level, x, y, z, copy);
            entity.method_6988();
            level.method_8649((class_1297)entity);
            return copy;
        }
        return class_1799.field_8037;
    }
}

