/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_5321;

public class RustlingSpotManager {
    private final Map<class_5321<class_1937>, Map<UUID, RustlingSpot>> perDimension = new ConcurrentHashMap<class_5321<class_1937>, Map<UUID, RustlingSpot>>();

    public Collection<RustlingSpot> getAll(class_5321<class_1937> dimension) {
        return this.perDimension.getOrDefault(dimension, Map.of()).values();
    }

    public Optional<RustlingSpot> get(class_5321<class_1937> dimension, UUID id) {
        return Optional.ofNullable((RustlingSpot)this.perDimension.getOrDefault(dimension, Map.of()).get(id));
    }

    public void add(RustlingSpot spot) {
        this.perDimension.computeIfAbsent(spot.getDimension(), dim -> new ConcurrentHashMap()).put(spot.getId(), spot);
    }

    public void remove(RustlingSpot spot) {
        Map<UUID, RustlingSpot> map = this.perDimension.get(spot.getDimension());
        if (map != null) {
            map.remove(spot.getId());
            if (map.isEmpty()) {
                this.perDimension.remove(spot.getDimension());
            }
        }
    }

    public boolean hasSpace(class_5321<class_1937> dimension, class_1923 chunkPos, int maxPerDimension) {
        Map map = this.perDimension.getOrDefault(dimension, Map.of());
        if (map.size() >= maxPerDimension) {
            return false;
        }
        long inChunk = map.values().stream().filter(spot -> new class_1923(spot.getPosition()).equals((Object)chunkPos)).count();
        return inChunk < 1L;
    }

    public boolean isFarEnough(class_5321<class_1937> dimension, double minDistanceSq, class_2338 position) {
        return this.getAll(dimension).stream().allMatch(existing -> existing.getPosition().method_10262((class_2382)position) >= minDistanceSq);
    }

    public double nearestDistanceSq(class_5321<class_1937> dimension, class_2338 position) {
        return this.getAll(dimension).stream().mapToDouble(existing -> existing.getPosition().method_10262((class_2382)position)).min().orElse(-1.0);
    }

    public long countWithin(class_5321<class_1937> dimension, class_2338 position, double radius) {
        double radiusSq = radius * radius;
        return this.getAll(dimension).stream().filter(existing -> existing.getPosition().method_10262((class_2382)position) <= radiusSq).count();
    }
}

