/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.levelscraft7.rustlingspots.network.packet.RustlingSpotSpawnPacket;
import net.levelscraft7.rustlingspots.registry.RustlingSoundEvents;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.levelscraft7.rustlingspots.spot.RustlingSpotService;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8710;

public final class RustlingSpotCommands {
    private static final DynamicCommandExceptionType UNKNOWN_FAMILY = new DynamicCommandExceptionType(input -> class_2561.method_43469((String)"command.rustlingspots.unknown_family", (Object[])new Object[]{input}));
    private static final long SPAWN_INTERACTION_DELAY_TICKS = 100L;

    private RustlingSpotCommands() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)class_2170.method_9247((String)"rustlingspots").requires(source -> source.method_9259(2));
        root.then(class_2170.method_9247((String)"spawn").then(class_2170.method_9244((String)"family", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(RustlingSpotCommands.familyNames(), (SuggestionsBuilder)builder)).executes(ctx -> RustlingSpotCommands.spawnSpot((class_2168)ctx.getSource(), RustlingSpotCommands.parseFamily(StringArgumentType.getString((CommandContext)ctx, (String)"family"))))));
        dispatcher.register(root);
    }

    private static RustlingSpotFamily parseFamily(String input) throws CommandSyntaxException {
        try {
            return RustlingSpotFamily.valueOf(input.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            throw UNKNOWN_FAMILY.create((Object)input);
        }
    }

    private static int spawnSpot(class_2168 source, RustlingSpotFamily family) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        class_3218 level = player.method_51469();
        class_243 base = player.method_19538();
        class_243 shifted = base.method_1031(1.0, 0.0, 0.0);
        class_2338 pos = new class_2338((int)Math.floor(shifted.method_10216()), (int)Math.floor(shifted.method_10214()), (int)Math.floor(shifted.method_10215()));
        UUID id = UUID.randomUUID();
        int variant = RustlingSoundEvents.indexForFamily(family);
        RustlingSpot spot = new RustlingSpot(id, (class_5321<class_1937>)level.method_27983(), pos, family, level.method_8510(), variant);
        RustlingSpotService.MANAGER.add(spot);
        for (class_3222 p : level.method_18456()) {
            ServerPlayNetworking.send((class_3222)p, (class_8710)new RustlingSpotSpawnPacket(spot));
        }
        RustlingSpotService.INTERACTION_BLOCKER.blockForTicks(player.method_5667(), level.method_8510(), 100L);
        source.method_9226(() -> class_2561.method_43469((String)"command.rustlingspots.spawn.success", (Object[])new Object[]{family.name().toLowerCase(Locale.ROOT), pos.method_10263(), pos.method_10264(), pos.method_10260()}), true);
        return 1;
    }

    private static List<String> familyNames() {
        return Arrays.stream(RustlingSpotFamily.values()).map(family -> family.name().toLowerCase(Locale.ROOT)).toList();
    }
}

