/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.Optional;
import net.levelscraft7.rustlingspots.config.RustlingSpotsPokemonConfig;
import net.levelscraft7.rustlingspots.spot.PokemonPoolService;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.minecraft.class_2168;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PokemonSpawnResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PokemonSpawnResolver.class);

    private PokemonSpawnResolver() {
    }

    public static Optional<String> spawn(class_3218 level, class_3222 player, RustlingSpot spot, class_5819 random) {
        if (!RustlingSpotsPokemonConfig.POKEMON_SPAWN.enable()) {
            return Optional.empty();
        }
        PokemonPoolService.PokemonEntry entry = PokemonPoolService.pickRandom(level, spot, random);
        if (entry == null) {
            return Optional.empty();
        }
        String species = PokemonSpawnResolver.sanitizeSpecies(entry.species());
        if (species.isEmpty()) {
            LOGGER.warn("Failed to resolve Pok\u00e9mon species '{}' for rustling spot", (Object)entry.species());
            return Optional.empty();
        }
        boolean shiny = PokemonSpawnResolver.resolveShiny(random, entry);
        int levelRoll = PokemonSpawnResolver.randomLevel(entry, random);
        return PokemonSpawnResolver.tryCobblemonSpawn(level, player, spot, species, shiny, levelRoll).map(PokemonSpawnResolver::formatForMessage);
    }

    private static Optional<String> tryCobblemonSpawn(class_3218 level, class_3222 player, RustlingSpot spot, String species, boolean shiny, int rolledLevel) {
        if (level.method_8503() == null) {
            return Optional.empty();
        }
        class_243 spawnOrigin = class_243.method_24953((class_2382)spot.getPosition());
        class_2168 source = level.method_8503().method_3739().method_9227(level).method_9206(2).method_9208(spawnOrigin).method_9217();
        String command = "pokespawn " + species + " level=" + rolledLevel + (shiny ? " shiny" : "");
        try {
            int result = level.method_8503().method_3734().method_9235().execute(command, (Object)source);
            if (result <= 0) {
                LOGGER.warn("Cobblemon not present or failed to spawn Pok\u00e9mon {}", (Object)species);
                return Optional.empty();
            }
            return Optional.of(species);
        }
        catch (Exception e) {
            LOGGER.warn("Error while executing Cobblemon spawn command for {}", (Object)species, (Object)e);
            return Optional.empty();
        }
    }

    private static boolean resolveShiny(class_5819 random, PokemonPoolService.PokemonEntry entry) {
        if (entry.shiny() != null) {
            return entry.shiny();
        }
        if (entry.shinyChance() != null) {
            return random.method_43058() < entry.shinyChance();
        }
        return random.method_43058() < RustlingSpotsPokemonConfig.POKEMON_SPAWN.defaultShinyChance();
    }

    private static String sanitizeSpecies(String raw) {
        if (raw == null) {
            return "";
        }
        String trimmed = raw.trim();
        int idx = trimmed.indexOf(":");
        return idx >= 0 ? trimmed.substring(idx + 1) : trimmed;
    }

    private static int randomLevel(PokemonPoolService.PokemonEntry entry, class_5819 random) {
        int min = entry.resolvedMinLevel();
        int max = entry.resolvedMaxLevel();
        if (max < min) {
            return min;
        }
        return random.method_43048(max - min + 1) + min;
    }

    private static String formatForMessage(String speciesId) {
        if (speciesId.isEmpty()) {
            return speciesId;
        }
        String cleaned = PokemonSpawnResolver.sanitizeSpecies(speciesId);
        return cleaned.substring(0, 1).toUpperCase() + cleaned.substring(1);
    }
}

