/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.registry;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;

public final class RustlingSoundEvents {
    public static class_3414 POKEMON_SPAWN;
    public static class_3414 ITEM_REWARD;
    public static class_3414 GRASS_AMBIENT;
    public static class_3414 SAND_AMBIENT;
    public static class_3414 WATER_AMBIENT;
    public static class_3414 SNOW_AMBIENT;
    public static class_3414 LEAVES_AMBIENT;
    public static class_3414 CAVE_AMBIENT;
    public static class_3414 NETHERFLAMME_AMBIENT;
    public static class_3414 SOULFLAME_AMBIENT;
    public static class_3414 FLYING_AMBIENT;
    private static List<class_3414> AMBIENT_VARIANTS;
    private static final Map<RustlingSpotFamily, class_3414> AMBIENT_BY_FAMILY;

    private static class_2960 id(String path) {
        return class_2960.method_60655((String)"rustlingspots", (String)path);
    }

    private RustlingSoundEvents() {
    }

    public static void register() {
        GRASS_AMBIENT = RustlingSoundEvents.register("spot/ambient/grass");
        SAND_AMBIENT = RustlingSoundEvents.register("spot/ambient/sand");
        WATER_AMBIENT = RustlingSoundEvents.register("spot/ambient/water");
        SNOW_AMBIENT = RustlingSoundEvents.register("spot/ambient/snow");
        LEAVES_AMBIENT = RustlingSoundEvents.register("spot/ambient/leaves");
        CAVE_AMBIENT = RustlingSoundEvents.register("spot/ambient/cave");
        NETHERFLAMME_AMBIENT = RustlingSoundEvents.register("spot/ambient/netherflamme");
        SOULFLAME_AMBIENT = RustlingSoundEvents.register("spot/ambient/soulflame");
        FLYING_AMBIENT = RustlingSoundEvents.register("spot/ambient/flying");
        POKEMON_SPAWN = RustlingSoundEvents.register("spot/pokemon_spawn");
        ITEM_REWARD = RustlingSoundEvents.register("spot/item_reward");
        AMBIENT_VARIANTS = List.of(GRASS_AMBIENT, SAND_AMBIENT, WATER_AMBIENT, SNOW_AMBIENT, LEAVES_AMBIENT, CAVE_AMBIENT, NETHERFLAMME_AMBIENT, SOULFLAME_AMBIENT, FLYING_AMBIENT);
        AMBIENT_BY_FAMILY.put(RustlingSpotFamily.GRASS, GRASS_AMBIENT);
        AMBIENT_BY_FAMILY.put(RustlingSpotFamily.SAND, SAND_AMBIENT);
        AMBIENT_BY_FAMILY.put(RustlingSpotFamily.WATER, WATER_AMBIENT);
        AMBIENT_BY_FAMILY.put(RustlingSpotFamily.SNOW, SNOW_AMBIENT);
        AMBIENT_BY_FAMILY.put(RustlingSpotFamily.LEAVES, LEAVES_AMBIENT);
        AMBIENT_BY_FAMILY.put(RustlingSpotFamily.CAVE, CAVE_AMBIENT);
        AMBIENT_BY_FAMILY.put(RustlingSpotFamily.NETHERFLAMME, NETHERFLAMME_AMBIENT);
        AMBIENT_BY_FAMILY.put(RustlingSpotFamily.SOULFLAME, SOULFLAME_AMBIENT);
        AMBIENT_BY_FAMILY.put(RustlingSpotFamily.FLYING, FLYING_AMBIENT);
    }

    public static class_3414 ambientVariant(int index) {
        if (AMBIENT_VARIANTS == null || AMBIENT_VARIANTS.isEmpty()) {
            return GRASS_AMBIENT;
        }
        if (index < 0 || index >= AMBIENT_VARIANTS.size()) {
            return AMBIENT_VARIANTS.get(0);
        }
        return AMBIENT_VARIANTS.get(index);
    }

    public static int indexForFamily(RustlingSpotFamily family) {
        class_3414 ev = AMBIENT_BY_FAMILY.get((Object)family);
        if (ev == null || AMBIENT_VARIANTS == null) {
            return 0;
        }
        return AMBIENT_VARIANTS.indexOf(ev);
    }

    public static int ambientVariantCount() {
        return AMBIENT_VARIANTS == null ? 0 : AMBIENT_VARIANTS.size();
    }

    private static class_3414 register(String path) {
        class_2960 rid = RustlingSoundEvents.id(path);
        return (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)rid, (Object)class_3414.method_47908((class_2960)rid));
    }

    static {
        AMBIENT_BY_FAMILY = new EnumMap<RustlingSpotFamily, class_3414>(RustlingSpotFamily.class);
    }
}

