/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.config;

import java.nio.file.Path;
import java.util.List;
import net.levelscraft7.rustlingspots.config.ConfigIO;

public final class RustlingSpotsServerConfig {
    public static General GENERAL = General.defaults();
    private static final Path PATH = ConfigIO.configPath("rustlingspots/rustlingspots-server.json");

    private RustlingSpotsServerConfig() {
    }

    public static void load() {
        GENERAL = ConfigIO.loadOrCreate(PATH, General.defaults(), General.class);
    }

    public static final class General {
        public boolean enabled = true;
        public boolean enable_logging = false;
        public double spawn_density = 0.4;
        public int min_distance_between_spots = 48;
        public int max_distance_between_spots = 180;
        public int spawn_min_distance_from_player = 60;
        public int spawn_max_distance_from_player = 150;
        public int spot_lifetime_ticks = 6000;
        public int despawn_if_no_player_within = 150;
        public double interaction_radius = 1.5;
        public double interaction_vertical_allowance = 2.0;
        public int max_spots_per_dimension = 25;
        public List<String> allowed_dimensions = List.of("minecraft:overworld", "minecraft:the_nether", "minecraft:the_end");

        public static General defaults() {
            return new General();
        }

        public boolean enabled() {
            return this.enabled;
        }

        public boolean loggingEnabled() {
            return this.enable_logging;
        }

        public double spawnDensity() {
            return this.spawn_density;
        }

        public int minDistanceBetweenSpots() {
            return this.min_distance_between_spots;
        }

        public int maxDistanceBetweenSpots() {
            return this.max_distance_between_spots;
        }

        public int spawnMinDistanceFromPlayer() {
            return this.spawn_min_distance_from_player;
        }

        public int spawnMaxDistanceFromPlayer() {
            return this.spawn_max_distance_from_player;
        }

        public int spotLifetimeTicks() {
            return this.spot_lifetime_ticks;
        }

        public int despawnIfNoPlayerWithin() {
            return this.despawn_if_no_player_within;
        }

        public double interactionRadius() {
            return this.interaction_radius;
        }

        public double interactionVerticalAllowance() {
            return this.interaction_vertical_allowance;
        }

        public int maxSpotsPerDimension() {
            return this.max_spots_per_dimension;
        }

        public List<? extends String> allowedDimensions() {
            return this.allowed_dimensions;
        }
    }
}

